/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.distcomp.pmode.io.Selectable;
import com.mathworks.toolbox.distcomp.pmode.io.TransmissionChannel;
import com.mathworks.toolbox.distcomp.pmode.io.UnableToSendDueToNoAddressBookEntryException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.Awaitable;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;

public final class DirectCommunicationGroup
implements Runnable,
CommunicationGroup {
    private final Selector fSelector;
    private final Map<Instance, TransmissionChannel> fTransmissionChannelAddressBook;
    private final Set<Instance> fSeenInstances;
    private final ConcurrentUniqueQueue<Runnable> fRunnables = new ConcurrentUniqueQueue();
    private Dispatcher<Message> fDispatch = null;
    private ExecutorService fDispatchExec = null;
    private final AtomicBoolean fKeepGoing;
    private Thread fThread;
    private final ObservableMessageRegistry fReturnRegistry;
    private final ErrorHandler fErrorHandler;
    private final Instance fThisInstance;
    private final Set<Instance> fExpectedInstances = new HashSet<Instance>();
    private final List<CommunicationObserver> fCommunicationObservers = Collections.synchronizedList(new LinkedList());

    private DirectCommunicationGroup(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Collection<Connection> collection, Instance instance) {
        Log.LOGGER.log(DistcompLevel.FIVE, "In DirectCommunicationGroup constructor with " + collection.size() + " Connections.");
        this.fErrorHandler = errorHandler;
        this.fReturnRegistry = observableMessageRegistry;
        this.fThisInstance = instance;
        this.fKeepGoing = new AtomicBoolean(true);
        this.fTransmissionChannelAddressBook = Collections.synchronizedMap(new HashMap());
        this.fSeenInstances = Collections.synchronizedSet(new HashSet());
        Log.LOGGER.log(DistcompLevel.SIX, "About to call Selector.open()");
        try {
            this.fSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new PeerMessagingRuntimeException("Unexpected IOException while opening a selector for " + instance, iOException);
        }
        Log.LOGGER.log(DistcompLevel.SIX, "Called Selector.open()");
        for (Connection connection : collection) {
            this.addConnection(connection);
        }
        Log.LOGGER.log(DistcompLevel.FIVE, "Exiting DirectCommunicationGroup constructor.");
    }

    public static DirectCommunicationGroup build(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Connection[] connectionArray, Instance instance) {
        List<Connection> list = Arrays.asList(connectionArray);
        DirectCommunicationGroup directCommunicationGroup = new DirectCommunicationGroup(errorHandler, observableMessageRegistry, list, instance);
        directCommunicationGroup.startSelectThread();
        return directCommunicationGroup;
    }

    private void startSelectThread() {
        this.fThread = new Thread((Runnable)this, "CommGroup select thread " + this.toString());
        this.fThread.setDaemon(true);
        this.fThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransmissionChannel[] getAllTransmissionChannels() {
        Map<Instance, TransmissionChannel> map = this.fTransmissionChannelAddressBook;
        synchronized (map) {
            TransmissionChannel[] transmissionChannelArray = new TransmissionChannel[this.fTransmissionChannelAddressBook.values().size()];
            return this.fTransmissionChannelAddressBook.values().toArray(transmissionChannelArray);
        }
    }

    @Override
    public Awaitable setDispatcher(Dispatcher<Message> dispatcher, ExecutorService executorService) {
        this.fDispatch = dispatcher;
        this.fDispatchExec = executorService;
        Log.LOGGER.log(DistcompLevel.FIVE, "Attaching dispatcher: " + dispatcher + " to " + this.getAddressBookSize() + " channels");
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            transmissionChannel.setDispatcher(dispatcher, executorService);
        }
        return new Awaitable(){

            public boolean await(long l, TimeUnit timeUnit) {
                return true;
            }
        };
    }

    @Override
    public void sendTo(List<Instance> list, Message message) {
        Log.LOGGER.log(DistcompLevel.FIVE, "sendTo(list) - that's " + list.size());
        this.sendToImpl(list, message);
    }

    @Override
    public void returnTo(Instance instance, ReturnMessage returnMessage) {
        this.sendToImpl(Arrays.asList(instance), returnMessage);
    }

    @Override
    public void returnTo(List<Instance> list, ReturnMessage returnMessage) {
        Log.LOGGER.log(DistcompLevel.FIVE, "returnTo(list) - that's " + list.size());
        this.sendToImpl(list, returnMessage);
    }

    @Override
    public void sendTo(List<Instance> list, ObservableMessage observableMessage, MessageObserver messageObserver) {
        Log.LOGGER.log(DistcompLevel.FIVE, "sendTo(list) with observer - that's " + list.size());
        this.sendToWithObserverImpl(list, observableMessage, messageObserver);
    }

    @Override
    public void sendTo(Instance instance, ObservableMessage observableMessage, MessageObserver messageObserver) {
        this.sendToWithObserverImpl(Arrays.asList(instance), observableMessage, messageObserver);
    }

    @Override
    public void sendTo(Instance instance, Message message) {
        this.sendToImpl(Arrays.asList(instance), message);
    }

    private Map<Instance, TransmissionChannel> getCurrentDestinations(List<Instance> list, Message message) {
        HashMap<Instance, TransmissionChannel> hashMap = new HashMap<Instance, TransmissionChannel>();
        for (Instance instance : list) {
            TransmissionChannel transmissionChannel = this.fTransmissionChannelAddressBook.get(instance);
            if (transmissionChannel != null) {
                hashMap.put(instance, transmissionChannel);
                continue;
            }
            if (this.fSeenInstances.contains(instance)) {
                Log.LOGGER.log(DistcompLevel.TWO, "DirectCommunicationGroup can no longer send " + message + " to " + instance);
                continue;
            }
            Log.LOGGER.log(DistcompLevel.TWO, "DirectCommunicationGroup cannot send " + message + " to " + instance);
            throw new UnableToSendDueToNoAddressBookEntryException(message, instance);
        }
        return hashMap;
    }

    private void sendToWithObserverImpl(List<Instance> list, ObservableMessage observableMessage, MessageObserver messageObserver) {
        Log.LOGGER.log(DistcompLevel.FIVE, "sendTo with observer: " + messageObserver + " of message: " + observableMessage + " to: " + list);
        Map<Instance, TransmissionChannel> map = this.getCurrentDestinations(list, observableMessage);
        messageObserver.expectReturnsFrom(observableMessage.getSequenceNumber(), new ArrayList<Instance>(map.keySet()));
        this.fReturnRegistry.addReturnMessageObserver(observableMessage, list, messageObserver);
        this.sendToChannel(map.values(), observableMessage);
    }

    private void sendToImpl(List<Instance> list, Message message) {
        Map<Instance, TransmissionChannel> map = this.getCurrentDestinations(list, message);
        this.sendToChannel(map.values(), message);
    }

    private void sendToChannel(Collection<TransmissionChannel> collection, Message message) {
        for (TransmissionChannel transmissionChannel : collection) {
            try {
                Log.LOGGER.log(DistcompLevel.FIVE, "Enqueuing a message: " + message + " to: " + transmissionChannel.getRemoteProcess());
                transmissionChannel.enqueueMessageForSending(message);
                this.invokeOnSelectThread(new AddOpWrite(transmissionChannel));
            }
            catch (IOException iOException) {
                Log.LOGGER.log(DistcompLevel.ONE, "IOException during sendTo", iOException);
                this.fErrorHandler.writeError(transmissionChannel.getRemoteProcess(), iOException);
            }
            catch (Throwable throwable) {
                Log.LOGGER.log(DistcompLevel.ONE, "Unhandled Throwable during sendTo: ", throwable);
                this.fErrorHandler.writeError(transmissionChannel.getRemoteProcess(), throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Instance> getConnectedInstances() {
        Map<Instance, TransmissionChannel> map = this.fTransmissionChannelAddressBook;
        synchronized (map) {
            return new ArrayList<Instance>(this.fTransmissionChannelAddressBook.keySet());
        }
    }

    @Override
    public Instance getLocalInstance() {
        return this.fThisInstance;
    }

    private int getAddressBookSize() {
        return this.fTransmissionChannelAddressBook.size();
    }

    @Override
    public void closeStreams() {
        Log.LOGGER.log(DistcompLevel.FIVE, "Closing channels");
        this.fKeepGoing.set(false);
        this.fSelector.wakeup();
        try {
            this.fThread.join(200L);
            Log.LOGGER.log(DistcompLevel.FIVE, "Joined select() thread, closing channels. fThread.isAlive() = " + this.fThread.isAlive());
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.FIVE, "Interruption during join", interruptedException);
        }
        for (TransmissionChannel transmissionChannel : this.getAllTransmissionChannels()) {
            try {
                transmissionChannel.close();
            }
            catch (IOException iOException) {
                Log.LOGGER.log(DistcompLevel.TWO, "IOException during close: ", iOException);
            }
        }
        Log.LOGGER.log(DistcompLevel.FIVE, "Clearing TransmissionChannelAddressBook");
        this.fTransmissionChannelAddressBook.clear();
        try {
            this.fSelector.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.TWO, "IOException during selector close: ", iOException);
        }
    }

    @Override
    public void addConnection(final Connection connection) {
        final TransmissionChannel transmissionChannel = new TransmissionChannel(connection, this.fErrorHandler);
        Instance instance = connection.getRemoteInstance();
        this.fTransmissionChannelAddressBook.put(instance, transmissionChannel);
        this.fSeenInstances.add(instance);
        for (CommunicationObserver communicationObserver : this.fCommunicationObservers) {
            communicationObserver.communicationEstablished(connection.getRemoteInstance());
        }
        this.invokeOnSelectThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.LOGGER.log(DistcompLevel.FIVE, "Registering " + transmissionChannel + " with selector.");
                    transmissionChannel.registerWithSelector(DirectCommunicationGroup.this.fSelector, 1, transmissionChannel);
                    DirectCommunicationGroup.this.fExpectedInstances.add(connection.getRemoteInstance());
                    if (DirectCommunicationGroup.this.fDispatch != null) {
                        Log.LOGGER.log(DistcompLevel.FIVE, "Adding dispatcher to " + transmissionChannel);
                        transmissionChannel.setDispatcher(DirectCommunicationGroup.this.fDispatch, DirectCommunicationGroup.this.fDispatchExec);
                    }
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(DistcompLevel.TWO, "IOException while adding a new connection", iOException);
                }
            }

            public String toString() {
                return "addConnection( " + connection + " )";
            }
        });
    }

    @Override
    public void removeInstance(Instance instance) {
        this.removeInstanceNoNotification(instance);
        this.notifyLostCommunication(instance, null);
    }

    private void removeInstanceNoNotification(final Instance instance) {
        final TransmissionChannel transmissionChannel = this.fTransmissionChannelAddressBook.remove(instance);
        if (transmissionChannel == null) {
            Log.LOGGER.log(DistcompLevel.FIVE, "Attempted to remove " + instance + " that is not in address book");
        }
        this.invokeOnSelectThread(new Runnable(){

            @Override
            public void run() {
                Log.LOGGER.log(DistcompLevel.FIVE, "About to call safeCloseTransmissionChannel for " + instance);
                this.safeCloseTransmissionChannel(transmissionChannel);
                Log.LOGGER.log(DistcompLevel.FIVE, "About to remove " + instance + " from fExpectedInstances");
                DirectCommunicationGroup.this.fExpectedInstances.remove(instance);
                Log.LOGGER.log(DistcompLevel.FIVE, "Finished removing " + instance + " from fExpectedInstances");
            }

            private void safeCloseTransmissionChannel(TransmissionChannel transmissionChannel2) {
                if (transmissionChannel2 == null) {
                    return;
                }
                try {
                    transmissionChannel2.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(DistcompLevel.TWO, "IOException closing " + transmissionChannel2, iOException);
                }
            }

            public String toString() {
                return "removeInstance( " + instance + " )";
            }
        });
    }

    @Override
    public void addCommunicationObserver(CommunicationObserver communicationObserver) {
        this.fCommunicationObservers.add(communicationObserver);
    }

    @Override
    public void removeCommunicationObserver(CommunicationObserver communicationObserver) {
        this.fCommunicationObservers.remove(communicationObserver);
    }

    private void invokeOnSelectThread(Runnable runnable) {
        ((ConcurrentUniqueQueue)this.fRunnables).add(runnable);
        this.fSelector.wakeup();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            long l = -1L;
            long l2 = 5000L;
            while (true) {
                if (!this.fKeepGoing.get() && l == -1L) {
                    Log.LOGGER.log(DistcompLevel.FIVE, "Shutting down select() thread");
                    l = System.currentTimeMillis() + 100L;
                    l2 = 50L;
                }
                if (l != -1L && System.currentTimeMillis() > l) {
                    Log.LOGGER.log(DistcompLevel.FIVE, "select() thread returning");
                    return;
                }
                this.drainRunnableQueue();
                if (this.doSelect(l2)) {
                    Log.LOGGER.log(DistcompLevel.FIVE, "DirectCommunicationGroup.doSelect() returned TRUE, select thread exiting");
                    return;
                }
                this.detectLostInstances();
                continue;
                break;
            }
        }
        catch (Error error) {
            Log.LOGGER.log(DistcompLevel.ONE, "DirectCommunicationGroup caught an Error.", error);
            this.fErrorHandler.communicationError(error);
            throw error;
        }
        finally {
            Log.LOGGER.log(DistcompLevel.TWO, "DirectCommunicationGroup select thread exiting.");
        }
    }

    private void drainRunnableQueue() {
        Runnable runnable = (Runnable)((ConcurrentUniqueQueue)this.fRunnables).poll();
        while (runnable != null) {
            try {
                Log.LOGGER.log(DistcompLevel.SIX, "Running " + runnable + " on select thread");
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                Log.LOGGER.log(DistcompLevel.ONE, "RuntimeException thrown by runnable on select thread.", runtimeException);
            }
            catch (Error error) {
                Log.LOGGER.log(DistcompLevel.ONE, "Error thrown by runnable on select thread.", error);
                throw error;
            }
            runnable = (Runnable)((ConcurrentUniqueQueue)this.fRunnables).poll();
        }
    }

    private boolean doSelect(long l) {
        int n;
        try {
            n = this.fSelector.select(l);
        }
        catch (CancelledKeyException cancelledKeyException) {
            DirectCommunicationGroup.logInvalidKeys(DistcompLevel.FIVE, this.fSelector);
            Log.LOGGER.log(DistcompLevel.TWO, "CancelledKeyException calling select() - select thread will continue.");
            return false;
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.TWO, "IOException calling select() - returning", iOException);
            return true;
        }
        catch (ClosedSelectorException closedSelectorException) {
            if (this.fKeepGoing.get()) {
                Log.LOGGER.log(DistcompLevel.TWO, "Selector was closed unexpectedly - returning", closedSelectorException);
            } else {
                Log.LOGGER.log(DistcompLevel.FOUR, "Selector was closed as expected - returning", closedSelectorException);
            }
            return true;
        }
        if (n != 0) {
            LinkedList<BrokenInstance> linkedList = new LinkedList<BrokenInstance>();
            Iterator<SelectionKey> iterator = this.fSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                Object object = selectionKey.attachment();
                if (object instanceof Selectable) {
                    Selectable selectable = (Selectable)object;
                    try {
                        selectable.handleSelect();
                    }
                    catch (EOFException eOFException) {
                        Log.LOGGER.log(DistcompLevel.SIX, "EOF during handleSelect() on " + this.fThisInstance);
                        linkedList.add(new BrokenInstance(selectable.getRemoteProcess(), eOFException));
                    }
                    catch (IOException | RuntimeException exception) {
                        Log.LOGGER.log(DistcompLevel.ONE, "Exception during handleSelect() on " + this.fThisInstance + ": ", exception);
                        linkedList.add(new BrokenInstance(selectable.getRemoteProcess(), exception));
                    }
                    continue;
                }
                Log.LOGGER.log(DistcompLevel.ONE, "Couldn't handle attachment: " + object);
                assert (false) : "Failed to handle SelectionKey attachment";
            }
            if (!linkedList.isEmpty()) {
                this.removeInstancesAndNotifyErrorHandler(linkedList);
            }
        }
        return false;
    }

    private static void logInvalidKeys(Level level, Selector selector) {
        if (Log.LOGGER.isLoggable(DistcompLevel.FIVE)) {
            for (SelectionKey selectionKey : selector.keys()) {
                if (selectionKey.isValid()) continue;
                Log.LOGGER.log(level, selectionKey + " is not valid.");
            }
        }
    }

    private void removeInstancesAndNotifyErrorHandler(List<BrokenInstance> list) {
        for (BrokenInstance brokenInstance : list) {
            brokenInstance.removeInstanceAndNotifyErrorHandler(this);
        }
    }

    private void detectLostInstances() {
        if (this.fKeepGoing.get()) {
            Collection<Instance> collection = this.getRegisteredInstances();
            Collection<Instance> collection2 = this.setdiff(this.fExpectedInstances, collection);
            for (Instance instance : collection2) {
                Log.LOGGER.log(DistcompLevel.FOUR, "Expected " + instance + " to be registered with selector but it was not");
                this.removeInstance(instance);
            }
            Collection<Instance> collection3 = this.setdiff(collection, this.fExpectedInstances);
            if (!collection3.isEmpty()) {
                Log.LOGGER.log(DistcompLevel.ONE, "DirectCommunicationGroup in unexpected state - there are Instances registered with the selector that we did not put there.");
                assert (false) : "Unexpected instance registered with selector";
            }
        }
    }

    private Collection<Instance> setdiff(Collection<Instance> collection, Collection<Instance> collection2) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>(collection);
        arrayList.removeAll(collection2);
        return arrayList;
    }

    private Collection<Instance> getRegisteredInstances() {
        int n = this.fSelector.keys().size();
        Vector<Instance> vector = new Vector<Instance>(n);
        for (SelectionKey selectionKey : this.fSelector.keys()) {
            Object object = selectionKey.attachment();
            if (object instanceof Selectable) {
                Selectable selectable = (Selectable)object;
                vector.add(selectable.getRemoteProcess());
                continue;
            }
            Log.LOGGER.log(DistcompLevel.ONE, "DirectCommunicationGroup in unexpected state - found non-Selectable [" + object + "] attached to selection key.");
            assert (false) : "Found non-Selectable attached to selection key";
        }
        return vector;
    }

    private void notifyLostCommunication(Instance instance, @Nullable Throwable throwable) {
        assert (instance != null) : "Must specify the instance we've lost communication to";
        Log.LOGGER.log(DistcompLevel.FIVE, "Notifying error handler of loss of communication to " + instance);
        for (CommunicationObserver communicationObserver : this.fCommunicationObservers) {
            communicationObserver.communicationLost(instance, throwable);
        }
        this.fErrorHandler.lostCommunication(instance, throwable);
    }

    private static final class ConcurrentUniqueQueue<E> {
        private final ReentrantLock fLock = new ReentrantLock();
        private final Queue<E> fQueue = new LinkedList();
        private final Set<E> fSet = new HashSet();

        private ConcurrentUniqueQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(E e) {
            if (e == null) {
                throw new NullPointerException("A ConcurrentUniqueQueue can not contain nulls");
            }
            this.fLock.lock();
            try {
                if (this.fSet.add(e)) {
                    this.fQueue.add(e);
                }
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private E poll() {
            this.fLock.lock();
            try {
                E e = this.fQueue.poll();
                if (e != null) {
                    this.fSet.remove(e);
                }
                E e2 = e;
                return e2;
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    private static final class AddOpWrite
    implements Runnable {
        private final TransmissionChannel fTransmissionChannel;

        private AddOpWrite(TransmissionChannel transmissionChannel) {
            this.fTransmissionChannel = transmissionChannel;
        }

        @Override
        public void run() {
            this.fTransmissionChannel.addInterestOps(4);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AddOpWrite addOpWrite = (AddOpWrite)object;
            return this.fTransmissionChannel.equals(addOpWrite.fTransmissionChannel);
        }

        public int hashCode() {
            return this.fTransmissionChannel.hashCode();
        }

        public String toString() {
            return "addInterestOps(SelectionKey.OP_WRITE) for " + this.fTransmissionChannel;
        }
    }

    private static class BrokenInstance {
        private final Instance fInstance;
        private final Throwable fThrownException;

        private BrokenInstance(Instance instance, Throwable throwable) {
            this.fInstance = instance;
            this.fThrownException = throwable;
        }

        private void removeInstanceAndNotifyErrorHandler(DirectCommunicationGroup directCommunicationGroup) {
            directCommunicationGroup.removeInstanceNoNotification(this.fInstance);
            directCommunicationGroup.notifyLostCommunication(this.fInstance, this.fThrownException);
        }
    }
}

