/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.parallel.util.concurrent.Awaitable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class ResponseTracker<V>
implements Awaitable {
    private final Set<V> fGotResponse;
    private boolean fGotExpectedResponseList = false;
    private final Set<V> fNeedResponse;
    private final CountDownLatch fCountDownLatch = new CountDownLatch(1);

    public ResponseTracker() {
        this.fGotResponse = new HashSet<V>();
        this.fNeedResponse = new HashSet<V>();
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fCountDownLatch.await(l, timeUnit);
    }

    public synchronized boolean setExpectedResponders(Collection<? extends V> collection) {
        assert (!this.fGotExpectedResponseList) : "setExpectedResponders called multiple times";
        Log.LOGGER.fine("ResponseTracker.setExpectedResponders(" + collection + ")");
        this.fNeedResponse.addAll(collection);
        this.fGotExpectedResponseList = true;
        return this.fireLatchIfComplete();
    }

    public synchronized boolean addResponder(V v) {
        Log.LOGGER.fine("ResponseTracker.addResponder(" + v + ")");
        this.fGotResponse.add(v);
        return this.fireLatchIfComplete();
    }

    private synchronized boolean fireLatchIfComplete() {
        if (this.fGotExpectedResponseList && this.fGotResponse.containsAll(this.fNeedResponse)) {
            Log.LOGGER.info("ResponseTracker got all responses, about to fire.");
            this.fCountDownLatch.countDown();
            return true;
        }
        if (Log.LOGGER.isLoggable(Level.FINE)) {
            if (this.fGotExpectedResponseList) {
                HashSet<V> hashSet = new HashSet<V>(this.fNeedResponse);
                hashSet.removeAll(this.fGotResponse);
                Log.LOGGER.fine("ResponseTracker not ready to fire. Waiting for: " + hashSet);
            } else {
                Log.LOGGER.fine("ResponseTracker not ready to fire - no expected responders.");
            }
        }
        return false;
    }
}

