/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.TopologyChangeType;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class TopologyMessage
extends MCommand {
    private final TopologyChangeType fType;
    private final Collection<Instance> fTargets;
    private final Instance fSource;

    private TopologyMessage(Collection<Instance> collection, Instance instance, TopologyChangeType topologyChangeType) {
        this.fType = topologyChangeType;
        this.fTargets = Collections.unmodifiableList(new ArrayList<Instance>(collection));
        this.fSource = instance;
    }

    static TopologyMessage buildConnectionEstablished(Collection<Instance> collection, Instance instance) {
        return new TopologyMessage(collection, instance, TopologyChangeType.ESTABLISHED_COMMUNICATION);
    }

    static TopologyMessage buildConnectionLost(Collection<Instance> collection) {
        return new TopologyMessage(collection, null, TopologyChangeType.LOST_COMMUNICATION);
    }

    TopologyChangeType getType() {
        return this.fType;
    }

    @Override
    public String toString() {
        return "[TopologyMessage: " + this.fSource + " " + (Object)((Object)this.fType) + " " + this.fTargets + "]";
    }

    Instance getSource() {
        assert (this.fType == TopologyChangeType.ESTABLISHED_COMMUNICATION);
        return this.fSource;
    }

    Collection<Instance> getTargets() {
        return new ArrayList<Instance>(this.fTargets);
    }
}

