/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerException;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerPeerSessionFactory;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortRequest;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectReadyToAcceptMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerPassiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.AbstractMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.parallel.util.concurrent.SignalingAtomicBoolean;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public final class BrokeredConnector
extends AbstractMessageObserver {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private final Instance fLocalPeer;
    private final int fNumContendingProcesses;
    private final String fLogId;
    private final Map<UUID, EasyFuture<BrokeredConnectPortReply>> fGroupUuidsToPortReplies = new ConcurrentHashMap<UUID, EasyFuture<BrokeredConnectPortReply>>();

    public BrokeredConnector(Instance instance, int n) {
        this.fLocalPeer = instance;
        this.fLogId = this.getClass().getSimpleName() + " for " + instance;
        this.fNumContendingProcesses = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection activelyConnectTo(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string) throws InterruptedException, PeerMessagingException {
        BrokeredSocketConnectInfo brokeredSocketConnectInfo2 = brokeredSocketConnectInfo.createCopyWithReasonableDeadline();
        Log.LOGGER.finest(this.fLogId + " started activelyConnectTo " + brokeredSocketConnectInfo2 + " from " + string + " " + this.fLocalPeer);
        PeerInstance peerInstance = BrokerPeerSessionFactory.createPeerOfBroker(brokeredSocketConnectInfo2.getBrokerClientInfo());
        Log.LOGGER.fine(this.fLogId + " is " + peerInstance);
        Connection connection = BrokerPeerSessionFactory.createConnectionToBroker(peerInstance, brokeredSocketConnectInfo2.getBrokerClientInfo(), this.fLogId);
        PeerSession peerSession = BrokerPeerSessionFactory.createPeerSessionWithBroker(peerInstance, connection, this.fLogId);
        Log.LOGGER.finest(this.fLogId + " started PeerSession with broker on " + string + " for " + this.fLocalPeer);
        try {
            BrokeredConnectPortReply brokeredConnectPortReply = this.requestPortFromBroker(brokeredSocketConnectInfo2, string, connection, peerSession);
            ServerSocketAcceptInfo serverSocketAcceptInfo = brokeredSocketConnectInfo2.getBrokeredConnectorAcceptInfo();
            ServerSocketAcceptInfo serverSocketAcceptInfo2 = serverSocketAcceptInfo.createWithNewPortOffsetAndStep(brokeredConnectPortReply.getPortOffset(), brokeredConnectPortReply.getPortStepsize());
            Connection connection2 = this.sendConnectinfoToBrokerAndConnect(brokeredSocketConnectInfo2, string, connection, peerSession, serverSocketAcceptInfo2);
            return connection2;
        }
        finally {
            peerSession.normalShutdown();
            Log.LOGGER.finer(this.fLogId + " Shut down PeerSession " + peerSession + " from " + string + " for " + this.fLocalPeer);
        }
    }

    private BrokeredConnectPortReply requestPortFromBroker(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string, Connection connection, PeerSession peerSession) throws InterruptedException, NoPortFromBrokerException {
        BrokeredConnectPortRequest brokeredConnectPortRequest = new BrokeredConnectPortRequest(brokeredSocketConnectInfo.getGroupUUID(), string, this.fNumContendingProcesses, SEQUENCE_NUMBER_SOURCE.getAndIncrement());
        EasyFuture easyFuture = new EasyFuture();
        this.fGroupUuidsToPortReplies.put(brokeredSocketConnectInfo.getGroupUUID(), easyFuture);
        peerSession.getOutputGroup().sendTo(connection.getRemoteInstance(), (ObservableMessage)brokeredConnectPortRequest, (MessageObserver)this);
        Log.LOGGER.finest(this.fLogId + " sent " + brokeredConnectPortRequest + " to broker");
        try {
            BrokeredConnectPortReply brokeredConnectPortReply = (BrokeredConnectPortReply)easyFuture.get(brokeredSocketConnectInfo.getRemainingTime(), TimeUnit.MILLISECONDS);
            Log.LOGGER.finest(this.fLogId + " got " + brokeredConnectPortReply + " from broker");
            BrokeredConnectPortReply brokeredConnectPortReply2 = brokeredConnectPortReply;
            return brokeredConnectPortReply2;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new PeerMessagingRuntimeException("Unexpected exception when " + this.fLocalPeer + " on " + string + " requested a port from the broker at " + connection.getLogString(), executionException);
        }
        catch (TimeoutException timeoutException) {
            throw new NoPortFromBrokerException(string, this.fLocalPeer, brokeredSocketConnectInfo, timeoutException);
        }
        finally {
            this.fGroupUuidsToPortReplies.remove(brokeredSocketConnectInfo.getGroupUUID());
        }
    }

    private Connection sendConnectinfoToBrokerAndConnect(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string, Connection connection, PeerSession peerSession, ServerSocketAcceptInfo serverSocketAcceptInfo) throws PeerMessagingException {
        PeerPassiveAcceptor peerPassiveAcceptor = new PeerPassiveAcceptor(string, this.fLocalPeer, serverSocketAcceptInfo.createCopyReplaceGroupImplementation(brokeredSocketConnectInfo.getGroupImplementation()));
        Log.LOGGER.finest(this.fLogId + " created peerPassiveAcceptor on " + string + " for " + this.fLocalPeer);
        BrokeredConnectionHandler brokeredConnectionHandler = new BrokeredConnectionHandler();
        peerPassiveAcceptor.startAccepting(brokeredConnectionHandler);
        try {
            this.sendConnectInfoToBroker(string, this.fLocalPeer, this.fNumContendingProcesses, this.fLogId, peerPassiveAcceptor, connection, peerSession);
            Connection connection2 = brokeredConnectionHandler.get(brokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout(), TimeUnit.MILLISECONDS);
            Log.LOGGER.fine(this.fLogId + " Connected to " + connection2 + " from " + string + " for " + this.fLocalPeer);
            Connection connection3 = connection2;
            return connection3;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.LOGGER.log(Level.FINE, this.fLogId + "Failed to connect using " + brokeredSocketConnectInfo + " from " + peerPassiveAcceptor.getInfoToConnect().getSocketAddress() + "due to " + exception, exception);
            throw new PeerFailedToConnectException(peerPassiveAcceptor.getInfoToConnect().getSocketAddress(), this.fLocalPeer, brokeredSocketConnectInfo, exception);
        }
        catch (TimeoutException timeoutException) {
            Log.LOGGER.log(Level.FINE, this.fLogId + "Failed to connect using " + brokeredSocketConnectInfo + " from " + peerPassiveAcceptor.getInfoToConnect().getSocketAddress() + " after waiting for " + brokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout() + " ms", timeoutException);
            throw new PeerFailedToConnectException(peerPassiveAcceptor.getInfoToConnect().getSocketAddress(), this.fLocalPeer, brokeredSocketConnectInfo, timeoutException);
        }
        finally {
            peerPassiveAcceptor.close();
        }
    }

    private void sendConnectInfoToBroker(String string, Instance instance, int n, String string2, PeerPassiveAcceptor peerPassiveAcceptor, Connection connection, PeerSession peerSession) {
        BrokeredConnectReadyToAcceptMessage brokeredConnectReadyToAcceptMessage = new BrokeredConnectReadyToAcceptMessage(peerPassiveAcceptor.getInfoToConnect(), n);
        peerSession.getOutputGroup().sendTo(connection.getRemoteInstance(), (Message)brokeredConnectReadyToAcceptMessage);
        Log.LOGGER.finer(string2 + " Sent " + brokeredConnectReadyToAcceptMessage + " to broker from " + string + " for " + instance);
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        EasyFuture<BrokeredConnectPortReply> easyFuture;
        Object object;
        Log.LOGGER.finer(this.fLogId + " received " + returnMessage + " from " + instance);
        if (returnMessage instanceof BrokerMessage) {
            object = (BrokerMessage)((Object)returnMessage);
            if (!object.getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) {
                easyFuture = this.fLogId + ": Got reply for the wrong group. Expected " + this.fLocalPeer.getGroupUuid() + " got " + object.getGroupUuid();
                assert (object.getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) : easyFuture;
                Log.LOGGER.warning((String)((Object)easyFuture));
            }
        } else {
            object = this.fLogId + " Expected " + returnMessage + " to be a " + BrokerMessage.class.getSimpleName() + " but it is a " + returnMessage.getClass();
            assert (false) : object;
            Log.LOGGER.warning((String)object);
        }
        if (returnMessage instanceof BrokeredConnectPortReply) {
            object = (BrokeredConnectPortReply)returnMessage;
            easyFuture = this.fGroupUuidsToPortReplies.get(((BrokeredConnectPortReply)object).getGroupUuid());
            if (easyFuture == null) {
                String string = this.fLogId + ": Reply is from an unexpected group. Expected " + this.fLocalPeer.getGroupUuid() + " got " + ((BrokeredConnectPortReply)object).getGroupUuid();
                assert (((BrokeredConnectPortReply)object).getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) : string;
                Log.LOGGER.warning(string);
            } else {
                easyFuture.set((BrokeredConnectPortReply)object);
                Log.LOGGER.finest(this.fLogId + " completed for ");
            }
        } else {
            Log.LOGGER.severe(this.fLogId + " Unknown message type: " + returnMessage.getClass());
            throw new UnsupportedOperationException(this.fLogId + " Unknown message type: " + returnMessage.getClass());
        }
    }

    public static final class NoPortFromBrokerException
    extends BrokeredConnectorException {
        private final BaseMsgID fMessageID;

        private NoPortFromBrokerException(String string, Instance instance, BrokeredSocketConnectInfo brokeredSocketConnectInfo, TimeoutException timeoutException) {
            super(timeoutException);
            this.fMessageID = new peermessaging.NoPortFromBroker(instance.toString(), string, brokeredSocketConnectInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress().toString(), Long.toString(brokeredSocketConnectInfo.getRemainingTime()));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static final class PeerFailedToConnectException
    extends BrokeredConnectorException {
        private final InetSocketAddress fSocketAddress;
        private final Instance fLocalPeer;
        private final BrokeredSocketConnectInfo fBrokeredSocketConnectInfo;
        private final Exception fCause;

        private PeerFailedToConnectException(InetSocketAddress inetSocketAddress, Instance instance, BrokeredSocketConnectInfo brokeredSocketConnectInfo, Exception exception) {
            super(exception);
            this.fSocketAddress = inetSocketAddress;
            this.fLocalPeer = instance;
            this.fBrokeredSocketConnectInfo = brokeredSocketConnectInfo;
            this.fCause = exception;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.BrokeredPeerFailedToConnect(this.fLocalPeer.toString(), this.fSocketAddress.toString(), Long.toString(this.fBrokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout()), this.fBrokeredSocketConnectInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress().toString(), this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.BrokeredPeerFailedToConnect(this.fLocalPeer.toString(), this.fSocketAddress.toString(), Long.toString(this.fBrokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout()), this.fBrokeredSocketConnectInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress().toString(), this.fCause.getLocalizedMessage());
        }
    }

    private static abstract class BrokeredConnectorException
    extends BrokerException {
        protected BrokeredConnectorException(Exception exception) {
            super(exception);
        }
    }

    private static final class EasyFuture<V>
    implements Future<V> {
        private final SignalingAtomicBoolean fIsDoneOrCancelled = new SignalingAtomicBoolean(false);
        private final AtomicBoolean fIsDone = new AtomicBoolean(false);
        private final AtomicBoolean fIsCancelled = new AtomicBoolean(false);
        private final AtomicReference<V> fResult = new AtomicReference();
        private final AtomicReference<Throwable> fThrowable = new AtomicReference();

        private EasyFuture() {
        }

        @Override
        public boolean cancel(boolean bl) {
            this.fIsCancelled.set(true);
            this.fIsDoneOrCancelled.set(true);
            return !this.fIsDone.get();
        }

        @Override
        public boolean isCancelled() {
            return this.fIsCancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.fIsDone.get();
        }

        private V throwOrGet() throws ExecutionException {
            Throwable throwable = this.fThrowable.get();
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
            return this.fResult.get();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.fIsDoneOrCancelled.awaitTrue();
            return this.throwOrGet();
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.fIsDoneOrCancelled.awaitTrue(l, timeUnit)) {
                throw new TimeoutException("Timed out after " + l + " " + (Object)((Object)timeUnit));
            }
            return this.throwOrGet();
        }

        public void done() {
            this.fIsDone.set(true);
            this.fIsDoneOrCancelled.set(true);
        }

        public void set(V v) {
            this.fResult.set(v);
            this.done();
        }

        public void setException(Throwable throwable) {
            this.fThrowable.set(throwable);
            this.done();
        }
    }

    private static final class BrokeredConnectionHandler
    implements PeerPassiveAcceptor.ConnectionHandler {
        private final EasyFuture<Connection> fEasyFuture = new EasyFuture();

        BrokeredConnectionHandler() {
        }

        @Override
        public void newConnection(Connection connection) {
            this.fEasyFuture.set(connection);
        }

        public Connection get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.fEasyFuture.get(l, timeUnit);
        }
    }
}

