/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.DispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.ReturnMessageDispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.KeepAlive;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionListener;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerShutdownHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class PeerSession {
    private final ExecutorService fListenerExec;
    private final ObservableMessageRegistry fReturnMessageRegistry;
    private final ErrorHandler fErrorHandler;
    private final ExecutorService fDispatcherExec;
    private final CommunicationGroup fCommGroup;
    private final ShutdownHandler fShutdownHandler;
    private final DispatcherImpl fDispatcher;
    private final KeepAlive fKeepAlive;
    private final Set<PeerSessionListener> fSessionListenerSet = Collections.synchronizedSet(new HashSet());

    public PeerSession(JoinInfo joinInfo, PeerInstance peerInstance, ErrorHandler errorHandler, Set<PeerDispatcher<? extends Message>> set, Collection<Connection> collection) {
        this.fErrorHandler = errorHandler;
        this.fListenerExec = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fListenerExec-"), (Logger)PackageInfo.LOGGER));
        this.fReturnMessageRegistry = ReturnMessageDispatcherImpl.create(this.fListenerExec, this.fErrorHandler);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initializing session.");
        Connection[] connectionArray = collection.toArray(new Connection[0]);
        this.fCommGroup = CommunicationGroup.CommunicationGroupBuilder.buildCommunicationGroup(joinInfo, this.fErrorHandler, this.fReturnMessageRegistry, connectionArray, peerInstance);
        this.fDispatcher = DispatcherImpl.create();
        this.fDispatcher.addDispatcher(this.fReturnMessageRegistry.getDispatcher());
        ClosableSessionConnections closableSessionConnections = new ClosableSessionConnections(){

            @Override
            public void run(SessionShutdownEvent sessionShutdownEvent) {
                PeerSession.this.closeIOStopExecutors(sessionShutdownEvent);
            }
        };
        this.fShutdownHandler = new PeerShutdownHandlerImpl(this.fErrorHandler, closableSessionConnections);
        this.fKeepAlive = new KeepAlive(this.fCommGroup, this.fCommGroup.getConnectedInstances());
        this.fDispatcher.addDispatcher(this.fKeepAlive.getDispatcher());
        for (PeerDispatcher<? extends Message> peerDispatcher : set) {
            peerDispatcher.initReturnGroup(this.fCommGroup);
            this.fDispatcher.addDispatcher(peerDispatcher);
        }
        this.fErrorHandler.activate(this.fShutdownHandler);
        this.fDispatcherExec = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fDispatcherExec-"), (Logger)PackageInfo.LOGGER));
        this.fCommGroup.setDispatcher(this.fDispatcher, this.fDispatcherExec);
        this.fShutdownHandler.sessionStartupComplete();
        this.fKeepAlive.start();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initialization complete.");
    }

    public PeerSession(JoinInfo joinInfo, PeerInstance peerInstance, ErrorHandler errorHandler, Set<PeerDispatcher<? extends Message>> set) {
        this(joinInfo, peerInstance, errorHandler, set, Collections.emptyList());
    }

    public void addConnection(Connection connection) {
        this.fCommGroup.addConnection(connection);
    }

    public void removeInstance(Instance instance) {
        this.fCommGroup.removeInstance(instance);
    }

    public boolean hasShutdown() {
        return !this.fShutdownHandler.hasShutdownBegun();
    }

    public OutputGroup getOutputGroup() {
        return this.fCommGroup;
    }

    public boolean normalShutdown() {
        return this.fShutdownHandler.normalShutdown();
    }

    private void closeIOStopExecutors(SessionShutdownEvent sessionShutdownEvent) {
        try {
            this.fKeepAlive.shutdownNow();
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Problem shutting down fKeepAlive", runtimeException);
        }
        try {
            if (this.fListenerExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fListenerExec.");
                this.fListenerExec.shutdown();
            }
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fInputExec.", runtimeException);
        }
        try {
            if (this.fDispatcherExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fDispatcherExec.");
                this.fDispatcherExec.shutdown();
            }
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fDispatcherExec.", runtimeException);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fCommGroup.");
            this.fCommGroup.closeStreams();
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing fCommGroup.", runtimeException);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fReturnMessageRegistry.");
            this.fReturnMessageRegistry.destroy();
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing ReturnMessageRegistry object.", runtimeException);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Firing SessionEndedEvent listeners.");
            this.notifySessionEnded(sessionShutdownEvent);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when Firing SessionEndedEvent listeners.", throwable);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closed IO, Executors.");
    }

    public boolean addSessionListener(PeerSessionListener peerSessionListener) {
        return this.fSessionListenerSet.add(peerSessionListener);
    }

    public boolean removeSessionListener(PeerSessionListener peerSessionListener) {
        return this.fSessionListenerSet.remove(peerSessionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionEnded(final SessionShutdownEvent sessionShutdownEvent) {
        PeerSessionEndedEventDispatcher peerSessionEndedEventDispatcher;
        switch (sessionShutdownEvent.getShutdownState()) {
            case NORMAL: {
                peerSessionEndedEventDispatcher = new PeerSessionEndedEventDispatcher(){

                    @Override
                    public void dispatch(PeerSessionListener peerSessionListener) {
                        peerSessionListener.sessionClosed(new PeerSessionEndedEvent(PeerSession.this, sessionShutdownEvent));
                    }
                };
                break;
            }
            case ERROR: {
                peerSessionEndedEventDispatcher = new PeerSessionEndedEventDispatcher(){

                    @Override
                    public void dispatch(PeerSessionListener peerSessionListener) {
                        peerSessionListener.sessionErrored(new PeerSessionEndedEvent(PeerSession.this, sessionShutdownEvent));
                    }
                };
                break;
            }
            default: {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "PeerSession ended with unexpected ShutdownState" + (Object)((Object)sessionShutdownEvent.getShutdownState()));
                return;
            }
        }
        PeerSessionListener[] peerSessionListenerArray = this.fSessionListenerSet;
        synchronized (this.fSessionListenerSet) {
            PeerSessionListener[] peerSessionListenerArray2 = this.fSessionListenerSet.toArray(new PeerSessionListener[this.fSessionListenerSet.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (PeerSessionListener peerSessionListener : peerSessionListenerArray2) {
                try {
                    peerSessionEndedEventDispatcher.dispatch(peerSessionListener);
                }
                catch (Throwable throwable) {
                    PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Listener threw exception.", throwable);
                }
            }
            return;
        }
    }

    public String toString() {
        return "PeerSession{fListenerExec=" + this.fListenerExec + ", fReturnMessageRegistry=" + this.fReturnMessageRegistry + ", fErrorHandler=" + this.fErrorHandler + ", fDispatcherExec=" + this.fDispatcherExec + ", fCommGroup=" + this.fCommGroup + ", fShutdownHandler=" + this.fShutdownHandler + ", fDispatcher=" + this.fDispatcher + ", fSessionListenerSet=" + this.fSessionListenerSet + '}';
    }

    private static interface PeerSessionEndedEventDispatcher {
        public void dispatch(PeerSessionListener var1);
    }
}

