/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.atomic.AtomicBoolean;

class PeerShutdownHandlerImpl
implements ShutdownHandler {
    private final ErrorHandler fErrorHandler;
    private final AtomicBoolean fHasShutdown = new AtomicBoolean(false);
    private final ClosableSessionConnections fClosableConnections;

    PeerShutdownHandlerImpl(ErrorHandler errorHandler, ClosableSessionConnections closableSessionConnections) {
        this.fClosableConnections = closableSessionConnections;
        this.fErrorHandler = errorHandler;
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending shutdown cancellation message.");
    }

    @Override
    public boolean normalShutdown() {
        if (this.fHasShutdown.getAndSet(true)) {
            return true;
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Initiating a shutdown.");
        this.fErrorHandler.deactivate();
        this.shutdownPeer(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.NORMAL));
        return true;
    }

    @Override
    public void forceShutdown(HasI18nMatlabIdentifiedMessage hasI18nMatlabIdentifiedMessage) {
        if (this.fHasShutdown.getAndSet(true)) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Initiating a forced shutdown.");
        this.fErrorHandler.deactivate();
        this.shutdownPeer(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.ERROR, hasI18nMatlabIdentifiedMessage));
    }

    @Override
    public boolean hasShutdownBegun() {
        return this.fHasShutdown.get();
    }

    @Override
    public void sessionStartupComplete() {
    }

    private void shutdownPeer(SessionShutdownEvent sessionShutdownEvent) {
        block2: {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closing IO and stopping executors.");
            try {
                this.fClosableConnections.run(sessionShutdownEvent);
            }
            catch (Throwable throwable) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Caught a Throwable when calling Runnable to close IO and stop executors." + throwable.getClass().getName()));
            }
        }
    }
}

