/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class ProcessInstance
implements Serializable,
Comparable<ProcessInstance> {
    public static final int CLIENT_VALUE_FOR_LAB_FEATURES = -1;
    private ProcessType fType;
    private static ProcessInstance sClientInstance = null;
    private static Map<Integer, ProcessInstance> sLabInstanceMap = null;

    private ProcessInstance(ProcessType processType) {
        this.fType = processType;
    }

    public abstract String toString();

    @Override
    public int compareTo(ProcessInstance processInstance) {
        if (processInstance == null) {
            throw new NullPointerException("Attempted comparison of ProcessInstance with null");
        }
        return this.fType == ProcessType.CLIENT ? 1 : -1;
    }

    public ProcessType getProcessType() {
        return this.fType;
    }

    public int getLabIndex() {
        throw new IllegalStateException("Cannot ask " + (Object)((Object)this.fType) + " for labindex");
    }

    public static synchronized ProcessInstance getLabInstance(int n) {
        if (sLabInstanceMap == null) {
            sLabInstanceMap = new HashMap<Integer, ProcessInstance>();
        }
        if (!sLabInstanceMap.containsKey(n)) {
            sLabInstanceMap.put(n, new LabProcessInstance(n));
        }
        return sLabInstanceMap.get(n);
    }

    public static synchronized ProcessInstance[] getAllLabs(int n) {
        ProcessInstance[] processInstanceArray = new ProcessInstance[n];
        for (int i = 0; i < n; ++i) {
            processInstanceArray[i] = ProcessInstance.getLabInstance(1 + i);
        }
        return processInstanceArray;
    }

    public static synchronized ProcessInstance getClientInstance() {
        if (sClientInstance == null) {
            sClientInstance = new ClientProcessInstance();
        }
        return sClientInstance;
    }

    private static class ClientProcessInstance
    extends ProcessInstance {
        private ClientProcessInstance() {
            super(ProcessType.CLIENT);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof ClientProcessInstance;
        }

        public int hashCode() {
            return -1;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Process: ");
            stringBuffer.append(this.getProcessType().toString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static class LabProcessInstance
    extends ProcessInstance {
        private int fLabIndex;

        private LabProcessInstance(int n) {
            super(ProcessType.LAB);
            this.fLabIndex = n;
        }

        @Override
        public int compareTo(ProcessInstance processInstance) {
            if (processInstance == null) {
                throw new NullPointerException("Attempted comparison of ProcessInstance with null");
            }
            if (processInstance instanceof LabProcessInstance) {
                LabProcessInstance labProcessInstance = (LabProcessInstance)processInstance;
                return this.fLabIndex - labProcessInstance.getLabIndex();
            }
            return super.compareTo(processInstance);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LabProcessInstance)) {
                return false;
            }
            LabProcessInstance labProcessInstance = (LabProcessInstance)object;
            return labProcessInstance.fLabIndex == this.fLabIndex;
        }

        @Override
        public int getLabIndex() {
            return this.fLabIndex;
        }

        public int hashCode() {
            return this.fLabIndex;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Process: ");
            stringBuffer.append(this.getProcessType().toString());
            stringBuffer.append(" ");
            stringBuffer.append(this.fLabIndex);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static enum ProcessType {
        CLIENT(1, "client"),
        LAB(0, "lab");

        private final int fCode;
        private final String fString;

        private ProcessType(int n2, String string2) {
            this.fCode = n2;
            this.fString = string2;
        }

        public int getProcessTypeCode() {
            return this.fCode;
        }

        public String toString() {
            return this.fString;
        }
    }
}

