/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class LabsResponseVector<T> {
    private final Set<T> fLabsExpecting;
    private final Set<T> fLabsGot;
    private CountDownLatch fLatch;

    public LabsResponseVector(List<T> list) {
        assert (!list.isEmpty()) : "Number of labs/sources must be > 0.";
        this.fLabsGot = new HashSet<T>();
        this.fLabsExpecting = new HashSet<T>(list);
        this.fLatch = new CountDownLatch(list.size());
    }

    public synchronized void receivedResponse(T t) {
        assert (this.fLabsExpecting.contains(t)) : "Invalid source index " + t;
        assert (!this.fLabsGot.contains(t)) : "Received multiple responses from source index " + t;
        this.fLabsGot.add(t);
        this.fLatch.countDown();
    }

    public synchronized boolean hasAllResponses() {
        boolean bl = this.fLabsGot.containsAll(this.fLabsExpecting);
        if (bl) assert (this.fLatch.getCount() == 0L);
        return bl;
    }

    public synchronized void clearAll() {
        this.fLabsGot.clear();
        this.fLatch = new CountDownLatch(this.fLabsExpecting.size());
    }

    public void waitTillHasAllResponses(long l) {
        assert (l > 0L) : "Wait time must be positive.";
        try {
            this.fLatch.await(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void communicationLost(T t) {
        this.fLabsExpecting.remove(t);
        this.fLabsGot.remove(t);
        this.fLatch.countDown();
    }

    public synchronized void communicationEstablished(T t) {
        this.fLabsExpecting.add(t);
    }
}

