/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.AbstractTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.DefaultTaskEvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Log;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.PlainTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemotePlainFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractPlainTask
extends AbstractTask
implements PlainTask {
    private final RemotePlainFuture fRemoteFuture;
    private final AtomicBoolean fReadFlag = new AtomicBoolean(false);

    protected AbstractPlainTask(long l, RemotePlainFuture remotePlainFuture) {
        super(l);
        this.fRemoteFuture = remotePlainFuture;
    }

    @Override
    public final RemotePlainFuture getRemoteFuture() {
        return this.fRemoteFuture;
    }

    @Override
    public final String getDiary() {
        return this.fRemoteFuture.getDiary();
    }

    @Override
    public final EvaluationResult getResult() {
        EvaluationResult evaluationResult = null;
        boolean bl = false;
        if (this.getState() == Task.State.FINISHED) {
            while (true) {
                try {
                    evaluationResult = (EvaluationResult)this.fRemoteFuture.get();
                }
                catch (CancellationException | ExecutionException exception) {
                    evaluationResult = new DefaultTaskEvaluationResult(-1L, this.getID(), null, exception);
                }
                catch (InterruptedException interruptedException) {
                    Log.LOGGER.info("Interrupted in AbstractPlainTask.getResult for ID " + this.getID());
                    bl = true;
                    continue;
                }
                break;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return evaluationResult;
    }

    @Override
    public final Instance getWorker() {
        return this.fRemoteFuture.getWorker();
    }

    @Override
    public final AtomicBoolean getReadFlag() {
        return this.fReadFlag;
    }
}

