/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemoteTaskFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import com.mathworks.toolbox.parallel.util.concurrent.EasyFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRemoteFuture<T>
extends EasyFuture<T>
implements RemoteTaskFuture {
    private final CountDownLatch fAwaitHelper = new CountDownLatch(1);
    private Task.State fState = Task.State.PENDING;
    private static final int EXPECTED_NUM_CANCEL_TASKS = 2;
    private List<Runnable> fCancelTasks = new ArrayList<Runnable>(2);
    private boolean fIsCancelled = false;
    private Exception fCancellationCause = null;

    @Override
    public final synchronized Task.State getState() {
        return this.fState;
    }

    protected final synchronized Task.State setState(Task.State state) {
        Task.State state2 = this.fState;
        this.fState = state;
        if (this.fState == Task.State.FINISHED) {
            this.fAwaitHelper.countDown();
        }
        return state2;
    }

    private synchronized void setupForCancellation(Exception exception) {
        if (!this.fIsCancelled) {
            this.fIsCancelled = true;
            this.fCancellationCause = exception;
        }
    }

    @Override
    public final boolean cancel(boolean bl, Exception exception) {
        this.setupForCancellation(exception);
        boolean bl2 = super.cancel(bl);
        this.setState(Task.State.FINISHED);
        return bl2;
    }

    @Override
    public final void setQueued() {
        this.setState(Task.State.QUEUED);
    }

    private synchronized Exception getCancellationCause() {
        return this.fCancellationCause;
    }

    private synchronized Collection<Runnable> getCancellationTasks() {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.fCancelTasks);
        this.fCancelTasks.clear();
        return arrayList;
    }

    protected final Exception performCancellation(boolean bl) {
        Collection<Runnable> collection = this.getCancellationTasks();
        Exception exception = this.getCancellationCause();
        for (Runnable runnable : collection) {
            runnable.run();
        }
        return exception;
    }

    private synchronized boolean addCancelTaskImpl(Runnable runnable) {
        if (this.fIsCancelled) {
            return false;
        }
        this.fCancelTasks.add(runnable);
        return true;
    }

    @Override
    public final void addCancelTask(Runnable runnable) {
        if (!this.addCancelTaskImpl(runnable)) {
            runnable.run();
        }
    }

    @Override
    public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fAwaitHelper.await(l, timeUnit);
    }

    @Override
    public final void await() throws InterruptedException {
        this.fAwaitHelper.await();
    }
}

