/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.BufferHelper;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueueMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTaskQueueMessage
extends MCommand
implements BufferTransferrable,
TaskQueueMessage {
    private final AtomicBoolean fDisposed = new AtomicBoolean(false);
    private final BufferHelper fBufferHelper;
    private final long fID;

    AbstractTaskQueueMessage(long l, Object object) {
        this.fBufferHelper = new BufferHelper(object);
        this.fID = l;
    }

    @Override
    public ByteBufferHandle[] getByteBuffers() {
        return this.fBufferHelper.getByteBuffers();
    }

    @Override
    public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
        this.fBufferHelper.setByteBuffers(byteBufferHandleArray);
    }

    Object[] getAllData() {
        return this.fBufferHelper.getAll();
    }

    public final void dispose() {
        boolean bl = this.fDisposed.compareAndSet(false, true);
        if (bl) {
            ByteBufferHandle[] byteBufferHandleArray;
            for (ByteBufferHandle byteBufferHandle : byteBufferHandleArray = this.getByteBuffers()) {
                byteBufferHandle.free();
            }
        } else assert (false) : "dispose() called multiple times.";
    }

    public final boolean isDisposed() {
        return this.fDisposed.get();
    }

    @Override
    public final long getTaskID() {
        return this.fID;
    }
}

