/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCompletedListener;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferError;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferErrorMessage;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferFinished;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitor;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferReady;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class TransferMonitorImpl
implements TransferMonitor {
    private ExecutorService fListenerExec;
    private ErrorHandler fErrorHandler;
    protected RoleOutputGroup fOutGroup;
    private final long fTransferSeqNumber;
    protected ProcessInstance fDestID;
    private TransferCompletedListener fListener;
    private TransferError fError;
    private boolean fIsRemoteReady;
    private boolean fIsLocalReady;
    private boolean fIsLocalFinished;
    private boolean fIsRemoteFinished;

    TransferMonitorImpl(ExecutorService executorService, ErrorHandler errorHandler, long l, RoleOutputGroup roleOutputGroup, ProcessInstance processInstance, TransferCompletedListener transferCompletedListener) {
        this.fListenerExec = executorService;
        this.fErrorHandler = errorHandler;
        this.fTransferSeqNumber = l;
        this.fOutGroup = roleOutputGroup;
        this.fDestID = processInstance;
        this.fIsLocalReady = false;
        this.fIsRemoteReady = false;
        this.fIsLocalFinished = false;
        this.fIsRemoteFinished = false;
        this.fListener = transferCompletedListener;
    }

    @Override
    public synchronized void setOutsideLocalMError(TransferError transferError) {
        if (this.getIsCompleted()) {
            return;
        }
        this.fError = transferError;
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Abnormal completion of data transfer due to a non-local Matlab error: " + transferError.getErrorIdentifier() + " " + transferError.getErrorMessage());
        this.completedAbnormally();
    }

    @Override
    public synchronized TransferError getOutsideLocalMError() {
        return this.fError;
    }

    @Override
    public synchronized void setLocalMError(String string, String string2) {
        if (this.getIsCompleted()) {
            return;
        }
        this.fError = new TransferError(this.fTransferSeqNumber, string, string2);
        this.fOutGroup.sendTo(this.fDestID, (Message)this.fError);
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Abnormal completion of data transfer due to a local Matlab error: " + string + " " + string2);
        this.completedAbnormally();
    }

    @Override
    public synchronized void setLocalMError(TransferErrorMessage transferErrorMessage) {
        if (this.getIsCompleted()) {
            return;
        }
        this.fError = new TransferError(this.fTransferSeqNumber, transferErrorMessage);
        this.fOutGroup.sendTo(this.fDestID, (Message)this.fError);
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Abnormal completion of data transfer due to a local Matlab error: " + transferErrorMessage.getMessageID() + " " + transferErrorMessage.getMessage());
        this.completedAbnormally();
    }

    @Override
    public synchronized void setLocalReady() {
        if (this.fIsLocalReady || this.fError != null) {
            return;
        }
        this.fIsLocalReady = true;
        this.fOutGroup.sendTo(this.fDestID, (Message)new TransferReady(this.fTransferSeqNumber));
    }

    @Override
    public synchronized boolean isRemoteReady() {
        return this.fIsRemoteReady;
    }

    @Override
    public synchronized void setRemoteReady() {
        if (this.fIsRemoteReady || this.fError != null) {
            return;
        }
        this.fIsRemoteReady = true;
        if (this.fIsLocalReady) {
            this.fOutGroup.sendTo(this.fDestID, (Message)new TransferReady(this.fTransferSeqNumber));
        }
    }

    @Override
    public synchronized void setLocalFinished() {
        if (this.fIsLocalFinished || this.fError != null) {
            return;
        }
        this.fIsLocalFinished = true;
        this.fOutGroup.sendTo(this.fDestID, (Message)new TransferFinished(this.fTransferSeqNumber));
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Transfer completed normally on the local side.");
        if (this.getIsCompleted()) {
            this.completedNormally();
        }
    }

    @Override
    public synchronized boolean isRemoteFinished() {
        return this.fIsRemoteFinished;
    }

    @Override
    public synchronized void setRemoteFinished() {
        if (this.fIsRemoteFinished || this.fError != null) {
            return;
        }
        this.fIsRemoteFinished = true;
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Transfer completed normally on the remote side.");
        if (this.getIsCompleted()) {
            this.completedNormally();
        }
    }

    public long getTransferSeqNumber() {
        return this.fTransferSeqNumber;
    }

    private boolean getIsCompleted() {
        return this.fIsLocalFinished && this.fIsRemoteFinished || this.fError != null;
    }

    private void completedNormally() {
        this.notifyListener();
    }

    private void completedAbnormally() {
        this.fIsLocalReady = false;
        this.fIsLocalFinished = false;
        this.fIsRemoteFinished = false;
        this.fIsRemoteReady = false;
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.fListener == null) {
            return;
        }
        try {
            this.fListenerExec.execute(new Runnable(){
                final TransferCompletedListener fMyListener;
                {
                    this.fMyListener = TransferMonitorImpl.this.fListener;
                }

                @Override
                public void run() {
                    try {
                        this.fMyListener.transferCompleted(TransferMonitorImpl.this.fTransferSeqNumber);
                    }
                    catch (Throwable throwable) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "TransferCompletedListener threw a Throwable.", throwable);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }
}

