/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.LocalProcessFailedException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.FileCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalFileDoesNotExistException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.MissingRcpCommandException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessCopyFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.RcpExcludedFilesException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ShellParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class RcpCopier
implements FileCopier {
    private static final String PROTOCOL_NAME = "rcp";
    private static final String PROTOCOL_TYPE = "rcp";
    private static final ParameterSet RCP_PARAMETERS = new ParameterSet(RcpParameter.USERNAME, ShellParameter.FREE_FORM_PARAMETERS, ShellParameter.LOCAL_ENVIRONMENT, RcpParameter.RCP_COMMAND);

    @Override
    public ParameterSet getParameterSet() {
        return RCP_PARAMETERS;
    }

    @Override
    public String getProtocolName() {
        return "rcp";
    }

    @Override
    public String getProtocolType() {
        return "rcp";
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return CopyCommand.class;
    }

    private String createRemoteSpecifier(String string, String string2, Parameter<String> parameter, ParameterMap parameterMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = parameterMap.get(parameter);
        if (string3 != null) {
            stringBuilder.append(string3);
            stringBuilder.append("@");
        }
        stringBuilder.append(string);
        stringBuilder.append(":\"");
        stringBuilder.append(string2);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private String createLocalSpecifier(File file) {
        return file.toString();
    }

    @Override
    public ProcessCopyFuture copyFile(CopyCommand copyCommand, String string, ParameterMap parameterMap) throws InvalidValueException, LocalProcessFailedException, ProtocolDispatchException {
        Object object2;
        Object object3;
        if (copyCommand.anyFilesExcluded()) {
            throw new RcpExcludedFilesException(copyCommand);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = parameterMap.get(RcpParameter.RCP_COMMAND);
        if (string2 == null) {
            string2 = RcpParameter.RCP_COMMAND.getSuggestedValue();
        } else if (!new File(string2).exists()) {
            throw new MissingRcpCommandException(string2);
        }
        arrayList.add(string2);
        if (copyCommand.getLocalFile().exists() && copyCommand.getLocalFile().isDirectory()) {
            arrayList.add("-r");
        } else if (copyCommand instanceof CopyFromRemoteCommand) {
            arrayList.add("-r");
        }
        String string3 = parameterMap.get(ShellParameter.FREE_FORM_PARAMETERS);
        if (string3 != null) {
            arrayList.add(string3);
        }
        if (copyCommand instanceof CopyToRemoteCommand) {
            object3 = copyCommand.getLocalFile();
            if (!((File)object3).exists()) {
                throw new LocalFileDoesNotExistException(string, copyCommand.getLocalFile());
            }
            object2 = copyCommand.getRemoteFile();
            arrayList.add(this.createLocalSpecifier((File)object3));
            arrayList.add(this.createRemoteSpecifier(string, (String)object2, RcpParameter.USERNAME, parameterMap));
        } else {
            object3 = copyCommand.getRemoteFile();
            object2 = copyCommand.getLocalFile();
            arrayList.add(this.createRemoteSpecifier(string, (String)object3, RcpParameter.USERNAME, parameterMap));
            arrayList.add(this.createLocalSpecifier((File)object2));
        }
        object3 = new StringBuilder();
        for (String object4 : arrayList) {
            ((StringBuilder)object3).append(object4);
            ((StringBuilder)object3).append(" ");
        }
        object2 = new ProcessBuilder(arrayList);
        Environment environment = parameterMap.get(ShellParameter.LOCAL_ENVIRONMENT);
        if (environment != null) {
            if (environment.clearBeforeSetting()) {
                ((ProcessBuilder)object2).environment().clear();
            }
            for (String string4 : environment.keySet()) {
                ((ProcessBuilder)object2).environment().put(string4, environment.get(string4));
            }
        }
        try {
            Process iOException = ((ProcessBuilder)object2).start();
            ProcessCopyFuture processCopyFuture = new ProcessCopyFuture(iOException, ((StringBuilder)object3).toString(), string);
            Logger.LOGGER.fine(string + " " + ((StringBuilder)object3).toString() + " started");
            return processCopyFuture;
        }
        catch (IOException iOException) {
            throw new CouldNotStartRcpProcessException(arrayList, iOException);
        }
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.copyFile((CopyCommand)command, string, parameterMap);
    }

    private static final class CouldNotStartRcpProcessException
    extends LocalProcessFailedException {
        private final BaseMsgID fBaseMsgID = new remote.CouldNotStartRcpProcess(this.getFormattedCommand());

        CouldNotStartRcpProcessException(List<String> list, IOException iOException) {
            super(list, iOException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    public static class RcpParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> USERNAME = new RcpParameter<String>(Key.USERNAME, false, true, String.class, System.getProperty("user.name"));
        public static final Parameter<String> RCP_COMMAND = new RcpParameter<String>(Key.RCP_COMMAND, false, false, String.class, "rcp");

        private RcpParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        @Override
        protected String getSimpleName() {
            return RcpParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            USERNAME,
            RCP_COMMAND;

        }
    }
}

