/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.service.ConnectTimeoutSocketFactory;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.UUID;
import javax.net.SocketFactory;

abstract class AbstractRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final String CONNECT_TIMEOUT_OVERRIDE_PROPERTY = "com.mathworks.toolbox.distcomp.rmi.clientConnectTimeout";
    private static final UUID JVM_ID = UUID.randomUUID();
    private final UUID fJVM_ID = JVM_ID;
    private final int fConnectTimeout;

    protected AbstractRMIClientSocketFactory() {
        this.fConnectTimeout = 0;
    }

    protected AbstractRMIClientSocketFactory(int n) {
        this.fConnectTimeout = n;
    }

    protected Socket createSocket(SocketFactory socketFactory, String string, int n) throws IOException {
        ConnectTimeoutSocketFactory connectTimeoutSocketFactory = new ConnectTimeoutSocketFactory(socketFactory, this.getConnectTimeout());
        return connectTimeoutSocketFactory.createSocket(string, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractRMIClientSocketFactory abstractRMIClientSocketFactory = (AbstractRMIClientSocketFactory)object;
        if (this.fConnectTimeout != abstractRMIClientSocketFactory.fConnectTimeout) {
            return false;
        }
        return this.fJVM_ID.equals(abstractRMIClientSocketFactory.fJVM_ID);
    }

    public int hashCode() {
        int n = this.fJVM_ID.hashCode();
        n = 31 * n + this.fConnectTimeout;
        return n;
    }

    private int getConnectTimeout() {
        int n = Integer.getInteger(CONNECT_TIMEOUT_OVERRIDE_PROPERTY, this.fConnectTimeout);
        if (n != this.fConnectTimeout) {
            PackageInfo.LOGGER.info("client connect timeout set to " + n + "ms");
        }
        return n;
    }
}

