/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.service.AbstractHostnameRMIClientSocketFactory;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public final class BasicRMISocketFactoryProvider
implements RMISocketFactoryProvider {
    private int fClientConnectTimeout;

    public BasicRMISocketFactoryProvider() {
        this.fClientConnectTimeout = 0;
    }

    public BasicRMISocketFactoryProvider(int n) {
        this.fClientConnectTimeout = n;
    }

    @Override
    public RMIClientSocketFactory getClientSocketFactory() {
        return new BasicRMIClientSocketFactory(this.fClientConnectTimeout);
    }

    @Override
    public RMIServerSocketFactory getServerSocketFactory() {
        return new BasicRMIServerSocketFactory();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicRMISocketFactoryProvider basicRMISocketFactoryProvider = (BasicRMISocketFactoryProvider)object;
        return this.fClientConnectTimeout == basicRMISocketFactoryProvider.fClientConnectTimeout;
    }

    public int hashCode() {
        return this.fClientConnectTimeout;
    }

    private static final class BasicRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private BasicRMIServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            return ServerSocketFactory.getDefault().createServerSocket(n);
        }

        public boolean equals(Object object) {
            return object != null && this.getClass().equals(object.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static final class BasicRMIClientSocketFactory
    extends AbstractHostnameRMIClientSocketFactory {
        private BasicRMIClientSocketFactory(int n) {
            super(n);
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException {
            return super.createSocket(SocketFactory.getDefault(), string, n);
        }
    }
}

