/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.distcompobjects.Distcomp;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.DistcompServiceLocal;
import com.mathworks.toolbox.distcomp.service.DistcompServiceRemote;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import java.rmi.RemoteException;
import net.jini.id.Uuid;

public abstract class DistcompServiceProxy
extends DistcompProxy
implements DistcompServiceLocal,
Identifiable {
    private static final long serialVersionUID = 1L;
    private final Uuid fServiceID;
    private String fHostName;
    private String fComputerMLType;
    private String[] fAllHostAddresses;
    private String fName;
    private final int fSecurityLevel;
    private final String fMatlabRoot;

    protected DistcompServiceProxy(Distcomp distcomp, Uuid uuid, String[] stringArray, String string, String string2, String string3, int n, String string4) throws DistcompProxy.SerializeProxyException {
        super(distcomp);
        this.fServiceID = uuid;
        this.fAllHostAddresses = (String[])stringArray.clone();
        this.fHostName = string;
        this.fComputerMLType = string4;
        this.fName = string2;
        this.fMatlabRoot = string3;
        this.fSecurityLevel = n;
    }

    @Override
    public String[] getAllHostAddresses() {
        return (String[])this.fAllHostAddresses.clone();
    }

    @Override
    public String getHostName() {
        return this.fHostName;
    }

    @Override
    public String getComputerMLType() {
        return this.fComputerMLType;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Uuid getID() {
        return this.fServiceID;
    }

    @Override
    public void prepareForShutdown() throws RemoteException {
        this.getRemoteObject().prepareForShutdown();
    }

    @Override
    public boolean isUsingSecureCommunication() throws RemoteException {
        return this.getRemoteObject().isUsingSecureCommunication();
    }

    @Override
    public int getState() throws RemoteException {
        return this.getRemoteObject().getState();
    }

    @Override
    public DistcompServiceInfo getServiceInfo() throws RemoteException, StorageException {
        DistcompServiceInfo distcompServiceInfo = this.getRemoteObject().getServiceInfo();
        distcompServiceInfo.setConstantServiceInfo(this.fHostName, this.fAllHostAddresses, this.fName, this.fMatlabRoot, this.fComputerMLType);
        return distcompServiceInfo;
    }

    @Override
    public NodeInfo getNodeInfo() throws RemoteException {
        return this.getRemoteObject().getNodeInfo();
    }

    @Override
    public int getSecurityLevel() {
        return this.fSecurityLevel;
    }

    @Override
    public String getMatlabRoot() {
        return this.fMatlabRoot;
    }

    @Override
    public byte[] createSalt() throws RemoteException {
        return this.getRemoteObject().createSalt();
    }

    @Override
    public Object provideEvidence(Object object) {
        try {
            return this.getRemoteObject().provideEvidence(object);
        }
        catch (RemoteException remoteException) {
            return remoteException;
        }
    }

    private DistcompServiceRemote getRemoteObject() throws DistcompProxy.DeserializeProxyException {
        return (DistcompServiceRemote)this.getSerializedProxy();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)object;
            return this.getID().equals((Object)identifiable.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

