/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.Cache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class LRUCache<K, V>
implements Cache<K, V> {
    private static final float LOAD_FACTOR = 0.75f;
    private final ReferenceQueue<V> fDeadReferenceQueue = new ReferenceQueue();
    private final Map<K, CacheReference> fMap;
    private CacheReference fHead = null;
    private CacheReference fTail = null;
    private final int fMaxActiveCacheSize;
    private int fActiveCacheSize = 0;
    private static final int NUM_KEY_LOCKS = 16;
    private final ReentrantLock[] fKeyLocks = new ReentrantLock[16];
    private final Object fLock = new Object();

    public LRUCache(int n) {
        assert (n > 0) : "Cache must contain at least one item";
        this.fMap = new HashMap<K, CacheReference>(n, 0.75f);
        this.fMaxActiveCacheSize = n;
        for (int i = 0; i < 16; ++i) {
            this.fKeyLocks[i] = new ReentrantLock();
        }
    }

    @Override
    public void lockAllKeys() {
        for (ReentrantLock reentrantLock : this.fKeyLocks) {
            reentrantLock.lock();
        }
    }

    @Override
    public void unlockAllKeys() {
        for (ReentrantLock reentrantLock : this.fKeyLocks) {
            reentrantLock.unlock();
        }
    }

    @Override
    @NotNull
    public Cache.CacheToken<K> lock(@NotNull K k) {
        ReentrantLock reentrantLock = this.getLockForKey(k);
        reentrantLock.lock();
        return new LRUCacheToken<K>(k, reentrantLock);
    }

    private ReentrantLock getLockForKey(K k) {
        return this.fKeyLocks[Math.abs(k.hashCode() % 16)];
    }

    @Override
    public V put(@NotNull K k, @NotNull V v) {
        assert (this.getLockForKey(k).isHeldByCurrentThread()) : "Lock not held for this key";
        return this.putImpl(k, v);
    }

    @Override
    public V put(@NotNull Cache.CacheToken<K> cacheToken, @NotNull V v) {
        assert (cacheToken.isValidKeyForCache(this)) : "Key was generated from a different cache";
        return this.putImpl(cacheToken.getKey(), v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putImpl(K k, V v) {
        Object object = this.fLock;
        synchronized (object) {
            this.expungeStaleValues();
            CacheReference cacheReference = new CacheReference(k, v);
            cacheReference.addAtHead();
            return this.returnValueAfterClearingRef(this.fMap.put(k, cacheReference));
        }
    }

    @Override
    public V get(@NotNull K k) {
        assert (this.getLockForKey(k).isHeldByCurrentThread()) : "Lock not held for this key";
        return this.getImpl(k);
    }

    @Override
    public V get(@NotNull Cache.CacheToken<K> cacheToken) {
        assert (cacheToken.isValidKeyForCache(this)) : "Key was generated from a different cache";
        return this.getImpl(cacheToken.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getImpl(K k) {
        Object object = this.fLock;
        synchronized (object) {
            this.expungeStaleValues();
            return this.returnValueAfterRefreshingCache(this.fMap.get(k));
        }
    }

    @Override
    public V remove(@NotNull K k) {
        assert (this.getLockForKey(k).isHeldByCurrentThread()) : "Lock not held for this key";
        return this.removeImpl(k);
    }

    @Override
    public V remove(@NotNull Cache.CacheToken<K> cacheToken) {
        assert (cacheToken.isValidKeyForCache(this)) : "Key was generated from a different cache";
        return this.remove(cacheToken.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeImpl(K k) {
        Object object = this.fLock;
        synchronized (object) {
            this.expungeStaleValues();
            return this.returnValueAfterClearingRef(this.fMap.remove(k));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> removeAll() {
        this.lockAllKeys();
        try {
            Object object = this.fLock;
            synchronized (object) {
                Object object2;
                this.expungeStaleValues();
                ArrayList<V> arrayList = new ArrayList<V>(this.fMap.size());
                Iterator<Map.Entry<K, CacheReference>> iterator = this.fMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    iterator.remove();
                    arrayList.add(this.returnValueAfterClearingRef((CacheReference)object2.getValue()));
                }
                object2 = arrayList;
                return object2;
            }
        }
        finally {
            this.unlockAllKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lockAllKeys();
        try {
            Object object = this.fLock;
            synchronized (object) {
                for (CacheReference cacheReference : this.fMap.values()) {
                    cacheReference.clear();
                }
                this.fMap.clear();
                this.fHead = null;
                this.fTail = null;
                this.fActiveCacheSize = 0;
            }
        }
        finally {
            this.unlockAllKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.fLock;
        synchronized (object) {
            this.expungeStaleValues();
            return this.fMap.size();
        }
    }

    private V returnValueAfterClearingRef(CacheReference cacheReference) {
        if (cacheReference == null) {
            return null;
        }
        Object t = cacheReference.get();
        cacheReference.remove();
        cacheReference.clear();
        return (V)t;
    }

    private V returnValueAfterRefreshingCache(CacheReference cacheReference) {
        if (cacheReference == null) {
            return null;
        }
        Object v = cacheReference.getAndRefresh();
        if (v == null) {
            return null;
        }
        if (cacheReference.isInActiveCache()) {
            cacheReference.moveToHead();
        } else {
            cacheReference.addAtHead();
        }
        return v;
    }

    private void expungeStaleValues() {
        block3: {
            try {
                CacheReference cacheReference;
                while ((cacheReference = (CacheReference)CacheReference.class.cast(this.fDeadReferenceQueue.poll())) != null) {
                    this.fMap.remove(cacheReference.getKey());
                    cacheReference.remove();
                }
            }
            catch (ClassCastException classCastException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Caught ClassCastException - incorrect object on dead reference queue");
            }
        }
    }

    private final class CacheReference
    extends WeakReference<V> {
        @NotNull
        private final K fKey;
        @NotNull
        private SoftReference<V> fSoftReference;
        private CacheReference fPrevious;
        private CacheReference fNext;
        private boolean fInActiveCache;

        CacheReference(@NotNull K k, V v) {
            super(v, LRUCache.this.fDeadReferenceQueue);
            this.fPrevious = null;
            this.fNext = null;
            this.fInActiveCache = false;
            this.fKey = k;
            this.fSoftReference = new SoftReference(v);
        }

        @NotNull
        K getKey() {
            return this.fKey;
        }

        void releaseSoftReference() {
            this.fSoftReference.clear();
        }

        public V getAndRefresh() {
            Object t = this.get();
            if (t != null && this.fSoftReference.get() == null) {
                this.fSoftReference = new SoftReference(t);
            }
            return t;
        }

        public void addAtHead() {
            assert (!this.fInActiveCache) : "Cannot add a cache object if it is already in the cache";
            if (LRUCache.this.fHead == null) {
                assert (LRUCache.this.fActiveCacheSize == 0) : "If head is null there can't be anything in the cache";
                this.fInActiveCache = true;
                LRUCache.this.fTail = this;
            } else {
                this.insertBefore(LRUCache.this.fHead);
            }
            LRUCache.this.fHead = this;
            if (LRUCache.this.fActiveCacheSize >= LRUCache.this.fMaxActiveCacheSize) {
                LRUCache.this.fTail.releaseSoftReference();
                LRUCache.this.fTail = LRUCache.this.fTail.detach();
            } else {
                LRUCache.this.fActiveCacheSize++;
            }
        }

        public void moveToHead() {
            assert (this.fInActiveCache) : "Cannot move a cache object if isn't in the cache";
            if (this.equals(LRUCache.this.fHead)) {
                return;
            }
            if (this.equals(LRUCache.this.fTail)) {
                LRUCache.this.fTail = this.fPrevious;
            }
            this.detach();
            this.insertBefore(LRUCache.this.fHead);
            LRUCache.this.fHead = this;
        }

        public void remove() {
            if (this.fInActiveCache) {
                if (this.equals(LRUCache.this.fHead)) {
                    LRUCache.this.fHead = this.fNext;
                }
                if (this.equals(LRUCache.this.fTail)) {
                    LRUCache.this.fTail = this.fPrevious;
                }
                this.detach();
                LRUCache.this.fActiveCacheSize--;
            }
        }

        private CacheReference detach() {
            CacheReference cacheReference = this.fPrevious;
            if (this.fPrevious != null) {
                this.fPrevious.fNext = this.fNext;
            }
            if (this.fNext != null) {
                this.fNext.fPrevious = this.fPrevious;
            }
            this.fPrevious = null;
            this.fNext = null;
            this.fInActiveCache = false;
            return cacheReference;
        }

        private void insertBefore(@NotNull CacheReference cacheReference) {
            assert (!this.fInActiveCache) : "Can only insert if not already in the active cache";
            assert (cacheReference.fInActiveCache) : "Can only insert before an active cache instance";
            this.fNext = cacheReference;
            this.fPrevious = cacheReference.fPrevious;
            this.fNext.fPrevious = this;
            if (this.fPrevious != null) {
                this.fPrevious.fNext = this;
            }
            this.fInActiveCache = true;
        }

        public boolean isInActiveCache() {
            return this.fInActiveCache;
        }

        @Override
        public void clear() {
            super.clear();
            this.fSoftReference.clear();
        }
    }

    private class LRUCacheToken<X>
    implements Cache.CacheToken<X> {
        @NotNull
        private final ReentrantLock fKeyLock;
        @NotNull
        private final X fKey;

        LRUCacheToken(@NotNull X x, ReentrantLock reentrantLock) {
            this.fKeyLock = reentrantLock;
            this.fKey = x;
        }

        @Override
        public void close() {
            this.fKeyLock.unlock();
        }

        @Override
        @NotNull
        public X getKey() {
            return this.fKey;
        }

        @Override
        public boolean isValidKeyForCache(Cache cache) {
            return LRUCache.this == cache;
        }
    }
}

