/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.cloud;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.credentials.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.StorageFactory;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.cloud.CloudStorage;
import com.mathworks.webservices.mjs.CloudMJSClient;
import com.mathworks.webservices.mjs.CloudMJSClientFactory;
import com.mathworks.webservices.mjs.CloudMJSQueueAccess;
import com.mathworks.webservices.mjs.exception.AuthenticationException;
import com.mathworks.webservices.mjs.model.request.CloudLoginRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueEnsureRequest;
import java.util.logging.Level;

public class GDSStorageFactory
implements StorageFactory {
    private static final String CLIENT_STRING = "MDPCT-" + InstutilResourceKeys.RELEASE.getString(new Object[0]);
    private final String fLoginToken;
    private final String fGDSEndPoint;
    private final String fQueueID;
    private CloudStorage fCloudStorage = null;

    public GDSStorageFactory(String string, String string2, String string3) {
        this.fLoginToken = string2;
        this.fGDSEndPoint = string;
        this.fQueueID = string3;
    }

    @Override
    public DatabaseStorage createDatabaseStorage() throws StorageInitException {
        PackageInfo.LOGGER.log(Level.FINE, "Creating DatabaseStorage");
        return this.getCloudStorage();
    }

    @Override
    public CredentialStorage createCredentialStorage() throws StorageInitException {
        throw new IllegalStateException("Credential storage is not supported with GDS storage.");
    }

    @Override
    public DataStorage createAppendableLargeDataStorage() throws StorageInitException {
        PackageInfo.LOGGER.log(Level.FINE, "Creating AppendableLargeDataStorage");
        return this.getCloudStorage();
    }

    private synchronized CloudStorage getCloudStorage() throws StorageInitException {
        if (this.fCloudStorage == null) {
            this.fCloudStorage = new CloudStorage(this.createCloudClient(), this.fLoginToken);
        }
        return this.fCloudStorage;
    }

    private CloudMJSClient createCloudClient() throws StorageInitException {
        PackageInfo.LOGGER.log(Level.FINE, "Creating CloudMJSClientImpl with endpoint: " + this.fGDSEndPoint + ", client string: " + CLIENT_STRING + " and queue id: " + this.fQueueID);
        CloudMJSClient cloudMJSClient = CloudMJSClientFactory.createClient((String)this.fGDSEndPoint, (String)CLIENT_STRING);
        CloudMJSQueueAccess cloudMJSQueueAccess = cloudMJSClient.getQueueAccess();
        try {
            cloudMJSClient.login(new CloudLoginRequest().withLoginToken(this.fLoginToken));
            cloudMJSQueueAccess.ensure(new CloudQueueEnsureRequest().withQueueUuid(this.fQueueID));
        }
        catch (AuthenticationException authenticationException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to authenticate with GDS.", authenticationException);
            throw new CloudAuthenticationFailedException(authenticationException);
        }
        return cloudMJSClient;
    }

    private static final class CloudAuthenticationFailedException
    extends StorageInitException {
        CloudAuthenticationFailedException(AuthenticationException authenticationException) {
            super((BaseMsgID)new mjs.GDSAuthenticationError(), (Throwable)authenticationException);
        }
    }
}

