/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileErrorCode;
import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePoolException;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.Semaphore;

public class RandomAccessFilePool {
    private Semaphore fFileHandles;

    public RandomAccessFilePool(int n) {
        this.fFileHandles = new Semaphore(n, true);
    }

    public RandomAccessFile getFile(File file) throws RandomAccessFilePoolException {
        RandomAccessFile randomAccessFile;
        this.fFileHandles.acquireUninterruptibly();
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fFileHandles.release();
            throw new CreateRandomAccessFileException(fileNotFoundException, file.toString());
        }
        return randomAccessFile;
    }

    public void returnFile(RandomAccessFile randomAccessFile) {
        this.closeRandomAccessFile(randomAccessFile);
        this.fFileHandles.release();
    }

    private void closeRandomAccessFile(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.warning("Failed to close random access file: " + iOException.getMessage());
        }
    }

    private static final class CreateRandomAccessFileException
    extends RandomAccessFilePoolException {
        CreateRandomAccessFileException(FileNotFoundException fileNotFoundException, String string) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.CreateRandomAccessFileError, (Throwable)fileNotFoundException, string);
        }
    }
}

