/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeListener;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.SignalingAtomicBoolean;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class UpdatePanel
implements UpdateChangeListener {
    private UpdateFrequency fUpdateFrequency;
    private final Runnable fScheduledUpdateTask;
    private final ScheduledExecutorService fUpdateScheduledExecutorService;
    private ScheduledFuture fUpdateFuture;
    private final SignalingAtomicBoolean fUpdateCompletedFlag = new SignalingAtomicBoolean(false);
    private Date fLastUpdated;
    private final MJLabel fLastUpdatedLabel;
    private final JComboBox fUpdateComboBox;
    private final JButton fUpdateButton;
    private final AbstractStyleGuidePanel fPanel;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final UpdateFrequency DEFAULT_UPDATE_FREQUENCY = UpdateFrequency.UPDATE_EVERY_5MIN;

    public UpdatePanel(final Runnable runnable, boolean bl) {
        this.fUpdateScheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fUpdateScheduledExecutorService-"), (Logger)PackageInfo.LOGGER));
        this.fScheduledUpdateTask = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                try {
                    UpdatePanel.this.fUpdateCompletedFlag.awaitTrue();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.fPanel = new StyleGuidePanel(){

            @Override
            protected int getRightInset() {
                return 0;
            }

            @Override
            protected int getLeftInset() {
                return 0;
            }
        };
        MJLabel mJLabel = new MJLabel(sRes.getString("updatepanel.autoupdate.label"));
        this.fUpdateComboBox = new MJComboBox((Object[])new UpdateFrequency[]{UpdateFrequency.UPDATE_NEVER, UpdateFrequency.UPDATE_EVERY_1MIN, UpdateFrequency.UPDATE_EVERY_5MIN, UpdateFrequency.UPDATE_EVERY_15MIN, UpdateFrequency.UPDATE_EVERY_30MIN, UpdateFrequency.UPDATE_EVERY_1HR});
        this.fUpdateComboBox.setMinimumSize(new Dimension((int)this.fUpdateComboBox.getPreferredSize().getWidth(), (int)this.fUpdateComboBox.getPreferredSize().getHeight()));
        this.fUpdateButton = new MJButton((Action)new MJAbstractAction(sRes.getString("updatepanel.updatenow.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.fUpdateScheduledExecutorService.execute(UpdatePanel.this.fScheduledUpdateTask);
            }
        });
        if (bl) {
            this.fUpdateFrequency = DEFAULT_UPDATE_FREQUENCY;
        } else {
            this.fUpdateFrequency = UpdateFrequency.UPDATE_NEVER;
            this.setEnabled(false);
        }
        this.fUpdateComboBox.setSelectedItem((Object)this.fUpdateFrequency);
        this.fUpdateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.setUpdateFrequency((UpdateFrequency)((Object)UpdatePanel.this.fUpdateComboBox.getSelectedItem()));
            }
        });
        this.fLastUpdatedLabel = new MJLabel();
        this.fLastUpdatedLabel.setFont(this.fLastUpdatedLabel.getFont().deriveFont(2));
        this.fPanel.addLine((JComponent[][])new JComponent[][]{{this.fLastUpdatedLabel, null, mJLabel, this.fUpdateComboBox, this.fUpdateButton}}, 0, 1);
        this.fUpdateComboBox.setName("UpdatePanel.UpdateCombobox");
        this.fLastUpdatedLabel.setName("UpdatePanel.LastUpdateLabel");
        this.fUpdateButton.setName("UpdatePanel.UpdateButton");
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public Date getLastUpdated() {
        return this.fLastUpdated;
    }

    public UpdateFrequency getUpdateFrequency() {
        return this.fUpdateFrequency;
    }

    public void setEnabled(boolean bl) {
        this.fUpdateComboBox.setEnabled(bl);
        this.fUpdateButton.setEnabled(bl);
    }

    public void setUpdateFrequency(UpdateFrequency updateFrequency) {
        this.fUpdateFrequency = updateFrequency;
        this.scheduleUpdateFuture();
    }

    public void setUpdateFrequencyDefaultAndRefreshComboBox() {
        this.setUpdateFrequency(DEFAULT_UPDATE_FREQUENCY);
        this.fUpdateComboBox.setSelectedItem((Object)DEFAULT_UPDATE_FREQUENCY);
    }

    private void scheduleUpdateFuture() {
        if (this.fUpdateFuture != null) {
            this.fUpdateFuture.cancel(true);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: Future canceled.");
        }
        if (!this.fUpdateFrequency.equals((Object)UpdateFrequency.UPDATE_NEVER)) {
            long l = 0L;
            if (this.fUpdateFuture == null) {
                l = this.fUpdateFrequency.getDelay();
            }
            this.fUpdateFuture = this.fUpdateScheduledExecutorService.scheduleWithFixedDelay(this.fScheduledUpdateTask, l, this.fUpdateFrequency.getDelay(), TimeUnit.MILLISECONDS);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: New future created.");
        }
    }

    @Override
    public void updateStarted() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: UpdateStarted.");
        this.fUpdateCompletedFlag.set(false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.startUpdatingState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdatePanel.this.startUpdatingState();
                }
            });
        }
    }

    @Override
    public void updateFinished() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: UpdateFinished.");
        this.fUpdateCompletedFlag.set(true);
        this.fLastUpdated = new Date();
        if (SwingUtilities.isEventDispatchThread()) {
            this.finishUpdatingState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdatePanel.this.finishUpdatingState();
                }
            });
        }
    }

    @Override
    public void updateCanceled() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: UpdateCanceled.");
        this.fUpdateCompletedFlag.set(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancelUpdatingState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdatePanel.this.cancelUpdatingState();
                }
            });
        }
    }

    private void startUpdatingState() {
        this.fLastUpdatedLabel.setText(sRes.getString("updatepanel.updating.label"));
        this.fLastUpdatedLabel.setIcon(ParallelIcon.BUSY.getIcon());
        this.fUpdateComboBox.setEnabled(false);
        this.fUpdateButton.setEnabled(false);
    }

    private void finishUpdatingState() {
        if (this.fLastUpdated != null) {
            this.fLastUpdatedLabel.setText(MessageFormat.format(sRes.getString("updatepanel.lastupdated.label"), this.fLastUpdated.toString()));
        } else {
            this.fLastUpdatedLabel.setText("");
        }
        this.fLastUpdatedLabel.setIcon(null);
        this.fUpdateComboBox.setEnabled(true);
        this.fUpdateButton.setEnabled(true);
    }

    private void cancelUpdatingState() {
        if (this.fLastUpdated != null) {
            this.fLastUpdatedLabel.setText(MessageFormat.format(sRes.getString("updatepanel.lastupdated.label"), this.fLastUpdated.toString()));
        } else {
            this.fLastUpdatedLabel.setText("");
        }
        this.fLastUpdatedLabel.setIcon(null);
        this.fUpdateComboBox.setEnabled(true);
        this.fUpdateButton.setEnabled(true);
    }

    public void startAutoUpdating() {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.fUpdateComboBox.getActionListeners()) {
            this.fUpdateComboBox.removeActionListener(actionListener);
        }
        this.fUpdateComboBox.setSelectedItem((Object)this.fUpdateFrequency);
        for (ActionListener actionListener : actionListenerArray) {
            this.fUpdateComboBox.addActionListener(actionListener);
        }
        this.scheduleUpdateFuture();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: Start Auto Update.");
    }

    public void stopAutoUpdating() {
        ActionListener[] actionListenerArray;
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdatePanel: Stop Auto Update.");
        if (this.fUpdateFuture != null) {
            this.fUpdateFuture.cancel(true);
        }
        for (ActionListener actionListener : actionListenerArray = this.fUpdateComboBox.getActionListeners()) {
            this.fUpdateComboBox.removeActionListener(actionListener);
        }
        this.fUpdateComboBox.setSelectedItem((Object)UpdateFrequency.UPDATE_NEVER);
        for (ActionListener actionListener : actionListenerArray) {
            this.fUpdateComboBox.addActionListener(actionListener);
        }
    }

    public static enum UpdateFrequency {
        UPDATE_NEVER(0L, "updatepanel.combobox.never"),
        UPDATE_EVERY_1MIN(60000L, "updatepanel.combobox.every1min"),
        UPDATE_EVERY_5MIN(300000L, "updatepanel.combobox.every5mins"),
        UPDATE_EVERY_15MIN(900000L, "updatepanel.combobox.every15mins"),
        UPDATE_EVERY_30MIN(1800000L, "updatepanel.combobox.every30mins"),
        UPDATE_EVERY_1HR(3600000L, "updatepanel.combobox.every1hr");

        private final long fDelay;
        private final String fDisplayString;

        private UpdateFrequency(long l, String string2) {
            this.fDelay = l;
            this.fDisplayString = sRes.getString(string2);
        }

        public String toString() {
            return this.fDisplayString;
        }

        public long getDelay() {
            return this.fDelay;
        }
    }
}

