/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.ui.desk.JobMonitorDesktopClient;
import com.mathworks.toolbox.distcomp.ui.desk.ProfileDesktopMenuProvider;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class MLDesktopParallelMenu {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    private static final String PARALLEL_PREF_NODE = "Parallel Computing Toolbox";

    private MLDesktopParallelMenu() {
    }

    public static void populate(JMenu jMenu) {
        ProfileDesktopMenuProvider.populate(jMenu);
        JMenuItem jMenuItem = new JMenuItem((Action)new MJAbstractAction(sRes.getString("ParallelMenu.JobMonitor.MenuItem.Label")){

            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorDesktopClient.getInstance();
                JobMonitorDesktopClient.showUI();
            }
        });
        jMenuItem.setName("ParallelMenu.JobMonitor");
        jMenu.add(jMenuItem);
    }

    static void populate(PopupList popupList) {
        ProfileDesktopMenuProvider.addCurrentClusterListItem(popupList);
        ListItem listItem = ProfileDesktopMenuProvider.addDiscoverClusterListItem(popupList);
        listItem.getAttributes().setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
        MLDesktopParallelMenu.addParallelPreferenceListItem(popupList);
        ListItem listItem2 = ProfileDesktopMenuProvider.addProfileManagerListItem(popupList);
        listItem2.getAttributes().setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
        MLDesktopParallelMenu.addJobMonitorListItem(popupList);
    }

    private static ListItem addJobMonitorListItem(PopupList popupList) {
        final ListItem listItem = ListItem.newItem((String)"ParallelMenu.JobMonitor", (String)sRes.getString("HomeTab.Parallel.JobMonitor.Label"));
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        defaultListModel.addElement(listItem);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (listActionEvent.getListItem().equals((Object)listItem)) {
                    JobMonitorDesktopClient.getInstance();
                    JobMonitorDesktopClient.showUI();
                }
            }
        });
        return listItem;
    }

    private static ListItem addParallelPreferenceListItem(PopupList popupList) {
        final ListItem listItem = ListItem.newItem((String)"ParallelMenu.Preference", (String)sRes.getString("HomeTab.Parallel.Preference.Label"));
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        defaultListModel.addElement(listItem);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (listActionEvent.getListItem().equals((Object)listItem)) {
                    MLPrefsDialogServices.showPrefsDialog((String)MLDesktopParallelMenu.PARALLEL_PREF_NODE);
                }
            }
        });
        return listItem;
    }
}

