/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.jidesoft.icons.ColorFilter;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionCreationListener;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionFactory;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.desk.ClientSessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.model.SessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolstrip.accessories.CalloutToolTip;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class ParallelStatusIndicator {
    private final ParallelStatusIndicatorUI fParallelStatusIndicatorUI;
    private static ParallelStatusIndicator sInstanceForMLDesktop;
    private static final String PARALLEL_PREF_NODE = "Parallel Computing Toolbox";
    private static final ResourceBundle sRes;

    public ParallelStatusIndicator(SessionInfoProvider sessionInfoProvider) {
        this.fParallelStatusIndicatorUI = new ParallelStatusIndicatorUI(sessionInfoProvider);
        SessionFactory.addSessionCreationListener(this.fParallelStatusIndicatorUI);
    }

    public void dispose() {
        SessionFactory.removeSessionCreationListener(this.fParallelStatusIndicatorUI);
    }

    public JComponent getComponent() {
        return this.fParallelStatusIndicatorUI;
    }

    public static void addStatus(JPanel jPanel) {
        if (sInstanceForMLDesktop == null) {
            sInstanceForMLDesktop = new ParallelStatusIndicator(ClientSessionInfoProvider.getInstance());
        }
        jPanel.add((Component)sInstanceForMLDesktop.getComponent(), "West");
    }

    private static void runOnEdtThread(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    }

    private static class PoolIconDecorator
    implements Icon {
        private final Icon fOriginalIcon;
        private final Icon fArrowIcon = ParallelIcon.UP_ARROW_5X3.getIcon();
        private static final int SPACE_BETWEEN = 2;

        private PoolIconDecorator(Icon icon) {
            assert (icon != null) : "The original icon can not be null";
            this.fOriginalIcon = icon;
        }

        @Override
        public int getIconHeight() {
            return this.fOriginalIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.fOriginalIcon.getIconWidth() + 2 + this.fArrowIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            assert (this.fOriginalIcon != null) : "The original icon can not be null";
            Icon icon = this.fOriginalIcon;
            JButton jButton = (JButton)component;
            if (jButton.getModel().isRollover()) {
                BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                icon.paintIcon(jButton, bufferedImage.getGraphics(), 0, 0);
                icon = new ImageIcon(ColorFilter.createDarkerImage((Image)bufferedImage));
            }
            icon.paintIcon(component, graphics, n, n2);
            int n3 = n + icon.getIconWidth() + 2;
            int n4 = n2 + this.getIconHeight() / 2 - this.fArrowIcon.getIconHeight() / 2;
            this.fArrowIcon.paintIcon(component, graphics, n3, n4);
        }
    }

    private static class ParallelStatusIndicatorUI
    extends StyleGuideEmptyPanel
    implements SessionCreationListener,
    SessionListener {
        private final SessionInfoProvider fSessionInfoProvider;
        private boolean fToolTipAutomaticallyShown = false;
        private final ScheduledExecutorService fAutoToolTipScheduler;
        private ScheduledFuture<?> fToolTipFuture = null;
        private ScheduledFuture<?> fHideToolTipFuture = null;
        private static final long AUTO_SHUTDOWN_REMINDER_2_MINUTES_BEFORE = 120L;
        private static final long AUTO_SHUTDOWN_REMINDER_IMMEDIATE = 0L;
        private static final long CLOSE_TOOL_TIP_DELAY_SECONDS = 5L;
        private JButton fPoolButton;
        private JPopupMenu fPoolMenu;
        private CalloutToolTip fTip;
        private JMenuItem fCreatePoolMenuItem;
        private JMenuItem fDeletePoolMenuItem;
        private JMenuItem fShowPreferenceMenuItem;
        private static final int LEFT_PADDING = 5;
        private static final String START_POOL_FUNCTION = "parallel.internal.ui.PoolHelper.startPool";
        private static final Object[] NO_INPUTS = new Object[0];
        private static final int NO_OUTPUTS = 0;
        private static final boolean SHOW_MSG_CMD_WINDOW = true;
        private SessionService fCacheSessionService = null;
        private StyleGuidePanel fTooltipContentPane;
        private static final int PREFERRED_TOOLTIP_WIDTH = 250;
        private static final int PREFERRED_TOOLTIP_HEIGHT = 50;

        private ParallelStatusIndicatorUI(SessionInfoProvider sessionInfoProvider) {
            this.fSessionInfoProvider = sessionInfoProvider;
            this.fAutoToolTipScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fAutoToolTipScheduler-"), (Logger)PackageInfo.LOGGER));
            this.createPoolButton();
            JSeparator jSeparator = new JSeparator(1);
            this.addLine((JComponent[][])new JComponent[][]{{this.fPoolButton, jSeparator}}, 8, 0);
            this.fPoolButton.setPreferredSize(new Dimension(this.fPoolButton.getIcon().getIconWidth(), this.fPoolButton.getIcon().getIconHeight()));
            ParallelStatusIndicatorUI.resolveMacSeparatorIssues(this.fPoolButton, jSeparator);
            this.fPoolButton.setName("PoolIndicator.PoolButton");
            this.fCreatePoolMenuItem.setName("PoolIndicator.CreateMenuItem");
            this.fDeletePoolMenuItem.setName("PoolIndicator.DeleteMenuItem");
            this.fShowPreferenceMenuItem.setName("PoolIndicator.PreferenceMenuItem");
            this.setName("ParallelStatusIndicator.Panel");
        }

        private static void resolveMacSeparatorIssues(JButton jButton, JSeparator jSeparator) {
            if (PlatformInfo.isMacintosh()) {
                jSeparator.setMinimumSize(new Dimension(10, jButton.getIcon().getIconHeight()));
            }
        }

        private void createPoolButton() {
            this.fPoolButton = new JButton();
            this.fPoolButton.setFocusable(false);
            this.fPoolButton.setBorderPainted(false);
            this.fPoolButton.setOpaque(false);
            this.fPoolButton.setContentAreaFilled(false);
            this.fPoolButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ParallelStatusIndicatorUI.this.fPoolButton.getModel().setRollover(true);
                    ParallelStatusIndicatorUI.this.fPoolButton.invalidate();
                    ParallelStatusIndicatorUI.this.fPoolButton.repaint();
                    ParallelStatusIndicatorUI.this.updateToolTipContentIfNecessary();
                    ParallelStatusIndicatorUI.this.fToolTipAutomaticallyShown = false;
                    ParallelStatusIndicatorUI.this.showToolTip();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ParallelStatusIndicatorUI.this.fPoolButton.getModel().setRollover(false);
                    ParallelStatusIndicatorUI.this.fPoolButton.revalidate();
                    ParallelStatusIndicatorUI.this.fPoolButton.repaint();
                    if (!ParallelStatusIndicatorUI.this.fTip.getBounds().contains(mouseEvent.getLocationOnScreen())) {
                        ParallelStatusIndicatorUI.this.hideToolTip();
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = (int)ParallelStatusIndicatorUI.this.fPoolMenu.getPreferredSize().getHeight();
                    ParallelStatusIndicatorUI.this.fPoolMenu.show(ParallelStatusIndicatorUI.this.fPoolButton, 0, ParallelStatusIndicatorUI.this.fPoolButton.getY() - n);
                }
            });
            this.updateIcon(SessionInfo.NULL_SESSION_INFO);
            this.createCalloutToolTip();
            this.updateToolTipContent(SessionInfo.NULL_SESSION_INFO);
            this.createMenu();
            this.addGlobalMouseListener();
        }

        @Override
        protected int getLeftInset() {
            return 5;
        }

        private void cacheSessionService(SessionService sessionService) {
            this.fCacheSessionService = sessionService;
        }

        private void releaseSessionService() {
            this.fCacheSessionService = null;
        }

        private void handlePoolCreated(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
            this.scheduleShutDownToolTip(sessionInfo);
        }

        private void handlePoolChangedSize(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
        }

        private void handleIdleShutdownTimeOutChanged(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
            if (sessionInfo.getState().equals((Object)SessionInfo.SessionState.IDLE)) {
                this.scheduleShutDownToolTip(sessionInfo);
            }
        }

        private void handleRestartOnClusterChanged(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
        }

        private void handlePoolClosed(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
        }

        private void handlePoolErrored(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
        }

        private void handlePoolFailedToStart(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
        }

        private void handlePoolBusy(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
            if (this.fToolTipFuture != null) {
                this.cancelToolTipFuture();
            }
        }

        private void handlePoolIdle(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
            this.scheduleShutDownToolTip(sessionInfo);
        }

        private void handlePoolStarting(SessionInfo sessionInfo) {
            this.handleSessionInfoChanged(sessionInfo);
            this.createAutoTooltipFuture(0L);
        }

        private void handleSessionInfoChanged(SessionInfo sessionInfo) {
            this.updateMenu(sessionInfo);
            this.updateIcon(sessionInfo);
            this.updateToolTipContent(sessionInfo);
        }

        private void scheduleShutDownToolTip(SessionInfo sessionInfo) {
            if (sessionInfo.getIdleShutdownTimeout() < Long.MAX_VALUE) {
                if (sessionInfo.getRemainingSecondsBeforeShutdown() < 120L) {
                    this.createAutoTooltipFuture(0L);
                } else {
                    this.createAutoTooltipFuture(sessionInfo.getIdleShutdownTimeout() - 120L + 1L);
                }
            }
        }

        private void cancelToolTipFuture() {
            this.fToolTipAutomaticallyShown = false;
            this.fToolTipFuture.cancel(true);
        }

        private void createAutoTooltipFuture(long l) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ParallelStatusIndicatorUI.this.fToolTipFuture.isCancelled()) {
                                return;
                            }
                            ParallelStatusIndicatorUI.this.fToolTipAutomaticallyShown = true;
                            try {
                                ParallelStatusIndicatorUI.this.updateToolTipContentIfNecessary();
                                ParallelStatusIndicatorUI.this.showToolTip();
                            }
                            catch (Exception exception) {
                                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Exception errored while trying to show the tooltip.", exception);
                            }
                        }
                    });
                    ParallelStatusIndicatorUI.this.createAutoHideTooltipFuture();
                }
            };
            if (this.fToolTipFuture != null) {
                this.cancelToolTipFuture();
            }
            this.fToolTipFuture = this.fAutoToolTipScheduler.schedule(runnable, l, TimeUnit.SECONDS);
        }

        private void createAutoHideTooltipFuture() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                        @Override
                        public void run() {
                            ParallelStatusIndicatorUI.this.fToolTipAutomaticallyShown = false;
                            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                            if (pointerInfo == null) {
                                return;
                            }
                            Point point = pointerInfo.getLocation();
                            if (ParallelStatusIndicatorUI.this.fTip != null && ParallelStatusIndicatorUI.this.fTip.getBounds().contains(point)) {
                                return;
                            }
                            ParallelStatusIndicatorUI.this.hideToolTip();
                        }
                    });
                }
            };
            this.fHideToolTipFuture = this.fAutoToolTipScheduler.schedule(runnable, 5L, TimeUnit.SECONDS);
        }

        private void updateToolTipContentIfNecessary() {
            SessionInfo sessionInfo = this.fSessionInfoProvider.getSessionInfo();
            if (!sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
                this.updateToolTipContent(sessionInfo);
            }
        }

        private void showToolTip() {
            this.hideToolTip();
            if (this.fPoolMenu.isVisible()) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getActiveWindow();
            this.fTip.show();
            if (window != null) {
                window.toFront();
            }
            if (this.fHideToolTipFuture != null) {
                this.fHideToolTipFuture.cancel(true);
            }
            this.createAutoHideTooltipFuture();
        }

        private void updateToolTipContent(final SessionInfo sessionInfo) {
            Object object = null;
            if (sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
                object = new MJLabel(sRes.getString("ParallelStatus.Tooltip.NoPoolOpened"));
            } else {
                switch (sessionInfo.getState()) {
                    case STARTING: {
                        String string = sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.PoolStartingNoName"), sessionInfo.getClusterType()) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.PoolStarting"), sessionInfo.getProfileName());
                        object = new MJLabel(string);
                        break;
                    }
                    case FAILED_TO_START: {
                        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(sRes.getString("ParallelStatus.Tooltip.FailedToStart"), new HyperlinkTextLabel.HyperlinkHandler(){

                            public void processHyperlink(String string) {
                                ParallelStatusIndicatorUI.this.showErrorInCommandWindow(sessionInfo);
                            }
                        });
                        object = hyperlinkTextLabel.getComponent();
                        break;
                    }
                    case BUSY: {
                        String string = sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.BusyNoName"), sessionInfo.getSize(), sessionInfo.getClusterType()) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.Busy"), sessionInfo.getSize(), sessionInfo.getProfileName());
                        object = new MJLabel(string);
                        break;
                    }
                    case IDLE: {
                        if (sessionInfo.getIdleShutdownTimeout() < Long.MAX_VALUE) {
                            long l = sessionInfo.getRemainingSecondsBeforeShutdown();
                            int n = (int)Math.ceil((double)l / 60.0);
                            if (sessionInfo.getIdleShutdownTimeout() - l < 60L && sessionInfo.getIdleShutdownTimeout() > 60L) {
                                String string = sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleNoName"), sessionInfo.getSize(), n) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.Idle"), sessionInfo.getSize(), sessionInfo.getProfileName(), n);
                                object = new MJLabel(string);
                                break;
                            }
                            long l2 = sessionInfo.getIdleShutdownTimeout() / 60L;
                            String string = n == 1 ? (sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleNoNameWithExtendLessThanOneMinute"), sessionInfo.getSize(), l2) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleWithExtendLessThanOneMinute"), sessionInfo.getSize(), sessionInfo.getProfileName(), l2)) : (sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleNoNameWithExtend"), sessionInfo.getSize(), n, l2) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleWithExtend"), sessionInfo.getSize(), sessionInfo.getProfileName(), n, l2));
                            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new HyperlinkTextLabel.HyperlinkHandler(){

                                public void processHyperlink(String string) {
                                    ParallelStatusIndicatorUI.this.extendShutdownIdleTimeout();
                                }
                            });
                            object = hyperlinkTextLabel.getComponent();
                            break;
                        }
                        String string = sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleNoNameNoTimeout"), sessionInfo.getSize(), sessionInfo.getClusterType()) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.IdleNoTimeout"), sessionInfo.getSize(), sessionInfo.getProfileName());
                        object = new MJLabel(string);
                        break;
                    }
                    case CLOSED: {
                        if (sessionInfo.getError().isEmpty()) {
                            String string = sessionInfo.getProfileName().isEmpty() ? MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.PoolClosedNoName"), sessionInfo.getClusterType()) : MessageFormat.format(sRes.getString("ParallelStatus.Tooltip.PoolClosed"), sessionInfo.getProfileName());
                            object = new MJLabel(string);
                            break;
                        }
                        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(sRes.getString("ParallelStatus.Tooltip.PoolClosedErrored"), new HyperlinkTextLabel.HyperlinkHandler(){

                            public void processHyperlink(String string) {
                                ParallelStatusIndicatorUI.this.showErrorInCommandWindow(sessionInfo);
                            }
                        });
                        object = hyperlinkTextLabel.getComponent();
                    }
                }
            }
            assert (object != null) : "The tool tip cannot be empty.";
            if ((int)object.getPreferredSize().getWidth() > 250) {
                int n = FontUtils.getTextWidth((Font)object.getFont(), (String)sessionInfo.getProfileName());
                object.setPreferredSize(new Dimension(Math.max(n, 250), 50));
            }
            object.setName("PoolIndicator.Tooltip.Label");
            this.fTooltipContentPane.removeAll();
            this.fTooltipContentPane.addLine((JComponent)object, 8);
            if (this.fTip.isShowing()) {
                this.showToolTip();
            }
        }

        private void createCalloutToolTip() {
            this.fTooltipContentPane = new StyleGuidePanel();
            this.fTooltipContentPane.setBackground(TooltipUtils.getTooltipBackground());
            ArrayList<CalloutToolTip.Direction> arrayList = new ArrayList<CalloutToolTip.Direction>();
            arrayList.add(CalloutToolTip.Direction.NORTH);
            this.fTip = new CalloutToolTip((Component)((Object)this), (Component)((Object)this.fTooltipContentPane), arrayList);
        }

        private void hideToolTip() {
            if (this.fTip != null && this.fTip.isShowing()) {
                this.fTip.hide();
            }
        }

        private void addGlobalMouseListener() {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (ParallelStatusIndicatorUI.this.fTip != null && ParallelStatusIndicatorUI.this.fTip.isShowing() && aWTEvent.getID() == 503) {
                        Point point = ((MouseEvent)aWTEvent).getPoint();
                        SwingUtilities.convertPointToScreen(point, ((ComponentEvent)aWTEvent).getComponent());
                        if (ParallelStatusIndicatorUI.this.fTip.getBounds().contains(point)) {
                            return;
                        }
                        if (((ComponentEvent)aWTEvent).getComponent() == ParallelStatusIndicatorUI.this.fPoolButton) {
                            return;
                        }
                        if (ParallelStatusIndicatorUI.this.fToolTipAutomaticallyShown) {
                            return;
                        }
                        ParallelStatusIndicatorUI.this.hideToolTip();
                    }
                }
            }, 32L);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (ParallelStatusIndicatorUI.this.fTip != null && ParallelStatusIndicatorUI.this.fTip.isShowing() && (aWTEvent.getID() == 501 || aWTEvent.getID() == 502)) {
                        Point point = ((MouseEvent)aWTEvent).getPoint();
                        SwingUtilities.convertPointToScreen(point, ((ComponentEvent)aWTEvent).getComponent());
                        if (ParallelStatusIndicatorUI.this.fTip.getBounds().contains(point)) {
                            return;
                        }
                        ParallelStatusIndicatorUI.this.hideToolTip();
                    }
                }
            }, 16L);
        }

        private void extendShutdownIdleTimeout() {
            this.fCacheSessionService.extendShutDownTimeout();
        }

        private void createMenu() {
            this.fPoolMenu = new JPopupMenu();
            this.fCreatePoolMenuItem = new JMenuItem((Action)new MJAbstractAction(sRes.getString("ParallelStatus.MenuItem.CreatePool")){

                public void actionPerformed(ActionEvent actionEvent) {
                    new MatlabWorker(){

                        public Object runOnMatlabThread() throws Exception {
                            1.feval((String)ParallelStatusIndicatorUI.START_POOL_FUNCTION, (Object[])NO_INPUTS, (int)0, (boolean)true);
                            return null;
                        }

                        public void runOnAWTEventDispatchThread(Object object) {
                        }

                        protected void handleException(Exception exception, boolean bl) {
                            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                                @Override
                                public void run() {
                                    ParallelStatusIndicatorUI.this.fCreatePoolMenuItem.setEnabled(true);
                                }
                            });
                            if (!bl) {
                                super.handleException(exception, bl);
                            }
                        }
                    }.start();
                    ParallelStatusIndicatorUI.this.fCreatePoolMenuItem.setEnabled(false);
                }
            });
            this.fDeletePoolMenuItem = new JMenuItem((Action)new MJAbstractAction(sRes.getString("ParallelStatus.MenuItem.DeletePool")){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParallelStatusIndicatorUI.this.fCacheSessionService.shutdown();
                }
            });
            this.fShowPreferenceMenuItem = new JMenuItem((Action)new MJAbstractAction(sRes.getString("ParallelStatus.MenuItem.Preferences")){

                public void actionPerformed(ActionEvent actionEvent) {
                    MLPrefsDialogServices.showPrefsDialog((String)ParallelStatusIndicator.PARALLEL_PREF_NODE);
                }
            });
            this.fPoolMenu.add(this.fCreatePoolMenuItem);
            this.fPoolMenu.add(this.fDeletePoolMenuItem);
            this.fPoolMenu.add(this.fShowPreferenceMenuItem);
            this.updateMenu(this.fSessionInfoProvider.getSessionInfo());
        }

        private void updateMenu(SessionInfo sessionInfo) {
            boolean bl = false;
            boolean bl2 = false;
            if (sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
                bl = true;
                bl2 = true;
            } else {
                SessionInfo.SessionState sessionState = sessionInfo.getState();
                switch (sessionState) {
                    case STARTING: {
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    case FAILED_TO_START: {
                        bl = true;
                        bl2 = false;
                        break;
                    }
                    case BUSY: {
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    case IDLE: {
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    case CLOSED: {
                        bl = true;
                        bl2 = false;
                    }
                }
            }
            this.fCreatePoolMenuItem.setVisible(bl);
            this.fDeletePoolMenuItem.setVisible(!bl);
            this.fCreatePoolMenuItem.setEnabled(bl);
            this.fDeletePoolMenuItem.setEnabled(bl2);
            this.fShowPreferenceMenuItem.setVisible(true);
            if (this.fPoolMenu.isVisible()) {
                this.fPoolMenu.pack();
            }
        }

        private void updateIcon(SessionInfo sessionInfo) {
            Icon icon = null;
            switch (sessionInfo.getState()) {
                case STARTING: {
                    icon = ParallelIcon.POOL_ANIMATING.getIcon();
                    ((ImageIcon)icon).setImageObserver((ImageObserver)((Object)this));
                    break;
                }
                case FAILED_TO_START: {
                    icon = ParallelIcon.POOL_ERRORED.getIcon();
                    break;
                }
                case BUSY: {
                    double d = (double)sessionInfo.getNumWorkersBusy() / (double)sessionInfo.getSize();
                    if (d <= 0.1) {
                        icon = ParallelIcon.POOL_10_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.2) {
                        icon = ParallelIcon.POOL_20_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.3) {
                        icon = ParallelIcon.POOL_30_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.4) {
                        icon = ParallelIcon.POOL_40_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.5) {
                        icon = ParallelIcon.POOL_50_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.6) {
                        icon = ParallelIcon.POOL_60_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.7) {
                        icon = ParallelIcon.POOL_70_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.8) {
                        icon = ParallelIcon.POOL_80_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 0.9) {
                        icon = ParallelIcon.POOL_90_PERCENT.getIcon();
                        break;
                    }
                    if (d <= 1.0) {
                        icon = ParallelIcon.POOL_100_PERCENT.getIcon();
                        break;
                    }
                    icon = ParallelIcon.POOL_100_PERCENT.getIcon();
                    break;
                }
                case IDLE: {
                    icon = ParallelIcon.POOL_0_PERCENT.getIcon();
                    break;
                }
                case CLOSED: {
                    icon = sessionInfo.getError().isEmpty() ? ParallelIcon.POOL_CLOSED.getIcon() : ParallelIcon.POOL_ERRORED.getIcon();
                }
            }
            this.fPoolButton.setIcon(new PoolIconDecorator(icon));
        }

        @Override
        public void sessionStarting(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolStarting(sessionInfo);
                }
            });
        }

        @Override
        public void sessionFailedToStart(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolFailedToStart(sessionInfo);
                }
            });
        }

        @Override
        public void sessionCreated(SessionCreatedEvent sessionCreatedEvent) {
            sessionCreatedEvent.getSessionService().addSessionListener(this);
            final SessionInfo sessionInfo = sessionCreatedEvent.getSessionInfo();
            this.cacheSessionService(sessionCreatedEvent.getSessionService());
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolCreated(sessionInfo);
                }
            });
        }

        @Override
        public void sessionClosed(SessionEndedEvent sessionEndedEvent) {
            sessionEndedEvent.getSessionService().removeSessionListener(this);
            final SessionInfo sessionInfo = sessionEndedEvent.getSessionInfo();
            this.releaseSessionService();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolClosed(sessionInfo);
                }
            });
        }

        @Override
        public void sessionErrored(SessionEndedEvent sessionEndedEvent) {
            sessionEndedEvent.getSessionService().removeSessionListener(this);
            final SessionInfo sessionInfo = sessionEndedEvent.getSessionInfo();
            this.releaseSessionService();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolErrored(sessionInfo);
                }
            });
        }

        @Override
        public void sessionChangedSize(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolChangedSize(sessionInfo);
                }
            });
        }

        @Override
        public void sessionChangedIdleTimeout(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handleIdleShutdownTimeOutChanged(sessionInfo);
                }
            });
        }

        @Override
        public void sessionChangedRestartOnClusterChange(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handleRestartOnClusterChanged(sessionInfo);
                }
            });
        }

        @Override
        public void sessionBusy(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolBusy(sessionInfo);
                }
            });
        }

        @Override
        public void sessionIdle(SessionEvent sessionEvent) {
            final SessionInfo sessionInfo = sessionEvent.getSessionInfo();
            ParallelStatusIndicator.runOnEdtThread(new Runnable(){

                @Override
                public void run() {
                    ParallelStatusIndicatorUI.this.handlePoolIdle(sessionInfo);
                }
            });
        }

        private void showErrorInCommandWindow(SessionInfo sessionInfo) {
            this.hideToolTip();
            System.err.println(sessionInfo.getError());
            MatlabDesktopServices.showCommandWindow();
        }
    }
}

