/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.model;

import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Selection<T> {
    private AtomicReference<T> fSelectedObject;
    private List<SelectionListener> fSelectionListeners;

    public Selection(T t) {
        this.fSelectedObject = new AtomicReference<T>(t);
        this.fSelectionListeners = new ArrayList<SelectionListener>();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.remove(selectionListener);
    }

    public T getSelection() {
        return this.fSelectedObject.get();
    }

    public void setSelection(T t) {
        T t2 = this.fSelectedObject.getAndSet(t);
        SelectionEvent<T> selectionEvent = new SelectionEvent<T>(t2, t);
        for (SelectionListener selectionListener : this.fSelectionListeners) {
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

