/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.model.Constraint;
import com.mathworks.toolbox.distcomp.ui.model.PropertyInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertyInfoProvider {
    private static final String FILENAME = "/com/mathworks/toolbox/distcomp/ui/resources/clusterprofiles.xml";
    private static final String PROFILE_NODE = "Profile";
    private static final String PROJECT_COMPONENT_NODE = "ProjectComponent";
    private static final String SCHEDULER_COMPONENTS_NODE = "SchedulerComponents";
    private static final String SCHEDULER_COMPONENT_NODE = "SchedulerComponent";
    private static final String ENUM_VALUE_NODE = "StringEnumValue";
    private static final String NAME_NODE = "Name";
    private static final String SCHEDULER_TYPE_NODE = "Type";
    private static final String PROPERTIES_NODE = "Properties";
    private static final String PROPERTY_NODE = "Property";
    private static final String CONSTRAINT_NODE = "Constraint";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private static final ResourceBundle sRes_NoTranslation = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile_notranslation");
    private static final String PRIORITY_INDEX_KEY = "PriorityIndex";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String DEFAULT_VALUE_KEY = "DefaultValue";
    private static final String SECTION_KEY = "Section";
    private static final String CONFIGURABLE_KEY = "Configurable";
    private static final String HIDDEN_KEY = "Hidden";
    private static final String NO_HEADING_SECTION = "NoHeading";
    private static final boolean DEFAULT_CONFIGURABLE = true;
    private static final boolean DEFAULT_HIDDEN = false;
    private static final String DEFAULT_DESCRIPTION = null;
    private static final String DEFAULT_DEFAULT_STRING = null;
    private static final int DEFAULT_PRIORITY_INDEX = Integer.MAX_VALUE;
    private PropertyInfo fDefaultProfilePropertyInfo;
    private List<PropertyInfo> fProfilePropertyInfoList;
    private List<PropertyInfo> fProjectComponentPropertyInfoList;
    private Map<String, List<PropertyInfo>> fSchedulerComponentPropertyInfoListMap;
    private static PropertyInfoProvider sInstance;

    public static PropertyInfoProvider getInstance() {
        if (sInstance == null) {
            sInstance = new PropertyInfoProvider();
        }
        return sInstance;
    }

    private PropertyInfoProvider() {
        Node node = XmlParser.openXMLFile(this.getClass().getResourceAsStream(FILENAME));
        this.updateProfilePropertyInfoList(node);
        this.updateProjectPropertyInfoList(node);
        this.updateSchedulerPropertyInfoMap(node);
        this.fDefaultProfilePropertyInfo = new PropertyInfo("DefaultProfile", "", new Constraint(Constraint.PCTConstraint.NONEMPTYSTRING, null), "", "", -1, true, true);
    }

    public List<PropertyInfo> getProjectPropertyInfoList() {
        return Collections.unmodifiableList(this.fProjectComponentPropertyInfoList);
    }

    public List<PropertyInfo> getSchedulerPropertyInfoList(String string) {
        return this.fSchedulerComponentPropertyInfoListMap.get(string);
    }

    public List<PropertyInfo> getProfilePropertyInfoList() {
        return Collections.unmodifiableList(this.fProfilePropertyInfoList);
    }

    public List<String> getSchedulerTypes() {
        return Arrays.asList(this.fSchedulerComponentPropertyInfoListMap.keySet().toArray(new String[this.fSchedulerComponentPropertyInfoListMap.keySet().size()]));
    }

    public PropertyInfo getDefaultProfilePropertyInfo() {
        return this.fDefaultProfilePropertyInfo;
    }

    private void updateProfilePropertyInfoList(Node node) {
        try {
            Node node2 = XmlParser.getFirstChildWithNodes(node, PROFILE_NODE);
            this.fProfilePropertyInfoList = PropertyInfoProvider.createComponentPropertiesListAtNode(node2, PROFILE_NODE);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to update the profile info list.", throwable);
        }
    }

    private void updateProjectPropertyInfoList(Node node) {
        try {
            Node node2 = XmlParser.getFirstChildWithNodes(node, PROJECT_COMPONENT_NODE);
            this.fProjectComponentPropertyInfoList = PropertyInfoProvider.createComponentPropertiesListAtNode(node2, PROJECT_COMPONENT_NODE);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to update the project component info list.", throwable);
        }
    }

    private void updateSchedulerPropertyInfoMap(Node node) {
        this.fSchedulerComponentPropertyInfoListMap = new HashMap<String, List<PropertyInfo>>();
        try {
            Node node2 = XmlParser.getFirstChildWithNodes(node, SCHEDULER_COMPONENTS_NODE);
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (!node3.getNodeName().equals(SCHEDULER_COMPONENT_NODE)) continue;
                String string = XmlParser.getValue(node3, SCHEDULER_TYPE_NODE);
                List<PropertyInfo> list = PropertyInfoProvider.createComponentPropertiesListAtNode(node3, string);
                this.fSchedulerComponentPropertyInfoListMap.put(string, list);
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to update the scheduler component info list.", throwable);
        }
    }

    private static List<PropertyInfo> createComponentPropertiesListAtNode(Node node, String string) {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        Node node2 = XmlParser.getFirstChildWithNodes(node, PROPERTIES_NODE);
        NodeList nodeList = node2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals(PROPERTY_NODE)) continue;
            String string2 = XmlParser.getValue(node3, NAME_NODE);
            String string3 = string + "." + string2;
            String string4 = PropertyInfoProvider.readDescriptionKey(string3);
            String string5 = PropertyInfoProvider.readDefaultStringKey(string3);
            Constraint constraint = PropertyInfoProvider.getConstraint(node3);
            int n = PropertyInfoProvider.readPriorityIndexKey(string3);
            String string6 = PropertyInfoProvider.readSectionKey(string3);
            boolean bl = PropertyInfoProvider.readConfigurableKey(string3);
            boolean bl2 = PropertyInfoProvider.readHiddenKey(string3);
            PropertyInfo propertyInfo = new PropertyInfo(string2, string4, constraint, string5, string6, n, bl, bl2);
            arrayList.add(propertyInfo);
        }
        return arrayList;
    }

    private static boolean readHiddenKey(String string) {
        String string2 = string + "." + HIDDEN_KEY;
        boolean bl = sRes_NoTranslation.containsKey(string2) ? Boolean.parseBoolean(sRes_NoTranslation.getString(string2)) : false;
        return bl;
    }

    private static boolean readConfigurableKey(String string) {
        String string2 = string + "." + CONFIGURABLE_KEY;
        boolean bl = sRes_NoTranslation.containsKey(string2) ? Boolean.parseBoolean(sRes_NoTranslation.getString(string2)) : true;
        return bl;
    }

    private static String readSectionKey(String string) {
        String string2 = string + "." + SECTION_KEY;
        String string3 = sRes_NoTranslation.containsKey(string2) ? sRes_NoTranslation.getString(string2) : NO_HEADING_SECTION;
        return string3;
    }

    private static int readPriorityIndexKey(String string) {
        String string2 = string + "." + PRIORITY_INDEX_KEY;
        int n = sRes_NoTranslation.containsKey(string2) ? Integer.parseInt(sRes_NoTranslation.getString(string2)) : Integer.MAX_VALUE;
        return n;
    }

    private static Constraint getConstraint(Node node) {
        Constraint constraint;
        String string = XmlParser.getValue(node, CONSTRAINT_NODE);
        Constraint.PCTConstraint pCTConstraint = Constraint.PCTConstraint.valueOf(string.toUpperCase());
        if (pCTConstraint.equals((Object)Constraint.PCTConstraint.ENUM)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = XmlParser.getNodes(node, ENUM_VALUE_NODE);
            for (Node node2 : list) {
                arrayList.add(node2.getChildNodes().item(0).getNodeValue());
            }
            constraint = new Constraint(pCTConstraint, arrayList);
        } else {
            constraint = new Constraint(pCTConstraint, null);
        }
        return constraint;
    }

    private static String readDefaultStringKey(String string) {
        String string2 = string + "." + DEFAULT_VALUE_KEY;
        String string3 = sRes_NoTranslation.containsKey(string2) ? sRes_NoTranslation.getString(string2) : DEFAULT_DEFAULT_STRING;
        return string3;
    }

    private static String readDescriptionKey(String string) {
        String string2 = string + "." + DESCRIPTION_KEY;
        String string3 = sRes.containsKey(string2) ? sRes.getString(string2) : DEFAULT_DESCRIPTION;
        return string3;
    }

    private static class XmlParser {
        private XmlParser() {
        }

        private static Node openXMLFile(InputStream inputStream) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            try {
                Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
                return document.getFirstChild();
            }
            catch (SAXException sAXException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to open the xml file.", sAXException);
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to open the xml file.", iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to open the xml file.", parserConfigurationException);
            }
            return null;
        }

        private static String getValue(Node node, String string) {
            String string2 = "";
            Node node2 = XmlParser.getFirstChildWithNodes(node, string);
            if (node2 != null) {
                string2 = ((NodeList)((Object)node2)).item(0).getNodeValue();
            }
            return string2;
        }

        private static Node getFirstChildWithNodes(Node node, String string) {
            try {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    NodeList nodeList2 = node2.getChildNodes();
                    if (nodeList2.getLength() <= 0 || !node2.getNodeName().equals(string)) continue;
                    return node2;
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }

        private static List<Node> getNodes(Node node, String string) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(string)) continue;
                arrayList.add(node2);
            }
            return arrayList;
        }
    }
}

