/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.PrintStream;

public final class ErrorPrinterImpl
implements ErrorPrinter {
    private static final boolean STACKTRACE = true;
    private static final boolean NOSTACKTRACE = false;
    private final PrintStream fOutStream;

    public ErrorPrinterImpl() {
        this.fOutStream = System.err;
    }

    public ErrorPrinterImpl(PrintStream printStream) {
        this.fOutStream = printStream;
    }

    @Override
    public void printError(String string, Exception exception) {
        this.fOutStream.println(string);
        this.printError(exception);
    }

    @Override
    public void printError(Throwable throwable) {
        if (throwable instanceof DistcompDiagnosticException) {
            this.printThrowable(throwable, false);
        } else {
            this.printThrowable(throwable, true);
        }
    }

    @Override
    public void printThrowable(Throwable throwable, boolean bl) {
        String string = "";
        if (bl) {
            throwable.printStackTrace();
            string = string + throwable.getClass().getName() + ": ";
        }
        string = string + throwable.getMessage();
        String string2 = bl ? this.getCauseMessage(throwable.getCause()) : this.getReverseCauseMessage(throwable.getCause(), true);
        this.printError(string, string2);
    }

    @Override
    public void printError(String string, String string2) {
        this.fOutStream.println(string + "\n");
        if (string2 != null) {
            String string3 = "   ";
            string2 = string2.replaceAll("\n", "\n" + string3);
            string2 = string2.replaceFirst("^", string3);
            this.fOutStream.println(ErrorPrinterMessageCode.ErrorCauseTemplate.createLocalizedMessage(string2));
        }
    }

    public String getReverseCauseMessage(Throwable throwable, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        while (throwable != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, "\n");
            }
            String string = bl ? throwable.getLocalizedMessage() : throwable.getMessage();
            stringBuilder.insert(0, string);
            if ((throwable = throwable.getCause()) == null) continue;
            String string2 = bl ? ErrorPrinterMessageCode.ReverseCauseMessage.createLocalizedMessage(new Object[0]) : ErrorPrinterMessageCode.ReverseCauseMessage.createMessage(new Object[0]);
            stringBuilder.insert(0, string2);
        }
        return stringBuilder.toString();
    }

    private String getCauseMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        while (throwable != null) {
            stringBuilder.append(throwable.getClass().getName()).append(": ");
            stringBuilder.append(throwable.getLocalizedMessage());
            if ((throwable = throwable.getCause()) == null) continue;
            stringBuilder.append(ErrorPrinterMessageCode.CausedByMessage.createLocalizedMessage(new Object[0]));
        }
        return stringBuilder.toString();
    }

    private static enum ErrorPrinterMessageCode implements I18nMatlabIdentifiedMessageCreator
    {
        ErrorCauseTemplate,
        ReverseCauseMessage,
        CausedByMessage;

        private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.toolbox.distcomp.util.resources.RES_util";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "parallel.cluster.jobmanager.";
        private static final String MATLAB_ERROR_ID_PREFIX = "parallel:cluster:jobmanager:";

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, false, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, false, objectArray);
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BUNDLE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.name();
        }

        public String getMessageID() {
            return MATLAB_ERROR_ID_PREFIX + this.name();
        }
    }
}

