/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LimitedQueueExecutor
implements ExecutorService {
    private final ExecutorService fExecutor;
    private final Semaphore fExecutePermission;

    public LimitedQueueExecutor(ExecutorService executorService, int n) {
        assert (executorService != null) : "Executor must not be null.";
        assert (n > 0) : "Max number of pending/running must be > 0.";
        this.fExecutor = executorService;
        this.fExecutePermission = new Semaphore(n, true);
    }

    @Override
    public void execute(final Runnable runnable) throws RejectedExecutionException {
        assert (runnable != null) : "Runnables should not be null.";
        this.fExecutePermission.acquireUninterruptibly();
        try {
            this.fExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        LimitedQueueExecutor.this.fExecutePermission.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fExecutePermission.release();
            throw rejectedExecutionException;
        }
    }

    @Override
    public void shutdown() {
        this.fExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.fExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.fExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.fExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fExecutor.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

