/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.util.PackageInfo;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import com.mathworks.util.PlatformInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class Ping {
    private static final int GLOBAL_MAXIMUM_CONCURRENT_REQUESTS = 64;
    private static final int WINDOWS_MAXIMUM_CONCURRENT_REQUESTS = 32;
    private static final int WINDOWS_MAXIMUM_CONCURRENT_TCP_REQUESTS = 8;
    private static final int JAVA_PINGER_TIMEOUT_MILLIS = 5000;
    private static final int WINDOWS_PINGER_TIMEOUT_MILLIS = 2000;
    private static Pinger sPinger = Ping.getJavaPinger();

    private Ping() {
    }

    public static int getNumberOfMaximumConcurrentRequests() {
        if (PlatformInfo.isWindows()) {
            try {
                Pinger pinger = Ping.getWindowsPinger();
                pinger.ping("127.0.0.1");
                sPinger = pinger;
                return 32;
            }
            catch (Exception exception) {
                return 8;
            }
        }
        return 64;
    }

    public static void checkIfHostIsResolvable(String string) throws UnknownHostException {
        InetAddress.getByName(string);
    }

    public static void checkIfHostIsPingable(String string) throws AddressUnreachableException, IOException {
        if (!sPinger.ping(string)) {
            throw new AddressUnreachableException(string);
        }
    }

    private static Pinger getJavaPinger() {
        return new Pinger(){

            @Override
            public boolean ping(String string) throws IOException {
                InetAddress inetAddress = InetAddress.getByName(string);
                return inetAddress.isReachable(5000);
            }
        };
    }

    private static Pinger getWindowsPinger() {
        return new Pinger(){
            private static final int MAXIMUM_OUTPUT_SIZE = 8192;

            @Override
            public boolean ping(String string) throws IOException {
                ProcessBuilder processBuilder = new ProcessBuilder("ping", "-n", "1", "-w", "2000", string);
                processBuilder.redirectErrorStream(true);
                final Process process = processBuilder.start();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream(), 8192);
                Callable<Integer> callable = new Callable<Integer>(){

                    @Override
                    public Integer call() throws InterruptedException {
                        return process.waitFor();
                    }
                };
                Future<Integer> future = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " Windows Pinger-"), (Logger)PackageInfo.LOGGER)).submit(callable);
                try {
                    int n = future.get(4000L, TimeUnit.MILLISECONDS);
                    boolean bl = n == 0;
                    return bl;
                }
                catch (Exception exception) {
                    throw (IOException)new IOException().initCause(exception);
                }
                finally {
                    bufferedInputStream.close();
                    process.destroy();
                }
            }
        };
    }

    private static interface Pinger {
        public boolean ping(String var1) throws IOException;
    }

    public static class AddressUnreachableException
    extends Exception
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        private AddressUnreachableException(String string) {
            this.fMessageID = new mjs.UnreachableHostname(string);
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

