/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.jobmanager.RegistrationAuthority;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.logging.TaskHandler;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedJobManagerClient;
import com.mathworks.toolbox.distcomp.nativedmatlab.NativeMethods;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.service.DistcompServiceImpl;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.service.PersistentServiceConfiguration;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.distcomp.util.PersistenceDirServiceStarterException;
import com.mathworks.toolbox.distcomp.util.ProxyCreationException;
import com.mathworks.toolbox.distcomp.util.ServiceExportException;
import com.mathworks.toolbox.distcomp.util.ServiceStarterException;
import com.mathworks.toolbox.distcomp.util.zip.FileZipEntryWriter;
import com.mathworks.toolbox.distcomp.worker.InvalidCredentialsException;
import com.mathworks.toolbox.distcomp.worker.MatlabFailedToStartException;
import com.mathworks.toolbox.distcomp.worker.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.PersistentWorkerConfiguration;
import com.mathworks.toolbox.distcomp.worker.RegistrationInfo;
import com.mathworks.toolbox.distcomp.worker.RegistrationMaintainer;
import com.mathworks.toolbox.distcomp.worker.TaskEvaluator;
import com.mathworks.toolbox.distcomp.worker.TaskExecutionException;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNotReadyException;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.worker.WorkerRemote;
import com.mathworks.toolbox.distcomp.worker.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleReporter;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleTracker;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.TaskTrackable;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.WorkerTrackable;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.toolbox.distcomp.workunit.JobMLType;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.TaskAttemptIdentifier;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.Predicate;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateCondition;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateNotTrueException;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.id.Uuid;
import org.apache.commons.io.FileUtils;

public class WorkerImpl
extends DistcompServiceImpl
implements WorkerRemote {
    private static final String WORKERCONFIG = "com.mathworks.toolbox.distcomp.mlworker";
    private WorkerProxy fWorkerProxy;
    private RegistrationMaintainer fRegistrationMaintainer;
    private AtomicBoolean fOkayToCancelRunningTask = new AtomicBoolean(false);
    private AtomicBoolean fHasTaskErrored = new AtomicBoolean(false);
    private boolean fParallelJobWasExecuted = false;
    private TaskHandler fTaskHandler;
    private TaskEvaluator fTaskEvaluator;
    private AtomicReference<RegistrationInfo> fRegistrationInfo = new AtomicReference();
    private Pair<JobAndTaskIdentifier, String> fParallelPortInfo;
    private LifecycleTracker fLifecycleTracker;
    private final ReentrantLock fParallelPortInfoLock = new ReentrantLock();
    private List<Condition> fWaiters = new ArrayList<Condition>();

    public WorkerImpl(ActivationID activationID, MarshalledObject marshalledObject) throws DistcompException {
        super(activationID, marshalledObject, WORKERCONFIG);
        try {
            this.exportDistcompService();
        }
        catch (NetworkConfigException | ServiceExportException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        try {
            this.initWorker();
        }
        catch (PersistenceDirException persistenceDirException) {
            throw new DistcompException(new PersistenceDirServiceStarterException(persistenceDirException));
        }
        catch (ProxyCreationException proxyCreationException) {
            throw new DistcompException(proxyCreationException);
        }
        try {
            this.registerWithLookupServices(this.fWorkerProxy);
        }
        catch (ServiceStarterException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        this.initRegistrationMaintainer();
        this.initLifespanTracker();
        this.fLifecycleTracker.workerStarted(this.getTrackableForWorker());
        this.printWorkerStartupMessage();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Started Worker");
    }

    public WorkerImpl(ActivationID activationID, MarshalledObject marshalledObject, JobManagerProxy jobManagerProxy) throws DistcompException {
        super(activationID, marshalledObject, WORKERCONFIG);
        try {
            this.exportDistcompService();
        }
        catch (NetworkConfigException | ServiceExportException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        try {
            this.getPersistentConfiguration().setJobManagerProxy(jobManagerProxy);
            this.initWorker();
        }
        catch (PersistenceDirException persistenceDirException) {
            throw new DistcompException(new PersistenceDirServiceStarterException((BaseMsgID)new mjs.WorkerCannotSaveInfo(persistenceDirException.getPersistenceDir()), (Throwable)persistenceDirException));
        }
        catch (ProxyCreationException proxyCreationException) {
            throw new DistcompException(proxyCreationException);
        }
        try {
            this.registerWithLookupServices(this.fWorkerProxy);
        }
        catch (ServiceStarterException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        this.initRegistrationMaintainer();
        this.initLifespanTracker();
        this.fLifecycleTracker.workerStarted(this.getTrackableForWorker());
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Started Worker");
    }

    private void initLifespanTracker() {
        LifecycleReporter lifecycleReporter = this.getPersistentConfiguration().getLifecycleReporter();
        long l = this.getPersistentConfiguration().getWorkerLifecycleHeartBeatSeconds();
        long l2 = this.getPersistentConfiguration().getTaskLifecycleHeartBeatSeconds();
        this.fLifecycleTracker = new LifecycleTracker(lifecycleReporter, l, l2);
    }

    @Override
    public void prepareForShutdown() {
        try {
            this.terminateRegistrationMaintainer();
            JobManagerProxy jobManagerProxy = this.getJobManagerProxy();
            if (jobManagerProxy != null) {
                jobManagerProxy.removeWorker(this.getID());
            }
            this.fTaskEvaluator.dispose();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Worker dispose errored.", throwable);
        }
        this.fLifecycleTracker.workerStopped(this.getTrackableForWorker());
    }

    @Override
    public synchronized void executeTask(JobAndTaskIdentifier jobAndTaskIdentifier, int n, boolean bl, int n2, UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws TaskExecutionException {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Received task to execute");
        if (this.fTaskEvaluator.canEvaluateTask()) {
            try {
                this.fRegistrationMaintainer.pauseRegistration();
                this.executeTaskInMATLAB(this.fTaskEvaluator, jobAndTaskIdentifier, n, bl, n2, userIdentity, credentialProviderLocal);
            }
            catch (InvalidCredentialsException invalidCredentialsException) {
                this.cancelTaskLocally(jobAndTaskIdentifier);
                throw invalidCredentialsException;
            }
            catch (TaskExecutionException taskExecutionException) {
                WorkerImpl.printWorkerError(taskExecutionException);
                this.cancelTaskLocally(jobAndTaskIdentifier);
                throw taskExecutionException;
            }
            catch (Throwable throwable) {
                WorkerImpl.printWorkerError(throwable);
                this.cancelTaskLocally(jobAndTaskIdentifier);
                throw new TaskExecutionException(throwable);
            }
            finally {
                this.fRegistrationMaintainer.resumeRegistrationIfPaused();
            }
        } else {
            throw new WorkerNotReadyException();
        }
    }

    private boolean isCurrentRunningTaskAttempt(TaskAttemptIdentifier taskAttemptIdentifier) {
        JobAndTaskIdentifier jobAndTaskIdentifier = this.getCurrentJobAndTask();
        TaskAttemptIdentifier taskAttemptIdentifier2 = jobAndTaskIdentifier.getTaskAttemptIdentifier();
        return taskAttemptIdentifier.equals(taskAttemptIdentifier2);
    }

    @Override
    public synchronized void cancelRunningTask(TaskAttemptIdentifier taskAttemptIdentifier) throws DistcompException {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Received new cancellation message from job manager");
        if (this.isCurrentRunningTaskAttempt(taskAttemptIdentifier) && this.checkAndSetOkayToCancelRunningTask(false)) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Cancelling running task (matching task attempts)");
            this.cancelTaskLocally(this.getCurrentJobAndTask());
        } else {
            this.fRegistrationMaintainer.resumeRegistration();
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Ignoring cancelRunningTask request because task attempt doesn't match,  isOkayToCancelTaskOrSubmitResult()=" + this.isOkayToCancelTaskOrSubmitResult());
        }
    }

    private boolean isOkayToCancelTaskOrSubmitResult() {
        return this.fOkayToCancelRunningTask.get();
    }

    private boolean checkAndSetOkayToCancelRunningTask(boolean bl) {
        return this.fOkayToCancelRunningTask.getAndSet(bl);
    }

    @Override
    public JobAndTaskIdentifier getCurrentJobAndTask() {
        return this.getPersistentConfiguration().getCurrentJobAndTask();
    }

    @Override
    public JobAndTaskIdentifier getLastJobAndTask() {
        return this.getPersistentConfiguration().getLastJobAndTask();
    }

    @Override
    public JobManager getJobManager() {
        return this.getJobManagerProxy();
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public DistcompServiceInfo getServiceInfo() {
        JobAndTaskIdentifier[] jobAndTaskIdentifierArray = this.getPersistentConfiguration().getCurrentAndLastJobsAndTasks();
        JobAndTaskIdentifier jobAndTaskIdentifier = jobAndTaskIdentifierArray[0];
        JobAndTaskIdentifier jobAndTaskIdentifier2 = jobAndTaskIdentifierArray[1];
        return new WorkerServiceInfo(jobAndTaskIdentifier, jobAndTaskIdentifier2, 0);
    }

    @Override
    public NodeInfo getNodeInfo() {
        JobManagerProxy jobManagerProxy = this.getJobManagerProxy();
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (jobManagerProxy != null) {
            string = jobManagerProxy.getName();
            string2 = jobManagerProxy.getHostName();
            bl = jobManagerProxy.testCommunication();
        }
        String string3 = this.getPersistentConfiguration().getJobManagerName();
        String string4 = this.getPersistentConfiguration().getJobManagerHostName();
        String string5 = this.getFileDependencyDir();
        String string6 = this.getWorkerDir();
        JobAndTaskIdentifier jobAndTaskIdentifier = this.getCurrentJobAndTask();
        boolean bl2 = jobAndTaskIdentifier.areValid();
        WorkerNodeInfo workerNodeInfo = new WorkerNodeInfo(string, string2, string3, string4, string5, string6, bl2, bl, this.fRegistrationInfo.get());
        this.setDistcompServiceNodeInfo(workerNodeInfo);
        return workerNodeInfo;
    }

    @Override
    public DistcompService getDistcompProxy() {
        return this.fWorkerProxy;
    }

    private WorkerProxy getWorkerProxy() {
        return this.fWorkerProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParallelPortInfo(JobAndTaskIdentifier jobAndTaskIdentifier, String string) {
        assert (string != null) : "String must not be null";
        if (jobAndTaskIdentifier == null || !jobAndTaskIdentifier.equals(this.getCurrentJobAndTask())) {
            throw new IllegalStateException("You cannot set the parallel port info if the job and task info does not match the current info");
        }
        this.fParallelPortInfoLock.lock();
        try {
            this.fParallelPortInfo = new Pair<JobAndTaskIdentifier, String>(jobAndTaskIdentifier, string);
            for (Condition condition : this.fWaiters) {
                try {
                    condition.signalAll();
                }
                catch (PredicateNotTrueException predicateNotTrueException) {}
            }
        }
        finally {
            this.fParallelPortInfoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParallelPortInfo() {
        this.fParallelPortInfoLock.lock();
        try {
            String string = this.fParallelPortInfo.getSecond();
            return string;
        }
        finally {
            this.fParallelPortInfoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String waitforParallelPortInfo(final JobAndTaskIdentifier jobAndTaskIdentifier, long l, TimeUnit timeUnit) {
        assert (jobAndTaskIdentifier != null && jobAndTaskIdentifier.areValid()) : "Input other cannot be null and must be valid";
        this.fParallelPortInfoLock.lock();
        try {
            String string;
            Predicate predicate = new Predicate(){

                public boolean test() {
                    return WorkerImpl.this.fParallelPortInfo != null && jobAndTaskIdentifier.isSameTaskAttempt((JobAndTaskIdentifier)WorkerImpl.this.fParallelPortInfo.getFirst());
                }
            };
            PredicateCondition predicateCondition = this.fParallelPortInfoLock.newPredicateCondition(predicate);
            this.fWaiters.add((Condition)predicateCondition);
            try {
                string = predicateCondition.await(l, timeUnit) ? this.fParallelPortInfo.getSecond() : null;
                this.fWaiters.remove(predicateCondition);
            }
            catch (InterruptedException interruptedException) {
                String string2 = null;
                this.fWaiters.remove(predicateCondition);
                this.fParallelPortInfoLock.unlock();
                return string2;
                {
                    catch (Throwable throwable) {
                        this.fWaiters.remove(predicateCondition);
                        throw throwable;
                    }
                }
            }
            return string;
        }
        finally {
            this.fParallelPortInfoLock.unlock();
        }
    }

    @Override
    public WorkerProperties getWorkerProperties() {
        return new WorkerProperties(this.getID(), this.getHostName(), this.getComputerMLType(), this.getName(), this.getAllHostAddresses());
    }

    @Override
    public synchronized boolean okayToSubmitResult() {
        return this.isOkayToCancelTaskOrSubmitResult();
    }

    @Override
    public void notifyFunctionEvaluationComplete() {
        this.fOkayToCancelRunningTask.set(false);
    }

    @Override
    public synchronized void makeJavaWorkerIdle(JobAndTaskIdentifier jobAndTaskIdentifier) throws PersistenceDirException {
        this.taskFinished(jobAndTaskIdentifier);
        this.fTaskEvaluator.taskFinished();
    }

    @Override
    public void notifyTaskErrored(final JobAndTaskIdentifier jobAndTaskIdentifier, final String string) {
        if (this.fHasTaskErrored.getAndSet(true)) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Call to notifyTaskErrored ignored as it has already been called for this task. Message: " + string);
            return;
        }
        NamedThreadFactory namedThreadFactory = NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " executor-"), (Logger)PackageInfo.LOGGER);
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)namedThreadFactory);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                WorkerImpl.this.doNotifyTaskErrored(jobAndTaskIdentifier, string);
            }
        });
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyTaskErrored(JobAndTaskIdentifier jobAndTaskIdentifier, String string) {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Worker has been notified of a error during task evaluation.");
        AuthenticationToken authenticationToken = this.getPersistentConfiguration().getCurrentTaskAuthenticationToken();
        try {
            if (this.isOkayToCancelTaskOrSubmitResult()) {
                this.cancelTaskViaJobManager(jobAndTaskIdentifier, string, authenticationToken);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Not cancelling task - task has already been cancelled or a result has been submitted. Original cancel message: " + string);
                this.cancelTaskLocally(jobAndTaskIdentifier);
            }
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to cancel task (" + workUnitNotFoundException.getMessage() + ")");
            this.cancelTaskLocally(jobAndTaskIdentifier);
        }
        catch (MJSException | RemoteException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to cancel task", exception);
            this.cancelTaskLocally(jobAndTaskIdentifier);
        }
        finally {
            authenticationToken.erase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTaskViaJobManager(JobAndTaskIdentifier jobAndTaskIdentifier, String string, AuthenticationToken authenticationToken) throws MJSException, RemoteException {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Cancelling task because an error occurred during task evaluation.");
        SingleUserCredentialStore<AuthenticationToken> singleUserCredentialStore = new SingleUserCredentialStore<AuthenticationToken>(authenticationToken);
        ProxiedJobManagerClient proxiedJobManagerClient = new ProxiedJobManagerClient(this.getJobManagerProxy(), CredentialConsumerFactory.TRIVIAL_FACTORY, singleUserCredentialStore);
        try {
            proxiedJobManagerClient.setCurrentUser(authenticationToken.getUserIdentity());
            ClientTaskAccess clientTaskAccess = proxiedJobManagerClient.getTaskAccess();
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Worker is attempting to cancel task " + jobAndTaskIdentifier.getTaskID() + " because '" + string + "'");
            clientTaskAccess.rerunOrCancel(new Uuid[]{jobAndTaskIdentifier.getTaskID()}, new String[]{string});
        }
        finally {
            proxiedJobManagerClient.dispose();
        }
    }

    private synchronized void cancelTaskLocally(JobAndTaskIdentifier jobAndTaskIdentifier) {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Doing local task cancellation");
        try {
            this.taskFinished(jobAndTaskIdentifier);
        }
        catch (PersistenceDirException persistenceDirException) {
            // empty catch block
        }
        this.fTaskEvaluator.cancelTask();
    }

    @Override
    public void startMatlabRunning() throws MatlabFailedToStartException {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Received startMatlabRunning request");
        this.fTaskEvaluator.startMatlab();
    }

    @Override
    public boolean hasRunningMatlab() {
        boolean bl = this.fTaskEvaluator.hasRunningMatlab();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Received hasRunningMatlab request. Returning " + bl);
        return bl;
    }

    @Override
    public String getFileDependencyDir() {
        return this.getPersistentConfiguration().getFileDependencyDir().getPath();
    }

    @Override
    public String getWorkerDir() {
        return this.getPersistentConfiguration().getWorkerDir().getPath();
    }

    @Override
    protected PersistentServiceConfiguration createServiceConfiguration(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        return new PersistentWorkerConfiguration(configuration, string);
    }

    @Override
    protected String serviceTypeForPrinting() {
        return "worker";
    }

    private JobManagerProxy getJobManagerProxy() {
        return this.getPersistentConfiguration().getJobManagerProxy();
    }

    private synchronized void initWorker() throws DistcompException, PersistenceDirException, ProxyCreationException {
        this.createDirectoriesForWorker();
        this.createWorkerProxy();
        this.initTaskHandler();
        this.fTaskEvaluator = this.createTaskEvaluator();
        this.fTaskEvaluator.addCanEvaluateTaskChangedListener(new TaskEvaluator.CanEvaluateTaskChangedListener(){

            @Override
            public void statusChanged(boolean bl) {
                WorkerImpl.this.fRegistrationMaintainer.resumeRegistration();
            }
        });
        assert (this.fTaskEvaluator.canEvaluateTask()) : "TaskEvaluator should be ready after construction";
    }

    private TaskEvaluator createTaskEvaluator() throws PersistenceDirException, DistcompException {
        PersistentWorkerConfiguration persistentWorkerConfiguration = this.getPersistentConfiguration();
        try {
            Class<?> clazz = Class.forName(persistentWorkerConfiguration.getTaskEvaluator());
            Class<TaskEvaluator> clazz2 = clazz.asSubclass(TaskEvaluator.class);
            Constructor<TaskEvaluator> constructor = clazz2.getConstructor(this.getClass(), persistentWorkerConfiguration.getClass());
            return constructor.newInstance(this, persistentWorkerConfiguration);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DistcompException(invocationTargetException.getCause());
        }
        catch (Throwable throwable) {
            throw new TaskEvaluatorInstantationError(throwable);
        }
    }

    private boolean isSameJobAsLastJob(JobAndTaskIdentifier jobAndTaskIdentifier) {
        Uuid uuid = jobAndTaskIdentifier.getJobID();
        JobAndTaskIdentifier jobAndTaskIdentifier2 = this.getLastJobAndTask();
        Uuid uuid2 = jobAndTaskIdentifier2.getJobID();
        return uuid.equals((Object)uuid2);
    }

    private synchronized void finishPreviousTask() throws PersistenceDirException {
        JobAndTaskIdentifier jobAndTaskIdentifier = this.getCurrentJobAndTask();
        this.taskFinished(jobAndTaskIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeTaskInMATLAB(TaskEvaluator taskEvaluator, JobAndTaskIdentifier jobAndTaskIdentifier, int n, boolean bl, int n2, UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws TaskExecutionException {
        UserCredentials userCredentials;
        try {
            this.finishPreviousTask();
        }
        catch (PersistenceDirException persistenceDirException) {
            throw new TaskExecutionException(persistenceDirException);
        }
        boolean bl2 = this.isSameJobAsLastJob(jobAndTaskIdentifier);
        this.fParallelPortInfo = null;
        this.fTaskHandler.setTaskIDAndLevel(jobAndTaskIdentifier.getTaskID(), n2);
        this.fOkayToCancelRunningTask.set(true);
        boolean bl3 = !bl2 && bl || this.isMacSecondParallelJob(n);
        this.checkFirstParallelJob(n);
        boolean bl4 = !bl2;
        try {
            userCredentials = (UserCredentials)credentialProviderLocal.getCredentials(userIdentity, this.getTransferCryptoModule());
        }
        catch (NoCredentialsException noCredentialsException) {
            throw new TaskExecutionException((BaseMsgID)new mjs.NoCredentialsForUser(userIdentity.toString()), (Throwable)noCredentialsException);
        }
        catch (CredentialTransferException credentialTransferException) {
            throw new TaskExecutionException((BaseMsgID)new mjs.CouldNotRetrieveCredentials(userIdentity.toString()), (Throwable)credentialTransferException);
        }
        this.checkCredentialsAreValid(userCredentials);
        AuthenticationToken authenticationToken = (AuthenticationToken)userCredentials.getCredentialsForRole(CredentialRole.AUTH_TOKEN);
        this.taskStarted(jobAndTaskIdentifier, authenticationToken);
        try {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Calling MATLAB to execute task");
            taskEvaluator.evaluateTask(this.getJobManagerProxy(), this.fWorkerProxy, jobAndTaskIdentifier, n, bl4, bl3, n2, userCredentials);
        }
        finally {
            userCredentials.erase();
        }
    }

    private void checkCredentialsAreValid(UserCredentials userCredentials) throws InvalidCredentialsException {
        if (SecurityModuleProvider.isRunAsUser(this.getSecurityLevel())) {
            if (!userCredentials.hasCredentialsForRole(CredentialRole.PASSWORD)) {
                throw new InvalidCredentialsException((BaseMsgID)new mjs.RunAsUserError(userCredentials.getUserIdentity().toString(), (long)this.getSecurityLevel()));
            }
        } else if (!userCredentials.hasCredentialsForRole(CredentialRole.AUTH_TOKEN) || userCredentials.hasCredentialsForRole(CredentialRole.PASSWORD)) {
            throw new InvalidCredentialsException((BaseMsgID)new mjs.OnlyAuthenticationToken(userCredentials.getUserIdentity().toString()));
        }
        if (this.getPersistentConfiguration().requireWebLicensing() && !userCredentials.hasCredentialsForRole(CredentialRole.WEB_LICENSE_INFO)) {
            throw new InvalidCredentialsException((BaseMsgID)new mjs.WebLicensingRequired(userCredentials.getUserIdentity().toString()));
        }
    }

    private boolean isMacSecondParallelJob(int n) {
        return PlatformInfo.isMacintosh() && JobMLType.isParallelType(n) && this.fParallelJobWasExecuted;
    }

    private void checkFirstParallelJob(int n) {
        if (!this.fParallelJobWasExecuted) {
            this.fParallelJobWasExecuted = JobMLType.isParallelType(n);
        }
    }

    private void createDirectoriesForWorker() {
        File file = this.getPersistentConfiguration().getTaskRootDirectory();
        if (!file.isDirectory()) {
            file.mkdir();
        }
    }

    private void createWorkerProxy() throws ProxyCreationException {
        try {
            this.fWorkerProxy = new WorkerProxy((Worker)this.getStub(), this.getID(), this.getAllHostAddresses(), this.getHostName(), this.getName(), this.getMatlabRoot(), this.getSecurityLevel(), this.getComputerMLType());
        }
        catch (DistcompProxy.SerializeProxyException serializeProxyException) {
            throw new ProxyCreationException((BaseMsgID)new mjs.UnableToSerializeWorkerProxy(), (Throwable)serializeProxyException);
        }
        catch (IOException iOException) {
            throw new ProxyCreationException((BaseMsgID)new mjs.UnableToCreateWorkerProxy(), (Throwable)iOException);
        }
    }

    private void initRegistrationMaintainer() throws DistcompException {
        JobManagerProxy jobManagerProxy = this.getJobManagerProxy();
        String string = this.getPersistentConfiguration().getJobManagerName();
        long l = this.getPersistentConfiguration().getLookupServiceQueryIntervalMillis();
        LookupLocator[] lookupLocatorArray = this.fServiceConfig.getLookupLocators();
        RegistrationMaintainer.JobManagerProxySaver jobManagerProxySaver = new RegistrationMaintainer.JobManagerProxySaver(){

            @Override
            public boolean saveJobManagerProxy(JobManagerProxy jobManagerProxy) {
                if (!jobManagerProxy.testCommunication()) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Worker failed to communicate with job manager during registration");
                    return false;
                }
                try {
                    jobManagerProxy.testCommunicationWithWorker(WorkerImpl.this.fWorkerProxy);
                }
                catch (RemoteException remoteException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Job manager failed to communicate with worker during registration", remoteException);
                    return false;
                }
                try {
                    WorkerImpl.this.getPersistentConfiguration().setJobManagerProxy(jobManagerProxy);
                }
                catch (PersistenceDirException persistenceDirException) {
                    // empty catch block
                }
                try {
                    WorkerImpl.this.fTaskHandler.setTaskAccess(jobManagerProxy.getTaskAccess());
                }
                catch (MJSException | RemoteException exception) {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Failed to update TaskHandler's TaskAccess", exception);
                }
                return true;
            }
        };
        RegistrationMaintainer.WorkerRegistrant workerRegistrant = new RegistrationMaintainer.WorkerRegistrant(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public long register(WorkerRegistration workerRegistration) throws RemoteException {
                RegistrationAuthority.RegistrationFailedException registrationFailedException;
                boolean bl;
                WorkerProxy workerProxy;
                block7: {
                    workerProxy = WorkerImpl.this.getWorkerProxy();
                    bl = true;
                    registrationFailedException = null;
                    if (!WorkerImpl.this.shouldRegisterAsIdle()) break block7;
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Registering with job manager as idle");
                    long l = workerRegistration.registerAsIdle(workerProxy);
                    WorkerImpl.this.fRegistrationInfo.set(new RegistrationInfo(bl, registrationFailedException));
                    return l;
                }
                try {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Registering with job manager as busy");
                    JobAndTaskIdentifier jobAndTaskIdentifier = WorkerImpl.this.getCurrentJobAndTask();
                    long l = workerRegistration.registerAsBusy(new WorkerTaskInfo(workerProxy, jobAndTaskIdentifier));
                    WorkerImpl.this.fRegistrationInfo.set(new RegistrationInfo(bl, registrationFailedException));
                    return l;
                }
                catch (RegistrationAuthority.FatalRegistrationFailedException fatalRegistrationFailedException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Registration failed: " + fatalRegistrationFailedException.getMessage());
                    bl = false;
                    registrationFailedException = fatalRegistrationFailedException;
                    long l = Long.MAX_VALUE;
                    WorkerImpl.this.fRegistrationInfo.set(new RegistrationInfo(bl, registrationFailedException));
                    return l;
                }
                catch (RegistrationAuthority.RegistrationFailedException registrationFailedException2) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Registration failed: " + registrationFailedException2.getMessage());
                    bl = false;
                    registrationFailedException = registrationFailedException2;
                    long l = 0L;
                    WorkerImpl.this.fRegistrationInfo.set(new RegistrationInfo(bl, registrationFailedException));
                    return l;
                    {
                        catch (Throwable throwable) {
                            WorkerImpl.this.fRegistrationInfo.set(new RegistrationInfo(bl, registrationFailedException));
                            throw throwable;
                        }
                    }
                }
            }
        };
        this.fRegistrationMaintainer = new RegistrationMaintainer(workerRegistrant, jobManagerProxySaver, string, l, lookupLocatorArray, jobManagerProxy);
        this.fRegistrationMaintainer.start();
    }

    private boolean shouldRegisterAsIdle() {
        JobAndTaskIdentifier jobAndTaskIdentifier = this.getCurrentJobAndTask();
        return this.fTaskEvaluator.canEvaluateTask() && (jobAndTaskIdentifier == null || !jobAndTaskIdentifier.areValid());
    }

    private static void printWorkerError(Throwable throwable) {
        if (throwable instanceof PersistenceDirException) {
            new ErrorPrinterImpl().printError("This worker was restarted because it could not save information to the directory:\n\t" + ((PersistenceDirException)throwable).getPersistenceDir() + "\nThe worker will be restarted because it cannot run tasks without accessing the directory.", (Exception)throwable);
        } else {
            new ErrorPrinterImpl().printError(throwable);
        }
    }

    private synchronized void terminateRegistrationMaintainer() {
        this.fRegistrationMaintainer.terminate();
    }

    private void taskStarted(JobAndTaskIdentifier jobAndTaskIdentifier, AuthenticationToken authenticationToken) {
        assert (authenticationToken != null) : "UserCredentials must contain credentials with CredentialRole.AUTH_TOKEN";
        this.fHasTaskErrored.set(false);
        this.getPersistentConfiguration().setCurrentTaskInformation(jobAndTaskIdentifier, authenticationToken);
        this.fLifecycleTracker.taskStarted(this.getTrackableForCurrentTask());
        this.fRegistrationMaintainer.resumeRegistration();
    }

    private synchronized void taskFinished(JobAndTaskIdentifier jobAndTaskIdentifier) throws PersistenceDirException {
        JobAndTaskIdentifier jobAndTaskIdentifier2 = this.getCurrentJobAndTask();
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "ENTERING WorkerImpl:taskFinished finishedJobAndTask=" + jobAndTaskIdentifier + ", currentJobAndTask=" + jobAndTaskIdentifier2);
        if (jobAndTaskIdentifier.areValid() && jobAndTaskIdentifier.getTaskID().equals((Object)jobAndTaskIdentifier2.getTaskID())) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "WorkerImpl:taskFinished(" + jobAndTaskIdentifier + ")");
            this.fLifecycleTracker.taskStopped(this.getTrackableForCurrentTask());
            this.fTaskHandler.flush();
            this.fTaskHandler.clearTaskIDAndLevel();
            try {
                JobAndTaskIdentifier jobAndTaskIdentifier3 = jobAndTaskIdentifier2;
                JobAndTaskIdentifier jobAndTaskIdentifier4 = new JobAndTaskIdentifier();
                AuthenticationToken authenticationToken = null;
                this.getPersistentConfiguration().setCurrentAndLastTaskInformation(jobAndTaskIdentifier4, authenticationToken, jobAndTaskIdentifier3);
            }
            catch (PersistenceDirException persistenceDirException) {
                WorkerImpl.printWorkerError(persistenceDirException);
                throw persistenceDirException;
            }
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "WorkerImpl:taskFinished - task IDs do not match.");
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "EXITING WorkerImpl:taskFinished finishedJobAndTask=" + jobAndTaskIdentifier + ", currentJobAndTask=" + jobAndTaskIdentifier2);
    }

    private void printWorkerStartupMessage() {
        String string = new Date() + " Worker started: " + this.getName() + '\n';
        NativeMethods nativeMethods = new NativeMethods();
        nativeMethods.printOutput(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getLogs(OutputStream outputStream) throws IOException {
        Collection<File> collection = this.listLogs();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            for (File file : collection) {
                FileZipEntryWriter fileZipEntryWriter = new FileZipEntryWriter(file);
                fileZipEntryWriter.writeEntry(zipOutputStream);
            }
        }
        finally {
            zipOutputStream.finish();
            zipOutputStream.flush();
        }
    }

    private void initTaskHandler() {
        JobManagerProxy jobManagerProxy = this.getJobManagerProxy();
        TaskAccessLocal taskAccessLocal = null;
        if (jobManagerProxy != null) {
            try {
                taskAccessLocal = jobManagerProxy.getTaskAccess();
            }
            catch (MJSException | RemoteException exception) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Failed to get TaskAccess for TaskHandler.", exception);
            }
        }
        this.fTaskHandler = new TaskHandler(taskAccessLocal);
        Logger logger = PackageInfo.LOGGER.getParent();
        logger.addHandler(this.fTaskHandler);
    }

    private WorkerTrackable getTrackableForWorker() {
        UUID uUID = WorkerImpl.convertToUUID(this.getID());
        WorkerTrackable workerTrackable = new WorkerTrackable(uUID);
        workerTrackable.getProperties().put("Name", this.getName());
        workerTrackable.getProperties().put("HostName", this.getHostName());
        workerTrackable.getProperties().put("SchedulerType", "MATHWORKS_JOBMANAGER");
        return workerTrackable;
    }

    private TaskTrackable getTrackableForCurrentTask() {
        UUID uUID = WorkerImpl.convertToUUID(this.getCurrentJobAndTask().getTaskID());
        TaskTrackable taskTrackable = new TaskTrackable(uUID);
        String string = this.getPersistentConfiguration().getCurrentTaskUserIdentity().getSimpleUsername();
        taskTrackable.getProperties().put("UserName", string);
        return taskTrackable;
    }

    private static UUID convertToUUID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private PersistentWorkerConfiguration getPersistentConfiguration() {
        return (PersistentWorkerConfiguration)this.fServiceConfig;
    }

    @Override
    public void destroyForUnitTests() throws Exception {
        this.terminateRegistrationMaintainer();
        try {
            this.fRegistrationMaintainer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fTaskHandler != null) {
            this.fTaskHandler.close();
            Logger logger = PackageInfo.LOGGER.getParent();
            logger.removeHandler(this.fTaskHandler);
        }
        super.destroyForUnitTests();
        this.fServiceConfig.destroy();
        WorkerImpl.destroyDirectoryForUnitTests(this.getPersistentConfiguration().getTaskRootDirectory());
    }

    private static void destroyDirectoryForUnitTests(File file) {
        if (file.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class TaskEvaluatorInstantationError
    extends Error {
        TaskEvaluatorInstantationError(Throwable throwable) {
            super("Failed to instantiate TaskEvaluator", throwable);
        }
    }
}

