/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.worker.Worker;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class WorkerSortStrategy
extends Enum<WorkerSortStrategy> {
    public static final /* enum */ WorkerSortStrategy NO_SORT = new WorkerSortStrategy(new WorkerSorter(){

        @Override
        public void sort(Worker[] workerArray) {
        }
    });
    public static final /* enum */ WorkerSortStrategy BY_HOSTNAME = new WorkerSortStrategy(new WorkerSorter(){

        @Override
        public void sort(Worker[] workerArray) {
            Arrays.sort(workerArray, new HostnameComparator());
        }
    });
    public static final /* enum */ WorkerSortStrategy FEWEST_MACHINES = new WorkerSortStrategy(new WorkerSorter(){

        @Override
        public void sort(Worker[] workerArray) {
            Arrays.sort(workerArray, new FewestMachinesComparator(workerArray));
        }
    });
    private WorkerSorter fWorkerSorter;
    private static final /* synthetic */ WorkerSortStrategy[] $VALUES;

    public static WorkerSortStrategy[] values() {
        return (WorkerSortStrategy[])$VALUES.clone();
    }

    public static WorkerSortStrategy valueOf(String string) {
        return Enum.valueOf(WorkerSortStrategy.class, string);
    }

    private WorkerSortStrategy(WorkerSorter workerSorter) {
        this.fWorkerSorter = workerSorter;
    }

    public void sort(Worker[] workerArray) {
        this.fWorkerSorter.sort(workerArray);
    }

    private static String getHostName(Worker worker) {
        try {
            return worker == null ? "" : worker.getHostName();
        }
        catch (RemoteException remoteException) {
            assert (false);
            return null;
        }
    }

    private static String getName(Worker worker) {
        try {
            return worker == null ? "" : worker.getName();
        }
        catch (RemoteException remoteException) {
            assert (false);
            return null;
        }
    }

    static {
        $VALUES = new WorkerSortStrategy[]{NO_SORT, BY_HOSTNAME, FEWEST_MACHINES};
    }

    private static class FewestMachinesComparator
    extends HostnameComparator {
        private Map<String, Integer> fHostCountMap = new HashMap<String, Integer>();

        private FewestMachinesComparator(Worker[] workerArray) {
            for (Worker worker : workerArray) {
                String string;
                Integer n = this.fHostCountMap.get(string = WorkerSortStrategy.getHostName(worker));
                this.fHostCountMap.put(string, n == null ? 1 : n + 1);
            }
        }

        @Override
        public int compare(Worker worker, Worker worker2) {
            int n = this.fHostCountMap.get(WorkerSortStrategy.getHostName(worker2)).compareTo(this.fHostCountMap.get(WorkerSortStrategy.getHostName(worker)));
            if (n == 0) {
                return super.compare(worker, worker2);
            }
            return n;
        }
    }

    private static class HostnameComparator
    implements Comparator<Worker>,
    Serializable {
        private HostnameComparator() {
        }

        @Override
        public int compare(Worker worker, Worker worker2) {
            int n = String.CASE_INSENSITIVE_ORDER.compare(WorkerSortStrategy.getHostName(worker), WorkerSortStrategy.getHostName(worker2));
            if (n == 0) {
                n = String.CASE_INSENSITIVE_ORDER.compare(WorkerSortStrategy.getName(worker), WorkerSortStrategy.getName(worker2));
            }
            return n;
        }
    }

    private static interface WorkerSorter {
        public void sort(Worker[] var1);
    }
}

