/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.wsclients;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.webservices;
import com.mathworks.toolbox.distcomp.wsclients.ClientErrorException;
import com.mathworks.toolbox.distcomp.wsclients.Log;
import com.mathworks.toolbox.distcomp.wsclients.ServiceErrorPassThroughException;
import com.mathworks.toolbox.distcomp.wsclients.WSAuthenticationFailureException;
import com.mathworks.toolbox.distcomp.wsclients.WSClusterNotFoundException;
import com.mathworks.toolbox.distcomp.wsclients.WSProxyAuthenticationRequiredException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceNotFoundException;
import com.mathworks.toolbox.distcomp.wsclients.WSServiceUnavailableException;
import com.mathworks.toolbox.distcomp.wsclients.WSUnknownHostException;
import com.mathworks.toolbox.distcomp.wsclients.WebServiceException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.clients.cloudcenter.ClusterNotFoundException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;

public class WebServiceInvoker<V> {
    public V invokeAndHandleException(Callable<V> callable) throws WebServiceException {
        try {
            return callable.call();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            WSServiceNotFoundException wSServiceNotFoundException = new WSServiceNotFoundException(serviceNotFoundException);
            Log.LOGGER.log(DistcompLevel.ONE, "Web service call failed because the web service could not be found.", serviceNotFoundException);
            throw wSServiceNotFoundException;
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            WSServiceUnavailableException wSServiceUnavailableException = new WSServiceUnavailableException(serviceUnavailableException);
            Log.LOGGER.log(DistcompLevel.ONE, "Web service call failed because the web service was unavailable", serviceUnavailableException);
            throw wSServiceUnavailableException;
        }
        catch (ProxyAuthenticationRequiredException proxyAuthenticationRequiredException) {
            WSProxyAuthenticationRequiredException wSProxyAuthenticationRequiredException = new WSProxyAuthenticationRequiredException(proxyAuthenticationRequiredException);
            Log.LOGGER.log(DistcompLevel.ONE, "Web service call failed because of a proxy authentication failure", proxyAuthenticationRequiredException);
            throw wSProxyAuthenticationRequiredException;
        }
        catch (ClusterNotFoundException clusterNotFoundException) {
            WSClusterNotFoundException wSClusterNotFoundException = new WSClusterNotFoundException(clusterNotFoundException);
            Log.LOGGER.log(DistcompLevel.ONE, "Cluster not found", clusterNotFoundException);
            throw wSClusterNotFoundException;
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            int n = mathWorksServiceException.getStatusCode();
            if (n == 401) {
                WSAuthenticationFailureException wSAuthenticationFailureException = new WSAuthenticationFailureException(mathWorksServiceException);
                String string = String.format("Web service call failed due to an authentication failure.Status code %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
                Log.LOGGER.log(DistcompLevel.TWO, string, mathWorksServiceException);
                throw wSAuthenticationFailureException;
            }
            ServiceErrorPassThroughException serviceErrorPassThroughException = new ServiceErrorPassThroughException(mathWorksServiceException);
            String string = String.format("Web service call failed. Status code: %d, Error code: %s", mathWorksServiceException.getStatusCode(), mathWorksServiceException.getErrorCode());
            Log.LOGGER.log(DistcompLevel.ONE, string, mathWorksServiceException);
            throw serviceErrorPassThroughException;
        }
        catch (MathWorksClientException mathWorksClientException) {
            if (mathWorksClientException.getCause() instanceof UnknownHostException) {
                UnknownHostException unknownHostException = (UnknownHostException)mathWorksClientException.getCause();
                WSUnknownHostException wSUnknownHostException = new WSUnknownHostException((Throwable)mathWorksClientException, unknownHostException.getMessage());
                Log.LOGGER.log(DistcompLevel.ONE, "Unable to connect to MathWorks web services.", mathWorksClientException);
                throw wSUnknownHostException;
            }
            ClientErrorException clientErrorException = new ClientErrorException(mathWorksClientException);
            Log.LOGGER.log(DistcompLevel.ONE, "Web service call failed due to a client error.", mathWorksClientException);
            throw clientErrorException;
        }
        catch (Exception exception) {
            Log.LOGGER.log(DistcompLevel.ONE, "An unexpected exception occurred during a web service call.", exception);
            throw new WSUnexpectedException(exception);
        }
    }

    private static final class WSUnexpectedException
    extends WebServiceException {
        private final Exception fCause;

        WSUnexpectedException(Exception exception) {
            super(exception);
            this.fCause = exception;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new webservices.UnexpectedException(this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new webservices.UnexpectedException(this.fCause.getLocalizedMessage());
        }
    }
}

