/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellPainterProvider;
import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.DefaultListCellViewerCustomizer;
import com.mathworks.mwswing.DefaultTableCellViewerCustomizer;
import com.mathworks.mwswing.DefaultTreeCellViewerCustomizer;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.TableCell;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;

public final class CellViewerUtils {
    private CellViewerUtils() {
    }

    public static Context installCellViewer(JTable jTable) {
        return CellViewerUtils.installCellViewer(jTable, jTable instanceof CellViewerCustomizer ? (CellViewerCustomizer)((Object)jTable) : new DefaultTableCellViewerCustomizer(jTable));
    }

    public static Context installCellViewer(JTable jTable, CellViewerCustomizer<TableCell> cellViewerCustomizer) {
        if (cellViewerCustomizer == null) {
            throw new IllegalArgumentException("customizer must not be null");
        }
        return new TableContext(jTable, cellViewerCustomizer);
    }

    public static Context installCellViewer(JList jList) {
        return CellViewerUtils.installCellViewer(jList, (CellViewerCustomizer<Integer>)(jList instanceof CellViewerCustomizer ? (CellViewerCustomizer)((Object)jList) : new DefaultListCellViewerCustomizer(jList)));
    }

    public static Context installCellViewer(JList jList, CellViewerCustomizer<Integer> cellViewerCustomizer) {
        if (cellViewerCustomizer == null) {
            throw new IllegalArgumentException("customizer must not be null");
        }
        return new ListContext(jList, cellViewerCustomizer);
    }

    public static Context installCellViewer(JTree jTree) {
        return CellViewerUtils.installCellViewer(jTree, (CellViewerCustomizer<Integer>)(jTree instanceof CellViewerCustomizer ? (CellViewerCustomizer)((Object)jTree) : new DefaultTreeCellViewerCustomizer(jTree)));
    }

    public static Context installCellViewer(JTree jTree, CellViewerCustomizer<Integer> cellViewerCustomizer) {
        if (cellViewerCustomizer == null) {
            throw new IllegalArgumentException("customizer must not be null");
        }
        return new TreeContext(jTree, cellViewerCustomizer);
    }

    private static class TreeContext
    extends AbstractContext<Integer> {
        private final JTree fTree;
        private final TreeModelListener fModelListener;
        private final PropertyChangeListener fModelChangeListener;

        TreeContext(JTree jTree, CellViewerCustomizer<Integer> cellViewerCustomizer) {
            super(jTree, cellViewerCustomizer);
            this.fTree = jTree;
            this.fModelListener = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    TreeContext.this.hideViewer();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    TreeContext.this.hideViewer();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    TreeContext.this.hideViewer();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    TreeContext.this.hideViewer();
                }
            };
            this.fModelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TreeModel treeModel = (TreeModel)propertyChangeEvent.getOldValue();
                    TreeModel treeModel2 = (TreeModel)propertyChangeEvent.getNewValue();
                    if (treeModel != null) {
                        treeModel.removeTreeModelListener(TreeContext.this.fModelListener);
                    }
                    if (treeModel2 != null) {
                        treeModel2.addTreeModelListener(TreeContext.this.fModelListener);
                    }
                }
            };
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TreeContext.this.fTree.getModel().addTreeModelListener(TreeContext.this.fModelListener);
                    TreeContext.this.fTree.addPropertyChangeListener("model", TreeContext.this.fModelChangeListener);
                }
            });
        }

        @Override
        protected Integer getCellAtPoint(Point point) {
            int n = this.fTree.getRowForLocation((int)point.getX(), (int)point.getY());
            return n == -1 ? null : Integer.valueOf(n);
        }

        @Override
        protected Rectangle getCellRect(Integer n) {
            return this.fTree.getRowBounds(n);
        }

        @Override
        public void uninstall() {
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TreeContext.super.uninstall();
                    TreeContext.this.fTree.getModel().removeTreeModelListener(TreeContext.this.fModelListener);
                    TreeContext.this.fTree.removePropertyChangeListener(TreeContext.this.fModelChangeListener);
                }
            });
        }
    }

    private static class ListContext
    extends AbstractContext<Integer> {
        private final JList fList;
        private final ListDataListener fDataListener;
        private final PropertyChangeListener fModelChangeListener;

        ListContext(JList jList, CellViewerCustomizer<Integer> cellViewerCustomizer) {
            super(jList, cellViewerCustomizer);
            this.fList = jList;
            this.fDataListener = new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    ListContext.this.hideViewer();
                }

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    ListContext.this.hideViewer();
                }

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                    ListContext.this.hideViewer();
                }
            };
            this.fModelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                    ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                    if (listModel != null) {
                        listModel.removeListDataListener(ListContext.this.fDataListener);
                    }
                    if (listModel2 != null) {
                        listModel2.addListDataListener(ListContext.this.fDataListener);
                    }
                }
            };
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ListContext.this.fList.getModel().addListDataListener(ListContext.this.fDataListener);
                    ListContext.this.fList.addPropertyChangeListener("model", ListContext.this.fModelChangeListener);
                }
            });
        }

        @Override
        public void uninstall() {
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ListContext.super.uninstall();
                    ListContext.this.fList.getModel().removeListDataListener(ListContext.this.fDataListener);
                    ListContext.this.fList.removePropertyChangeListener(ListContext.this.fModelChangeListener);
                }
            });
        }

        @Override
        protected Integer getCellAtPoint(Point point) {
            int n = this.fList.locationToIndex(point);
            return n > -1 ? Integer.valueOf(n) : null;
        }

        @Override
        protected Rectangle getCellRect(Integer n) {
            return this.fList.getCellBounds(n, n);
        }
    }

    private static class TableContext
    extends AbstractContext<TableCell> {
        private final JTable fTable;
        private final TableModelListener fModelListener;
        private final PropertyChangeListener fModelChangeListener;

        TableContext(JTable jTable, CellViewerCustomizer cellViewerCustomizer) {
            super(jTable, cellViewerCustomizer);
            this.fTable = jTable;
            this.fModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    TableContext.this.hideViewer();
                }
            };
            this.fModelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TableModel tableModel = (TableModel)propertyChangeEvent.getOldValue();
                    TableModel tableModel2 = (TableModel)propertyChangeEvent.getNewValue();
                    if (tableModel != null) {
                        tableModel.removeTableModelListener(TableContext.this.fModelListener);
                    }
                    if (tableModel2 != null) {
                        tableModel2.addTableModelListener(TableContext.this.fModelListener);
                    }
                }
            };
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TableContext.this.fTable.addPropertyChangeListener("model", TableContext.this.fModelChangeListener);
                    TableContext.this.fTable.getModel().addTableModelListener(TableContext.this.fModelListener);
                }
            });
        }

        @Override
        public void uninstall() {
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TableContext.super.uninstall();
                    TableContext.this.fTable.getModel().removeTableModelListener(TableContext.this.fModelListener);
                    TableContext.this.fTable.removePropertyChangeListener(TableContext.this.fModelChangeListener);
                }
            });
        }

        @Override
        public TableCell getCellAtPoint(Point point) {
            int n = this.fTable.rowAtPoint(point);
            int n2 = this.fTable.columnAtPoint(point);
            return n == -1 || n2 == -1 ? null : new TableCell(n, n2);
        }

        @Override
        public Rectangle getCellRect(TableCell tableCell) {
            return this.fTable.getCellRect(tableCell.getRow(), tableCell.getColumn(), false);
        }
    }

    private static abstract class AbstractContext<T>
    extends MouseInputAdapter
    implements Context {
        private final CellViewer fCellViewer;
        private final JComponent fHostComponent;
        private final CellViewerCustomizer<T> fCustomizer;
        private final CellPainterProvider fProvider;
        private T fCurrentCell;
        private Point fLastMousePoint;

        AbstractContext(JComponent jComponent, CellViewerCustomizer<T> cellViewerCustomizer) {
            this.fHostComponent = jComponent;
            this.fCustomizer = cellViewerCustomizer;
            this.fCellViewer = CellViewer.getInstance();
            this.fProvider = new CellPainterProvider(){

                @Override
                public Component getCellPainter() {
                    return AbstractContext.this.fCurrentCell == null ? null : AbstractContext.this.fCustomizer.getCellPainter(AbstractContext.this.fCurrentCell);
                }
            };
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    AbstractContext.this.fHostComponent.addMouseListener(AbstractContext.this);
                    AbstractContext.this.fHostComponent.addMouseMotionListener(AbstractContext.this);
                }
            });
        }

        protected abstract T getCellAtPoint(Point var1);

        protected abstract Rectangle getCellRect(T var1);

        protected void hideViewer() {
            if (this.fCellViewer.isShowPending(this.fHostComponent)) {
                this.fCellViewer.cancelShow();
            } else if (this.fCellViewer.isShowing(this.fHostComponent)) {
                this.fCellViewer.hide();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.fCellViewer.isShowPending()) {
                this.fCellViewer.cancelShow();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.fCellViewer.wasRecentlyShown(this.fHostComponent)) {
                this.fCurrentCell = null;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.fCellViewer.isShowPending()) {
                this.fCellViewer.cancelShow();
            }
            if (this.fCellViewer.isShowing(this.fHostComponent)) {
                this.fCellViewer.mouseExitedClient(mouseEvent);
            } else {
                this.fCurrentCell = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            T t = this.getCellAtPoint(point);
            if (t == null ^ this.fCurrentCell == null || t != null && !t.equals(this.fCurrentCell)) {
                if (this.fCellViewer.isShowPending()) {
                    this.fCellViewer.cancelShow();
                }
                if (t == null) {
                    if (this.fCellViewer.isShowing(this.fHostComponent)) {
                        this.fCellViewer.hide();
                    }
                } else if (this.fCustomizer.shouldShowCellViewer(t)) {
                    int n;
                    Component component = this.fCustomizer.getCellPainter(t);
                    Dimension dimension = component.getPreferredSize();
                    Rectangle rectangle = this.getCellRect(t);
                    Dimension dimension2 = this.fCustomizer.getCellViewerOffset(t);
                    int n2 = n = component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 2;
                    if (this.fCustomizer.constrainViewerToCellHeight()) {
                        dimension.height = rectangle.height;
                    }
                    this.fLastMousePoint = point;
                    this.fCellViewer.show(this.fHostComponent, this.fProvider, dimension, rectangle, n, dimension2, point);
                } else if (this.fCellViewer.isShowing(this.fHostComponent)) {
                    this.fCellViewer.hide();
                }
                this.fCurrentCell = t;
            } else if (this.fLastMousePoint != null) {
                this.fLastMousePoint.setLocation(point.x, point.y);
            }
        }

        @Override
        public void uninstall() {
            MJUtilities.runOnEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    AbstractContext.this.hideViewer();
                    AbstractContext.this.fHostComponent.removeMouseListener(AbstractContext.this);
                    AbstractContext.this.fHostComponent.removeMouseMotionListener(AbstractContext.this);
                }
            });
        }

        @Override
        public MouseEvent adjustMouseEvent(MouseEvent mouseEvent) {
            if (this.fCellViewer.wasJustClicked(this.fHostComponent) && (mouseEvent.getID() == 501 || mouseEvent.getID() == 502 || mouseEvent.getID() == 500)) {
                return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount() + 1, mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            return mouseEvent;
        }
    }

    public static interface Context {
        public MouseEvent adjustMouseEvent(MouseEvent var1);

        public void uninstall();
    }
}

