/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJComponent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class GlobalCursor {
    private final Window fWindow;
    private final Cursor fCursor;
    private final List<? extends Component> fLiveComponents;
    private boolean fHasHeavyweight;
    private Component fSavedGlassPane;
    private boolean fGlassWasVisible;
    private AWTEventListener fMouseBlocker;
    private List<Component> fModifiedComponents;
    private List<Cursor> fSavedCursors;
    private static Hashtable<Window, GlobalCursor> sWindowToCursorMap = new Hashtable();

    public static void set(Window window, Cursor cursor) {
        GlobalCursor.set(window, cursor, false, null);
    }

    public static void setWait(Window window) {
        GlobalCursor.setWait(window, true);
    }

    public static void setWait(Window window, boolean bl) {
        GlobalCursor.set(window, Cursor.getPredefinedCursor(3), bl, null);
    }

    public static void setWait(Window window, List<? extends Component> list) {
        GlobalCursor.set(window, Cursor.getPredefinedCursor(3), true, list);
    }

    public static Cursor get(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        GlobalCursor globalCursor = sWindowToCursorMap.get(window);
        return globalCursor == null ? null : globalCursor.fCursor;
    }

    public static void clear(final Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlobalCursor.clear(window);
                }
            });
            return;
        }
        GlobalCursor globalCursor = sWindowToCursorMap.remove(window);
        if (globalCursor != null) {
            globalCursor.cleanup();
        }
    }

    private static void set(final Window window, final Cursor cursor, final boolean bl, final List<? extends Component> list) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlobalCursor.set(window, cursor, bl, list);
                }
            });
            return;
        }
        GlobalCursor globalCursor = sWindowToCursorMap.get(window);
        if (globalCursor != null) {
            globalCursor.cleanup();
        }
        if (cursor != null) {
            globalCursor = new GlobalCursor(window, cursor, bl, list);
            sWindowToCursorMap.put(window, globalCursor);
        }
        if (cursor == Cursor.getPredefinedCursor(3)) {
            window.invalidate();
            window.validate();
        }
    }

    private GlobalCursor(Window window, Cursor cursor, boolean bl, List<? extends Component> list) {
        this.fWindow = window;
        this.fCursor = cursor;
        this.fLiveComponents = list;
        this.fHasHeavyweight = ComponentUtils.hasAnyHeavyweights(window);
        if (this.useGlass()) {
            this.recursivelySetCursors(((RootPaneContainer)((Object)window)).getRootPane(), false);
        } else {
            this.recursivelySetCursors(window, false);
        }
        if (this.useGlass()) {
            this.fSavedGlassPane = ((RootPaneContainer)((Object)window)).getGlassPane();
            this.fGlassWasVisible = this.fSavedGlassPane != null && this.fSavedGlassPane.isVisible();
            GlassPane glassPane = new GlassPane(cursor);
            GlobalCursor.setGlassPane(window, glassPane);
            glassPane.setVisible(true);
        }
        if (bl) {
            this.fMouseBlocker = new MouseBlocker();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fMouseBlocker, 48L);
        }
    }

    private void cleanup() {
        this.restoreCursors();
        if (this.fMouseBlocker != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fMouseBlocker);
        }
        if (this.useGlass()) {
            GlobalCursor.setGlassPane(this.fWindow, this.fSavedGlassPane);
            this.fSavedGlassPane.setVisible(this.fGlassWasVisible);
        }
    }

    private void recursivelySetCursors(Component component, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = !component.isLightweight();
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component2 = container.getComponent(i);
                if (this.fLiveComponents != null && this.fLiveComponents.contains(component2)) continue;
                this.recursivelySetCursors(component2, bl3 || bl);
            }
        }
        boolean bl5 = bl2 = bl3 || bl || !this.useGlass() && component.isCursorSet();
        if (bl2) {
            if (this.fModifiedComponents == null) {
                this.fModifiedComponents = new ArrayList<Component>();
                this.fSavedCursors = new ArrayList<Cursor>();
            }
            this.fModifiedComponents.add(component);
            this.fSavedCursors.add(component.isCursorSet() ? component.getCursor() : null);
            component.setCursor(this.fCursor);
        }
    }

    private void restoreCursors() {
        if (this.fModifiedComponents != null) {
            for (int i = 0; i < this.fModifiedComponents.size(); ++i) {
                Component component = this.fModifiedComponents.get(i);
                Cursor cursor = this.fSavedCursors.get(i);
                component.setCursor(cursor);
            }
        }
    }

    private static boolean supportsGlass(Window window) {
        return window instanceof RootPaneContainer;
    }

    private boolean useGlass() {
        return !this.fHasHeavyweight && GlobalCursor.supportsGlass(this.fWindow) && this.fLiveComponents == null;
    }

    private static void setGlassPane(Window window, Component component) {
        ((RootPaneContainer)((Object)window)).setGlassPane(component);
    }

    class MouseBlocker
    implements AWTEventListener {
        MouseBlocker() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            Component component;
            if (aWTEvent instanceof MouseEvent && SwingUtilities.isDescendingFrom(component = (mouseEvent = (MouseEvent)aWTEvent).getComponent(), GlobalCursor.this.fWindow)) {
                if (GlobalCursor.this.fLiveComponents != null) {
                    for (Component component2 : GlobalCursor.this.fLiveComponents) {
                        if (component != component2 && !SwingUtilities.isDescendingFrom(component, component2)) continue;
                        return;
                    }
                }
                mouseEvent.consume();
            }
        }
    }

    private class GlassPane
    extends MJComponent {
        GlassPane(Cursor cursor) {
            this.setOpaque(false);
            this.setCursor(cursor);
        }
    }
}

