/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.SelectAllOnFocusListener;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.util.PlatformInfo;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.Format;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class MJFormattedTextField
extends JFormattedTextField
implements KeyBindingManagerRegistrant {
    private ContextMenuListener fContextListener;
    private DocumentListener fDocumentSafetyListener;
    private SelectAllOnFocusListener fSelectAllOnFocusListener;

    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public MJFormattedTextField() {
        this.initialize();
    }

    public MJFormattedTextField(Object object) {
        super(object);
        this.initialize();
    }

    public MJFormattedTextField(Format format) {
        super(format);
        this.initialize();
    }

    public MJFormattedTextField(JFormattedTextField.AbstractFormatter abstractFormatter) {
        super(abstractFormatter);
        this.initialize();
    }

    public MJFormattedTextField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        super(abstractFormatterFactory);
        this.initialize();
    }

    public MJFormattedTextField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, Object object) {
        super(abstractFormatterFactory, object);
        this.initialize();
    }

    public void enableEnterTriggersDefaultButton() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    for (Container container = MJFormattedTextField.this.getParent(); container != null; container = container.getParent()) {
                        JRootPane jRootPane;
                        JButton jButton;
                        if (!(container instanceof JRootPane) || (jButton = (jRootPane = (JRootPane)container).getDefaultButton()) == null) continue;
                        jButton.doClick();
                        return;
                    }
                }
            }
        });
    }

    private void initialize() {
        this.registerWithKeyBindingManager(DefaultKeyBindings.getManager(), "DefaultContext");
        this.addSafetyListeners();
        this.addFocusSelectionListener();
        if (!PlatformInfo.isMacintosh()) {
            this.addFocusListener(MJTextField.APPEARANCE_FOCUS_DISPATCHER);
        }
        this.enableEnterTriggersDefaultButton();
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(this, keyBindingManager, string);
        this.addContextMenu(new TextContextMenu(keyBindingManager, string));
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.fSelectAllOnFocusListener.setEnabled(bl);
    }

    private void addFocusSelectionListener() {
        this.fSelectAllOnFocusListener = new SelectAllOnFocusListener(this, SelectAllOnFocusListener.SelectAllBehavior.KEYBOARD);
    }

    public void addContextMenu(JPopupMenu jPopupMenu) {
        if (this.fContextListener != null) {
            if (jPopupMenu == null) {
                this.removeContextMenu();
            } else {
                this.fContextListener.setMenu(jPopupMenu);
            }
        } else if (jPopupMenu != null) {
            this.fContextListener = new ContextMenuListener(jPopupMenu);
            this.addMouseListener(this.fContextListener);
        }
    }

    public void removeContextMenu() {
        if (this.fContextListener != null) {
            this.removeMouseListener(this.fContextListener);
            this.fContextListener = null;
        }
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setDocument(Document document) {
        if (this.fDocumentSafetyListener != null) {
            Document document2 = this.getDocument();
            document2.removeDocumentListener(this.fDocumentSafetyListener);
            document.addDocumentListener(this.fDocumentSafetyListener);
        }
        super.setDocument(document);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getKeyChar() != '\u007f') {
            if (this.getCaretPosition() > this.getText().trim().length() && this.getSelectedText() == null) {
                this.setCaretPosition(this.getText().trim().length());
            }
        } else if (keyEvent.getKeyChar() == '\u007f' && this.getText().trim().length() == 0) {
            this.setCaretPosition(0);
        }
    }

    private class ContextMenuListener
    extends PopupListener {
        private JPopupMenu fMenu;

        private ContextMenuListener(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        public void setMenu(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (MJFormattedTextField.this.getCaretPosition() > MJFormattedTextField.this.getText().trim().length()) {
                MJFormattedTextField.this.setCaretPosition(MJFormattedTextField.this.getText().trim().length());
            }
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            MJFormattedTextField.this.requestFocus();
            this.fMenu.show(MJFormattedTextField.this, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

