/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ContrastingIcon;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;

public class MJScrollStrip
extends MJComponent {
    protected int fOrientation;
    protected boolean fScrollOnMouseOver;
    protected MJScrollPane fScrollPane;
    protected MJToggleButton fAheadButton;
    protected MJToggleButton fBackButton;
    protected boolean fViewFits = true;
    protected ResizeListener fResizeListener = new ResizeListener();
    private static Icon sPointNorthIcon = new ContrastingIcon(MJScrollStrip.class.getResource("resources/whitepointnorth.gif"), MJScrollStrip.class.getResource("resources/pointnorth.gif"));
    private static Icon sPointSouthIcon = new ContrastingIcon(MJScrollStrip.class.getResource("resources/whitepointsouth.gif"), MJScrollStrip.class.getResource("resources/pointsouth.gif"));
    private static Icon sPointEastIcon = new ContrastingIcon(MJScrollStrip.class.getResource("resources/whitepointeast.gif"), MJScrollStrip.class.getResource("resources/pointeast.gif"));
    private static Icon sPointWestIcon = new ContrastingIcon(MJScrollStrip.class.getResource("resources/whitepointwest.gif"), MJScrollStrip.class.getResource("resources/pointwest.gif"));
    private static final Insets MINIMAL_INSETS = new Insets(1, 1, 1, 1);
    private static final int SCROLL_START_DELAY = 150;
    private static final int SCROLL_REPEAT_INTERVAL = 30;
    private static final int SLOW_SCROLL_INCREMENT = 3;
    private static final int FAST_SCROLL_INCREMENT = 6;

    public MJScrollStrip(int n) {
        this(n, null, false);
    }

    public MJScrollStrip(int n, Component component) {
        this(n, component, false);
    }

    public MJScrollStrip(int n, Component component, boolean bl) {
        this.fOrientation = n;
        this.fScrollOnMouseOver = bl;
        this.setLayout(new BorderLayout());
        this.fScrollPane = new MJScrollPane(component, 21, 31);
        this.fScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.fScrollPane, "Center");
        this.addComponentListener(this.fResizeListener);
        this.addHierarchyListener(this.fResizeListener);
        if (component != null) {
            component.addComponentListener(this.fResizeListener);
            this.accommodateView();
        }
    }

    public void setViewportView(Component component) {
        JViewport jViewport = this.fScrollPane.getViewport();
        Component component2 = jViewport.getView();
        if (component != component2) {
            jViewport.setView(component);
            if (component2 != null) {
                component2.removeComponentListener(this.fResizeListener);
            }
            if (component != null) {
                component.addComponentListener(this.fResizeListener);
            }
            this.accommodateView();
        }
    }

    public void refreshView() {
        this.accommodateView();
    }

    public JViewport getViewport() {
        return this.fScrollPane.getViewport();
    }

    public Rectangle getViewRect() {
        return this.fScrollPane.getViewport().getViewRect();
    }

    public void setViewPosition(Point point) {
        this.fScrollPane.getViewport().setViewPosition(point);
        this.updateButtonVisibility();
    }

    public void setViewLeft(int n) {
        Point point = this.fScrollPane.getViewport().getViewPosition();
        point.x = n;
        this.setViewPosition(point);
    }

    public void setViewRight(int n) {
        this.accommodateView();
        if (!this.fViewFits) {
            JViewport jViewport = this.fScrollPane.getViewport();
            int n2 = this.getWidth();
            int n3 = jViewport.getView().getWidth();
            if (n < n3) {
                n2 -= this.fAheadButton.getPreferredSize().width;
            }
            if (n > n2) {
                n2 -= this.fBackButton.getPreferredSize().width;
            }
            Point point = jViewport.getViewPosition();
            point.x = n - n2;
            if (point.x < 0) {
                point.x = 0;
            }
            this.fScrollPane.getViewport().setViewPosition(point);
            boolean bl = this.fBackButton.isVisible();
            this.updateButtonVisibility();
            if (!bl && this.fBackButton.isVisible()) {
                this.fScrollPane.getViewport().setViewPosition(point);
            }
        }
    }

    public void setViewTop(int n) {
        Point point = this.fScrollPane.getViewport().getViewPosition();
        point.y = n;
        this.setViewPosition(point);
    }

    public void setViewBottom(int n) {
        this.accommodateView();
        if (!this.fViewFits) {
            JViewport jViewport = this.fScrollPane.getViewport();
            int n2 = this.getHeight();
            int n3 = jViewport.getView().getHeight();
            if (n < n3) {
                n2 -= this.fAheadButton.getPreferredSize().height;
            }
            if (n > n2) {
                n2 -= this.fBackButton.getPreferredSize().height;
            }
            Point point = jViewport.getViewPosition();
            point.y = n - n2;
            if (point.y < 0) {
                point.y = 0;
            }
            this.fScrollPane.getViewport().setViewPosition(point);
            boolean bl = this.fBackButton.isVisible();
            this.updateButtonVisibility();
            if (!bl && this.fBackButton.isVisible()) {
                this.fScrollPane.getViewport().setViewPosition(point);
            }
        }
    }

    public void addViewportChangeListener(ChangeListener changeListener) {
        this.fScrollPane.getViewport().addChangeListener(changeListener);
    }

    public void removeViewportChangeListener(ChangeListener changeListener) {
        this.fScrollPane.getViewport().removeChangeListener(changeListener);
    }

    public void setOrientation(int n) {
        if (n != this.fOrientation) {
            this.fOrientation = n;
            if (this.fAheadButton != null) {
                this.remove(this.fAheadButton);
                this.fAheadButton = null;
            }
            if (this.fBackButton != null) {
                this.remove(this.fBackButton);
                this.fBackButton = null;
            }
            this.fViewFits = true;
        }
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setScrollOnMouseOver(boolean bl) {
        this.fScrollOnMouseOver = bl;
    }

    public boolean getScrollOnMouseOver() {
        return this.fScrollOnMouseOver;
    }

    public void ensureVisible(Component component) {
        Rectangle rectangle = this.getViewRect();
        Component component2 = this.getViewport().getView();
        if (!SwingUtilities.isDescendingFrom(component, component2)) {
            return;
        }
        Rectangle rectangle2 = SwingUtilities.convertRectangle(component, new Rectangle(0, 0, component.getWidth(), component.getHeight()), component2);
        if (this.fOrientation == 1) {
            int n = rectangle2.y + rectangle2.height;
            int n2 = rectangle.y + rectangle.height;
            if (n > n2) {
                this.setViewBottom(n);
                rectangle = this.getViewRect();
            }
            if (rectangle2.y < rectangle.y) {
                this.setViewTop(rectangle2.y);
            }
        } else {
            int n = rectangle2.x + rectangle2.width;
            int n3 = rectangle.x + rectangle.width;
            if (n > n3) {
                this.setViewRight(n);
                rectangle = this.getViewRect();
            }
            if (rectangle2.x < rectangle.x) {
                this.setViewLeft(rectangle2.x);
            }
        }
    }

    protected void accommodateView() {
        boolean bl;
        Component component = this.fScrollPane.getViewport().getView();
        if (component == null || this.getParent() == null) {
            bl = true;
        } else if (this.fOrientation == 1) {
            bl = component.getPreferredSize().height <= this.getHeight();
        } else {
            boolean bl2 = bl = component.getPreferredSize().width <= this.getWidth();
        }
        if (bl != this.fViewFits) {
            if (!bl && this.fAheadButton == null) {
                this.addButtons();
            }
            this.fViewFits = bl;
            if (bl) {
                this.fScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        }
        this.updateButtonVisibility();
    }

    protected void addButtons() {
        if (this.fOrientation == 1) {
            this.fAheadButton = new MJToggleButton(sPointSouthIcon);
            this.fBackButton = new MJToggleButton(sPointNorthIcon);
            this.add((Component)this.fAheadButton, "South");
            this.add((Component)this.fBackButton, "North");
        } else {
            this.fAheadButton = new MJToggleButton(sPointEastIcon);
            this.fBackButton = new MJToggleButton(sPointWestIcon);
            this.add((Component)this.fAheadButton, "East");
            this.add((Component)this.fBackButton, "West");
        }
        HoverListener hoverListener = new HoverListener();
        this.fAheadButton.setBackground(new Color(0, 0, 0, 0));
        this.fAheadButton.setOpaque(false);
        this.fAheadButton.setMargin(MINIMAL_INSETS);
        this.fAheadButton.setFocusTraversable(false);
        this.fAheadButton.setFlyOverAppearance(true);
        this.fAheadButton.setVisible(false);
        this.fAheadButton.addMouseListener(hoverListener);
        this.fBackButton.setBackground(new Color(0, 0, 0, 0));
        this.fBackButton.setOpaque(false);
        this.fBackButton.setMargin(MINIMAL_INSETS);
        this.fBackButton.setFocusTraversable(false);
        this.fBackButton.setFlyOverAppearance(true);
        this.fBackButton.setVisible(false);
        this.fBackButton.addMouseListener(hoverListener);
    }

    protected void updateButtonVisibility() {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.fViewFits) {
            JViewport jViewport = this.fScrollPane.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Dimension dimension = jViewport.getView().getSize();
            if (this.fOrientation == 1) {
                bl = rectangle.y + rectangle.height < dimension.height;
                bl2 = rectangle.y > 0;
            } else {
                bl = rectangle.x + rectangle.width < dimension.width;
                bl2 = rectangle.x > 0;
            }
        }
        if (bl != (this.fAheadButton != null && this.fAheadButton.isVisible())) {
            this.fAheadButton.setSelected(false);
            this.fAheadButton.setVisible(bl);
        }
        if (bl2 != (this.fBackButton != null && this.fBackButton.isVisible())) {
            this.fBackButton.setSelected(false);
            this.fBackButton.setVisible(bl2);
        }
    }

    class HoverListener
    extends MouseAdapter
    implements ActionListener {
        private Timer fScrollTimer = new Timer(150, this);
        private int fDirection;
        private boolean fIsButtonDown;
        private boolean fExpired;

        HoverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!MJScrollStrip.this.fScrollOnMouseOver && !this.fIsButtonDown) {
                return;
            }
            MJToggleButton mJToggleButton = (MJToggleButton)mouseEvent.getSource();
            mJToggleButton.setSelected(true);
            if (!this.fScrollTimer.isRunning()) {
                this.fDirection = mouseEvent.getSource() == MJScrollStrip.this.fAheadButton ? 1 : -1;
                this.fExpired = false;
                this.fScrollTimer.setDelay(150);
                this.fScrollTimer.setRepeats(false);
                this.fScrollTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!MJScrollStrip.this.fScrollOnMouseOver && !this.fIsButtonDown) {
                return;
            }
            MJToggleButton mJToggleButton = (MJToggleButton)mouseEvent.getSource();
            mJToggleButton.setSelected(false);
            if (this.fScrollTimer.isRunning()) {
                this.fScrollTimer.stop();
                if (!this.fExpired) {
                    return;
                }
                JViewport jViewport = MJScrollStrip.this.fScrollPane.getViewport();
                Rectangle rectangle = jViewport.getViewRect();
                Component component = jViewport.getView();
                if (component instanceof Scrollable) {
                    int n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, MJScrollStrip.this.fOrientation, this.fDirection);
                    if (MJScrollStrip.this.fOrientation == 1) {
                        rectangle.y += n;
                    } else {
                        rectangle.x += n;
                    }
                    jViewport.setViewPosition(rectangle.getLocation());
                }
                MJScrollStrip.this.updateButtonVisibility();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fIsButtonDown = true;
            if (!MJScrollStrip.this.fScrollOnMouseOver) {
                this.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!MJScrollStrip.this.fScrollOnMouseOver) {
                this.mouseExited(mouseEvent);
            }
            this.fIsButtonDown = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            this.fExpired = true;
            if (!this.fScrollTimer.isRepeats()) {
                this.fScrollTimer.setDelay(30);
                this.fScrollTimer.setRepeats(true);
                this.fScrollTimer.start();
            }
            JViewport jViewport = MJScrollStrip.this.fScrollPane.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Dimension dimension = jViewport.getView().getSize();
            boolean bl = false;
            int n2 = n = this.fIsButtonDown ? 6 : 3;
            if (MJScrollStrip.this.fOrientation == 1) {
                if (this.fDirection > 0) {
                    rectangle.y += n;
                    if (rectangle.y + rectangle.height >= dimension.height) {
                        rectangle.y = dimension.height - rectangle.height;
                        bl = true;
                    }
                } else {
                    rectangle.y -= n;
                    if (rectangle.y <= 0) {
                        rectangle.y = 0;
                        bl = true;
                    }
                }
            } else {
                n <<= 1;
                if (this.fDirection > 0) {
                    rectangle.x += n;
                    if (rectangle.x + rectangle.width >= dimension.width) {
                        rectangle.x = dimension.width - rectangle.width;
                        bl = true;
                    }
                } else {
                    rectangle.x -= n;
                    if (rectangle.x <= 0) {
                        rectangle.x = 0;
                        bl = true;
                    }
                }
            }
            jViewport.setViewPosition(rectangle.getLocation());
            if (bl) {
                this.fScrollTimer.stop();
                MJScrollStrip.this.updateButtonVisibility();
            }
        }
    }

    class ResizeListener
    extends ComponentAdapter
    implements HierarchyListener {
        ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MJScrollStrip.this.accommodateView();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            MJScrollStrip.this.accommodateView();
        }
    }
}

