/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.CustomizablePopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.SelectAllOnFocusListener;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.ArrayUtils;

public class MJTextField
extends JTextField
implements KeyBindingManagerRegistrant,
CustomizablePopupMenu {
    private DocumentListener fDocumentSafetyListener;
    private ComponentListener fTruncationListener;
    private static final String CONTEXT_MENU_LISTENER = "MJTextFieldContextMenuListener";
    private static final String SELECT_ALL_LISTENER = "MJTextFieldSelectAllFocusListener";
    static final AppearanceFocusDispatcher APPEARANCE_FOCUS_DISPATCHER = new AppearanceFocusDispatcher();
    static final boolean CHECK_DOCUMENT_THREADING = false;

    public MJTextField() {
        this.initialize();
    }

    public MJTextField(Document document, String string, int n) {
        super(document, string, n);
        this.initialize();
    }

    public MJTextField(int n) {
        super(n);
        this.initialize();
    }

    public MJTextField(String string) {
        super(string);
        this.initialize();
    }

    public MJTextField(String string, int n) {
        super(string, n);
        this.initialize();
    }

    public void setTipWhenTruncatedEnabled(boolean bl) {
        if (bl != this.isTipWhenTruncatedEnabled()) {
            if (bl) {
                this.setToolTipText(this.isTruncated() ? this.getText() : null);
                this.fTruncationListener = new TruncationListener();
                this.addComponentListener(this.fTruncationListener);
            } else {
                if (super.getToolTipText() != null && super.getToolTipText().equals(this.getText())) {
                    this.setToolTipText(null);
                }
                this.removeComponentListener(this.fTruncationListener);
            }
        }
    }

    public boolean isTipWhenTruncatedEnabled() {
        return this.fTruncationListener != null;
    }

    private boolean isTruncated() {
        return this.getUI().getPreferredSize((JComponent)this).width > this.getWidth();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.isTipWhenTruncatedEnabled()) {
            this.setToolTipText(this.isTruncated() ? string : null);
        }
    }

    private void initialize() {
        this.addSafetyListeners();
        MJTextField.doInitialize(this, SelectAllOnFocusListener.SelectAllBehavior.KEYBOARD, DefaultKeyBindings.getManager(), "DefaultContext");
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.getSelectAllOnFocusListener().setEnabled(bl);
    }

    public void addContextMenu(JPopupMenu jPopupMenu) {
        ContextMenuListener contextMenuListener = this.getContextMenuListener();
        if (contextMenuListener != null) {
            if (jPopupMenu == null) {
                this.removeContextMenu();
            } else {
                contextMenuListener.setMenu(jPopupMenu);
            }
        } else if (jPopupMenu != null) {
            MJTextField.setupNewContextMenu(this, jPopupMenu);
        }
    }

    public void removeContextMenu() {
        ContextMenuListener contextMenuListener = this.getContextMenuListener();
        if (contextMenuListener != null) {
            this.removeMouseListener(contextMenuListener);
            MJTextField.storeContextMenuListener(this, null);
        }
    }

    @Override
    public void setCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        ContextMenuListener contextMenuListener = this.getContextMenuListener();
        if (contextMenuListener != null && contextMenuListener.fMenu instanceof CustomizablePopupMenu) {
            ((CustomizablePopupMenu)((Object)contextMenuListener.fMenu)).setCustomizer(popupMenuCustomizer);
        }
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setDocument(Document document) {
        if (this.fDocumentSafetyListener != null) {
            Document document2 = this.getDocument();
            document2.removeDocumentListener(this.fDocumentSafetyListener);
            document.addDocumentListener(this.fDocumentSafetyListener);
        }
        super.setDocument(document);
    }

    static void initialize(JTextField jTextField, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior, KeyBindingManager keyBindingManager, String string) {
        if (jTextField instanceof MJTextField) {
            throw new IllegalArgumentException("This method should not be called for instance of MJTextField because initialization is done as part of construction.");
        }
        MJTextField.doInitialize(jTextField, selectAllBehavior, keyBindingManager, string);
    }

    private static void doInitialize(JTextField jTextField, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior, KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(jTextField, keyBindingManager, string);
        MJTextField.addContextMenuListenerAndRemoveOldIfNecessary(jTextField, keyBindingManager, string);
        MJTextField.addSelectAllListenerAndRemoveOldIfNecessary(jTextField, selectAllBehavior);
        MJTextField.addAppearanceFocusListenerIfNecessary(jTextField);
    }

    private static void addAppearanceFocusListenerIfNecessary(JTextField jTextField) {
        if (!PlatformInfo.isMacintosh() && !ArrayUtils.contains((Object[])jTextField.getFocusListeners(), (Object)APPEARANCE_FOCUS_DISPATCHER)) {
            jTextField.addFocusListener(APPEARANCE_FOCUS_DISPATCHER);
        }
    }

    private static void addSelectAllListenerAndRemoveOldIfNecessary(JTextField jTextField, SelectAllOnFocusListener.SelectAllBehavior selectAllBehavior) {
        SelectAllOnFocusListener selectAllOnFocusListener = MJTextField.getSelectAllOnFocusListener(jTextField);
        if (selectAllOnFocusListener != null) {
            selectAllOnFocusListener.setEnabled(false);
        }
        SelectAllOnFocusListener selectAllOnFocusListener2 = new SelectAllOnFocusListener(jTextField, selectAllBehavior);
        MJTextField.storeSelectAllFocusListener(jTextField, selectAllOnFocusListener2);
    }

    private static SelectAllOnFocusListener getSelectAllOnFocusListener(JTextField jTextField) {
        return (SelectAllOnFocusListener)jTextField.getClientProperty(SELECT_ALL_LISTENER);
    }

    private SelectAllOnFocusListener getSelectAllOnFocusListener() {
        SelectAllOnFocusListener selectAllOnFocusListener = MJTextField.getSelectAllOnFocusListener(this);
        assert (selectAllOnFocusListener != null) : "SelectAllOnFocusListener should be registered.";
        return selectAllOnFocusListener;
    }

    private static void storeSelectAllFocusListener(JTextField jTextField, SelectAllOnFocusListener selectAllOnFocusListener) {
        jTextField.putClientProperty(SELECT_ALL_LISTENER, selectAllOnFocusListener);
    }

    private static void setupNewContextMenu(JTextField jTextField, JPopupMenu jPopupMenu) {
        ContextMenuListener contextMenuListener = new ContextMenuListener(jTextField, jPopupMenu);
        jTextField.addMouseListener(contextMenuListener);
        MJTextField.storeContextMenuListener(jTextField, contextMenuListener);
    }

    private static void addContextMenuListenerAndRemoveOldIfNecessary(JTextField jTextField, KeyBindingManager keyBindingManager, String string) {
        ContextMenuListener contextMenuListener = MJTextField.getContextMenuListener(jTextField);
        if (contextMenuListener != null) {
            jTextField.removeMouseListener(contextMenuListener);
        }
        MJTextField.setupNewContextMenu(jTextField, new TextContextMenu(keyBindingManager, string));
    }

    private static ContextMenuListener getContextMenuListener(JTextField jTextField) {
        return (ContextMenuListener)jTextField.getClientProperty(CONTEXT_MENU_LISTENER);
    }

    private ContextMenuListener getContextMenuListener() {
        ContextMenuListener contextMenuListener = MJTextField.getContextMenuListener(this);
        assert (contextMenuListener != null) : "Context menu listener should be registered.";
        return contextMenuListener;
    }

    private static void storeContextMenuListener(JTextField jTextField, ContextMenuListener contextMenuListener) {
        jTextField.putClientProperty(CONTEXT_MENU_LISTENER, contextMenuListener);
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(this, keyBindingManager, string);
        this.addContextMenu(new TextContextMenu(keyBindingManager, string));
    }

    static {
        APPEARANCE_FOCUS_DISPATCHER.addAppearanceFocusListener(new TextAppearanceFocusListener());
    }

    private class TruncationListener
    extends ComponentAdapter {
        private TruncationListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MJTextField.this.setToolTipText(MJTextField.this.isTruncated() ? MJTextField.this.getText() : null);
        }
    }

    private static class ContextMenuListener
    extends PopupListener {
        private JTextField fTextField;
        private JPopupMenu fMenu;

        private ContextMenuListener(JTextField jTextField, JPopupMenu jPopupMenu) {
            this.fTextField = jTextField;
            this.fMenu = jPopupMenu;
        }

        public void setMenu(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!mouseEvent.isPopupTrigger() && this.fMenu.isShowing()) {
                this.fMenu.setVisible(false);
            }
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            this.fTextField.requestFocus();
            SelectAllOnFocusListener selectAllOnFocusListener = MJTextField.getSelectAllOnFocusListener(this.fTextField);
            assert (selectAllOnFocusListener != null) : "Should have a select all on focus listener";
            selectAllOnFocusListener.selectAllIfFocusGainedWouldResultInSelectAll();
            this.fMenu.show(this.fTextField, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static class TextAppearanceFocusListener
    implements AppearanceFocusListener {
        private static final String SAVED_SELECTION_COLOR = "SavedSelectionColor";
        private static final String SAVED_SELECTED_TEXT_COLOR = "SavedSelectedTextColor";

        private TextAppearanceFocusListener() {
        }

        @Override
        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)appearanceFocusEvent.getComponent();
                jTextComponent.putClientProperty(SAVED_SELECTION_COLOR, jTextComponent.getSelectionColor());
                jTextComponent.putClientProperty(SAVED_SELECTED_TEXT_COLOR, jTextComponent.getSelectedTextColor());
                jTextComponent.setSelectionColor(ColorUtils.getUnfocusedSelectionBackgroundColor(jTextComponent));
                jTextComponent.setSelectedTextColor(ColorUtils.getUnfocusedSelectionForegroundColor(jTextComponent));
                jTextComponent.repaint();
            }
        }

        @Override
        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof JTextComponent) {
                Color color;
                JTextComponent jTextComponent = (JTextComponent)appearanceFocusEvent.getComponent();
                Color color2 = (Color)jTextComponent.getClientProperty(SAVED_SELECTION_COLOR);
                if (color2 != null) {
                    jTextComponent.setSelectionColor(color2);
                }
                if ((color = (Color)jTextComponent.getClientProperty(SAVED_SELECTED_TEXT_COLOR)) != null) {
                    jTextComponent.setSelectedTextColor(color);
                }
                jTextComponent.repaint();
            }
        }
    }
}

