/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.mwswing.text.TextDragRecognizer;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SizeRequirements;
import javax.swing.plaf.TextUI;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MJTextPane
extends JTextPane
implements KeyBindingManagerRegistrant {
    protected ContextMenuListener fContextListener;
    protected TextDragRecognizer fDragRecognizer;
    protected boolean fWrapEnabled = true;

    public MJTextPane() {
        this.initialize();
    }

    public MJTextPane(StyledDocument styledDocument) {
        super(styledDocument);
        this.initialize();
    }

    private void initialize() {
        this.registerWithKeyBindingManager(DefaultKeyBindings.getManager(), "DefaultContext");
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(this, keyBindingManager, string);
        this.addContextMenu(new TextContextMenu(keyBindingManager, string));
    }

    public void setWrapping(boolean bl) {
        this.fWrapEnabled = bl;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        TextUI textUI = this.getUI();
        return this.fWrapEnabled || container == null || textUI.getPreferredSize((JComponent)this).width <= container.getSize().width;
    }

    public void addContextMenu(JPopupMenu jPopupMenu) {
        if (this.fContextListener != null) {
            if (jPopupMenu == null) {
                this.removeContextMenu();
            } else {
                this.fContextListener.setMenu(jPopupMenu);
            }
        } else if (jPopupMenu != null) {
            this.fContextListener = new ContextMenuListener(jPopupMenu);
            this.addMouseListener(this.fContextListener);
        }
    }

    public void removeContextMenu() {
        if (this.fContextListener != null) {
            this.removeMouseListener(this.fContextListener);
            this.fContextListener = null;
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener instanceof TextDragRecognizer) {
            this.fDragRecognizer = (TextDragRecognizer)mouseListener;
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null) {
            int n = mouseEvent.getID();
            if (n == 501) {
                this.fDragRecognizer.mousePressed(mouseEvent);
            } else if (n == 502) {
                this.fDragRecognizer.mouseReleased(mouseEvent);
            }
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && mouseEvent.getID() == 506) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return new ViewFactory(){

                    @Override
                    public View create(Element element) {
                        String string = element.getName();
                        if (string != null) {
                            if (string.equals("content")) {
                                return new LabelView(element);
                            }
                            if (string.equals("paragraph")) {
                                return new ParagraphView(element){

                                    @Override
                                    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                                        if (sizeRequirements == null) {
                                            sizeRequirements = new SizeRequirements();
                                        }
                                        float f = this.layoutPool.getPreferredSpan(n);
                                        float f2 = this.layoutPool.getMinimumSpan(n);
                                        sizeRequirements.minimum = (int)f2;
                                        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f);
                                        sizeRequirements.maximum = Integer.MAX_VALUE;
                                        sizeRequirements.alignment = 0.5f;
                                        return sizeRequirements;
                                    }
                                };
                            }
                            if (string.equals("section")) {
                                return new BoxView(element, 1);
                            }
                            if (string.equals("component")) {
                                return new ComponentView(element);
                            }
                            if (string.equals("icon")) {
                                return new IconView(element);
                            }
                        }
                        return new LabelView(element);
                    }
                };
            }
        };
    }

    protected class ContextMenuListener
    extends MouseAdapter {
        private JPopupMenu fMenu;

        public ContextMenuListener(JPopupMenu jPopupMenu) {
            this.setMenu(jPopupMenu);
        }

        public void setMenu(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MJTextPane.this.requestFocus();
                this.getMenu().show(MJTextPane.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public JPopupMenu getMenu() {
            return this.fMenu;
        }
    }
}

