/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AbstractTreeTableCellEditor;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.TreeTableCellRenderer;
import com.mathworks.mwswing.TreeTableModel;
import com.mathworks.mwswing.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeSelectionModel;

public class MJTreeTable
extends MJTable {
    protected TreeTableCellRenderer fTree;

    public MJTreeTable(TreeTableModel treeTableModel) {
        this.fTree = this.createTreeTableCellRenderer(this, treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.fTree));
        this.fTree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                MJTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.fTree.setRowHeight(this.getRowHeight());
        this.setDefaultRenderer(TreeTableModel.class, this.fTree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fTree != null) {
            this.fTree.setFont(font);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fTree != null) {
            this.fTree.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fTree != null) {
            this.fTree.setForeground(color);
        }
    }

    public MJTree getTree() {
        return this.fTree;
    }

    public void expandAllNodes() {
        this.fTree.expandAllNodes();
    }

    public final void updateTreeTableView() {
        this.fTree.fireTreeModelChanged();
        this.tableChanged(new TableModelEvent(this.getModel()));
        this.repaint();
    }

    public void showCell(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, true);
        this.scrollRectToVisible(rectangle);
    }

    protected TreeTableCellRenderer createTreeTableCellRenderer(MJTreeTable mJTreeTable, TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(mJTreeTable, treeTableModel);
    }

    public class TreeTableCellEditor
    extends AbstractTreeTableCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return MJTreeTable.this.fTree;
        }
    }
}

