/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.SimpleElement;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class SimpleDOMParser {
    public static final int DEFAULT_TAG_LENGTH_LIMIT = 1000000;
    public static final int DEFAULT_TEXT_LENGTH_LIMIT = 1000000;
    public static final int DEFAULT_CDATA_LENGTH_LIMIT = 1000000;
    public static final int ESCAPE_CODE_LENGTH_LIMIT = 7;
    private static final int[] cdata_start = new int[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    private static final int[] cdata_end = new int[]{93, 93, 62};
    private static final char[] sSpecialChar = new char[]{'<', '>', '&', '\"'};
    private static final String[] sEscape = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    private Reader reader;
    private Stack elements = new Stack();
    private SimpleElement currentElement = null;
    private int tagLengthLimit = 1000000;
    private int textLengthLimit = 1000000;
    private int dataLengthLimit = 1000000;

    public void setTagLengthLimit(int n) {
        this.tagLengthLimit = n;
    }

    public int getTagLengthLimit() {
        return this.tagLengthLimit;
    }

    public void setTextLengthLimit(int n) {
        this.textLengthLimit = n;
    }

    public int getTextLengthLimit() {
        return this.tagLengthLimit;
    }

    public void setCDATALengthLimit(int n) {
        this.dataLengthLimit = n;
    }

    public int getCDATALengthLimit() {
        return this.dataLengthLimit;
    }

    public SimpleElement parse(Reader reader) throws IOException {
        SimpleElement simpleElement;
        this.reader = reader;
        this.skipPrologs();
        while (true) {
            String string;
            String string2;
            if ((string2 = this.readTag().trim()).startsWith("<!--")) {
                continue;
            }
            if (string2.startsWith("</")) {
                string = string2.substring(2, string2.length() - 1);
                if (this.currentElement == null) {
                    throw new IOException("Got close tag '" + string + "' without open tag.");
                }
                if (!string.equals(this.currentElement.getTagName())) {
                    throw new IOException("Expected close tag for '" + this.currentElement.getTagName() + "' but got '" + string + "'.");
                }
                if (this.elements.empty()) {
                    return this.currentElement;
                }
                this.currentElement = (SimpleElement)this.elements.pop();
                continue;
            }
            int n = string2.indexOf(" ");
            if (n < 0) {
                if (string2.endsWith("/>")) {
                    string = string2.substring(1, string2.length() - 2);
                    string2 = "/>";
                } else {
                    string = string2.substring(1, string2.length() - 1);
                    string2 = "";
                }
            } else {
                string = string2.substring(1, n);
                string2 = string2.substring(n + 1);
            }
            simpleElement = new SimpleElement(string);
            boolean bl = false;
            while (string2.length() > 0) {
                if ((string2 = string2.trim()).equals("/>")) {
                    bl = true;
                    break;
                }
                if (string2.equals(">")) break;
                n = string2.indexOf("=");
                if (n < 0) {
                    throw new IOException("Invalid attribute for tag '" + string + "'.");
                }
                String string3 = string2.substring(0, n);
                string3 = string3.trim();
                string2 = string2.substring(n + 1);
                boolean bl2 = true;
                if (string2.startsWith("\"")) {
                    n = string2.indexOf(34, 1);
                } else if (string2.startsWith("'")) {
                    n = string2.indexOf(39, 1);
                } else {
                    bl2 = false;
                    n = string2.indexOf(32);
                    if (n < 0 && (n = string2.indexOf(62)) < 0) {
                        n = string2.indexOf(47);
                    }
                }
                if (n < 0) {
                    throw new IOException("Invalid attribute for tag '" + string + "'.");
                }
                String string4 = bl2 ? string2.substring(1, n) : string2.substring(0, n);
                string4 = SimpleDOMParser.unescape(string4);
                simpleElement.setAttribute(string3, string4);
                string2 = string2.substring(n + 1);
            }
            if (!bl) {
                simpleElement.setText(this.readText());
            }
            if (this.currentElement != null) {
                this.currentElement.addChildElement(simpleElement);
            }
            if (!bl) {
                if (this.currentElement != null) {
                    this.elements.push(this.currentElement);
                }
                this.currentElement = simpleElement;
                continue;
            }
            if (this.currentElement == null) break;
        }
        return simpleElement;
    }

    private int peek() throws IOException {
        this.reader.mark(1);
        int n = this.reader.read();
        this.reader.reset();
        return n;
    }

    private void peek(int[] nArray) throws IOException {
        this.reader.mark(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.reader.read();
        }
        this.reader.reset();
    }

    private void skipWhitespace() throws IOException {
        while (Character.isWhitespace((char)this.peek())) {
            this.reader.read();
        }
    }

    private void skipProlog() throws IOException {
        this.reader.skip(2L);
        while (true) {
            int n;
            if ((n = this.peek()) == 62) break;
            if (n == 60) {
                this.skipProlog();
                continue;
            }
            if (n == -1) {
                throw new IOException("Encoundered end-of-file while reading prolog");
            }
            this.reader.read();
        }
        this.reader.read();
    }

    private void skipPrologs() throws IOException {
        while (true) {
            this.skipWhitespace();
            int[] nArray = new int[2];
            this.peek(nArray);
            if (nArray[0] != 60) {
                throw new IOException("Expected '<' but got '" + (char)nArray[0] + "'.");
            }
            if (nArray[1] != 63 && nArray[1] != 33) break;
            this.skipProlog();
        }
    }

    private String readTag() throws IOException {
        this.skipWhitespace();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.peek();
        if (n != 60) {
            throw new IOException("Expected < but got " + (char)n);
        }
        n = this.reader.read();
        while (n != 62 && n != -1 && stringBuilder.length() <= this.tagLengthLimit) {
            stringBuilder.append((char)n);
            n = this.reader.read();
        }
        if (n == -1) {
            throw new IOException("Encoundered end-of-file while reading tag");
        }
        if (n != 62) {
            throw new IOException("Tag exceeded parser length limit");
        }
        stringBuilder.append((char)n);
        return stringBuilder.toString();
    }

    private String readText() throws IOException {
        StringBuilder stringBuilder;
        block12: {
            stringBuilder = new StringBuilder();
            int[] nArray = new int[cdata_start.length];
            this.peek(nArray);
            if (this.compareIntArrays(nArray, cdata_start)) {
                this.reader.skip(nArray.length);
                int[] nArray2 = new int[cdata_end.length];
                while (true) {
                    this.peek(nArray2);
                    if (this.compareIntArrays(nArray2, cdata_end)) {
                        this.reader.skip(nArray2.length);
                        break block12;
                    }
                    if (stringBuilder.length() >= this.dataLengthLimit) {
                        throw new IOException("CDATA exceeded parser length limit");
                    }
                    int n = this.reader.read();
                    if (n == -1) {
                        throw new IOException("Encoundered end-of-file while reading CDATA");
                    }
                    stringBuilder.append((char)n);
                }
            }
            int n = 0;
            StringBuilder stringBuilder2 = null;
            while (this.peek() != 60) {
                if (stringBuilder.length() >= this.textLengthLimit) {
                    throw new IOException("Text exceeded parser length limit");
                }
                int n2 = this.reader.read();
                if (n2 == -1) {
                    throw new IOException("Encoundered end-of-file while reading tag");
                }
                char c = (char)n2;
                stringBuilder.append(c);
                if (n == 0) {
                    if (c != '&') continue;
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder();
                    }
                    stringBuilder2.append(c);
                    n = 1;
                    continue;
                }
                stringBuilder2.append(c);
                ++n;
                if (c == ';') {
                    String string = SimpleDOMParser.unescapeCode(stringBuilder2.toString());
                    if (string != null) {
                        int n3 = stringBuilder.length();
                        stringBuilder.delete(n3 - n, n3);
                        stringBuilder.append(string);
                    }
                    n = 0;
                    stringBuilder2.setLength(0);
                    continue;
                }
                if (n < 7) continue;
                n = 0;
                stringBuilder2.setLength(0);
            }
        }
        return stringBuilder.toString();
    }

    private boolean compareIntArrays(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            int n;
            if (string.charAt(i) == '&' && (n = string.indexOf(59, i)) != -1 && (string2 = SimpleDOMParser.unescapeCode(string.substring(i, n + 1))) != null) {
                stringBuilder.append(string2);
                i = n;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static String unescapeCode(String string) {
        return string.length() > 2 && string.charAt(1) == '#' ? SimpleDOMParser.unescapeNumericCode(string) : SimpleDOMParser.unescapeSpecialCharCode(string);
    }

    private static String unescapeSpecialCharCode(String string) {
        for (int i = 0; i < sEscape.length; ++i) {
            if (!string.regionMatches(true, 0, sEscape[i], 0, sEscape[i].length())) continue;
            return String.valueOf(sSpecialChar[i]);
        }
        return null;
    }

    private static String unescapeNumericCode(String string) {
        String string2 = string.substring(2, string.length() - 1);
        if (string2.length() > 0) {
            try {
                if (string2.length() > 1 && string2.startsWith("x")) {
                    return String.valueOf((char)Integer.parseInt(string2.substring(1), 16));
                }
                return String.valueOf((char)Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

