/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.ContextActionData;
import com.mathworks.mwswing.binding.ContextID;
import com.mathworks.mwswing.binding.CustomActionInfo;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;

public final class CustomKeyBindingSet
extends KeyBindingSet {
    private Map<ActionData, List<KeyStrokeList>> fGlobalMap = new HashMap<ActionData, List<KeyStrokeList>>();
    private Map<ContextID, Map<ActionDataID, ModifiableCustomActionInfo>> fContextEntryMap = new HashMap<ContextID, Map<ActionDataID, ModifiableCustomActionInfo>>();
    private final DefaultKeyBindingSet fParent;
    private static final KeyStrokeList EMPTY_KEYBINDING = null;
    private final Set<WeakReference<ChangeListener>> fListeners = new HashSet<WeakReference<ChangeListener>>();
    private boolean fEventFiringSuspended = false;
    private boolean fEventFiredWhileListenersSuspended = false;

    public CustomKeyBindingSet(String string, KeyBindingSet keyBindingSet, String string2) {
        this(string, keyBindingSet, string2, false);
    }

    public CustomKeyBindingSet(String string, KeyBindingSet keyBindingSet, String string2, boolean bl) {
        super(string, string2, bl);
        if (keyBindingSet instanceof CustomKeyBindingSet) {
            CustomKeyBindingSet customKeyBindingSet = (CustomKeyBindingSet)keyBindingSet;
            this.fParent = customKeyBindingSet.fParent;
            this.fGlobalMap = new HashMap<ActionData, List<KeyStrokeList>>();
            Set<Map.Entry<ActionData, List<KeyStrokeList>>> set = customKeyBindingSet.fGlobalMap.entrySet();
            for (Map.Entry<ActionData, List<KeyStrokeList>> object2 : set) {
                this.fGlobalMap.put(object2.getKey(), new LinkedList(object2.getValue()));
            }
            this.fContextEntryMap = new HashMap<ContextID, Map<ActionDataID, ModifiableCustomActionInfo>>();
            Set<Map.Entry<ContextID, Map<ActionDataID, ModifiableCustomActionInfo>>> set2 = customKeyBindingSet.fContextEntryMap.entrySet();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                HashMap hashMap = new HashMap();
                Set set3 = ((Map)entry.getValue()).entrySet();
                for (Map.Entry entry2 : set3) {
                    hashMap.put(entry2.getKey(), ((ModifiableCustomActionInfo)entry2.getValue()).copy());
                }
                this.fContextEntryMap.put((ContextID)entry.getKey(), hashMap);
            }
        } else {
            assert (keyBindingSet instanceof DefaultKeyBindingSet);
            this.fParent = (DefaultKeyBindingSet)keyBindingSet;
        }
    }

    public void removeGlobalBinding(KeyStrokeList keyStrokeList, ActionData actionData) {
        List<KeyStrokeList> list = this.fGlobalMap.get(actionData);
        if (list != null) {
            if (KeyStrokeUtils.removeAllBindingVariations(keyStrokeList, list) && list.equals(this.fParent.getActionGlobalKeyBindings(actionData))) {
                this.fGlobalMap.remove(actionData);
            }
        } else {
            LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>(this.getActionGlobalKeyBindings(actionData));
            if (KeyStrokeUtils.removeAllBindingVariations(keyStrokeList, linkedList)) {
                if (linkedList.isEmpty()) {
                    this.addGlobalBinding(actionData, EMPTY_KEYBINDING);
                } else {
                    for (KeyStrokeList keyStrokeList2 : linkedList) {
                        this.addGlobalBinding(actionData, keyStrokeList2);
                    }
                }
            }
        }
        this.fireChangeEvent();
    }

    public void addGlobalBindingToExistingEntries(ActionData actionData, KeyStroke ... keyStrokeArray) {
        this.populateGlobalMapWithParentEntriesIfNecessary(actionData);
        this.addGlobalBinding(actionData, new KeyStrokeList(keyStrokeArray));
    }

    private void populateGlobalMapWithParentEntriesIfNecessary(ActionData actionData) {
        List<KeyStrokeList> list = this.fGlobalMap.get(actionData);
        if (list == null) {
            this.fGlobalMap.put(actionData, new LinkedList<KeyStrokeList>(this.getActionGlobalKeyBindings(actionData)));
        }
    }

    public void addGlobalBindings(ActionData actionData, List<KeyStrokeList> list) {
        if (list != null) {
            for (KeyStrokeList keyStrokeList : list) {
                this.addGlobalBinding(actionData, keyStrokeList);
            }
        } else {
            this.addGlobalBinding(actionData, EMPTY_KEYBINDING);
        }
    }

    public void addGlobalBinding(ActionData actionData, KeyStrokeList keyStrokeList) {
        List<KeyStrokeList> list = this.fGlobalMap.get(actionData);
        if (list == null) {
            list = new LinkedList<KeyStrokeList>();
            this.fGlobalMap.put(actionData, list);
        }
        if (keyStrokeList != EMPTY_KEYBINDING) {
            KeyStrokeUtils.addAllBindingVariations(keyStrokeList, list);
        }
        this.fireChangeEvent();
    }

    public boolean prioritizeGlobalBindings(ActionData actionData, List<KeyStrokeList> list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of bindings passed in cannot be null.");
        }
        if (!this.getActionGlobalKeyBindings(actionData).containsAll(list)) {
            throw new IllegalArgumentException("The list of bindings supplied is not a subset of the existing global bindings for " + actionData.getName());
        }
        if (!this.getActionGlobalKeyBindings(actionData).equals(list)) {
            this.populateGlobalMapWithParentEntriesIfNecessary(actionData);
            return this.reorderBindings(this.fGlobalMap.get(actionData), list);
        }
        return false;
    }

    public boolean prioritizeCustomBindings(Context context, ActionData actionData, List<KeyStrokeList> list) {
        boolean bl;
        if (list == null) {
            throw new IllegalArgumentException("The list of bindings passed in cannot be null.");
        }
        if (!this.getNonGlobalKeyBindings(context, actionData).containsAll(list)) {
            throw new IllegalArgumentException("The list of bindings supplied is not a subset of the existing non-global  bindings for action '" + actionData.getName() + "' and context '" + context.getName() + "'.");
        }
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.getContextInfo(context);
        if (map.get(actionData) != null) {
            bl = this.reorderBindings(map.get((Object)actionData).fLocalBindings, list);
        } else {
            LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>(this.fParent.getNonGlobalKeyBindings(context, actionData));
            bl = this.reorderBindings(linkedList, list);
            if (bl) {
                this.setCustomKeyBindings(context, actionData, this.getFollowsContext(context, actionData).equals(Context.GLOBAL), linkedList);
            }
        }
        return bl;
    }

    private boolean reorderBindings(List<KeyStrokeList> list, List<KeyStrokeList> list2) {
        assert (list != null) : "There are no current bindings to prioritize";
        assert (list.containsAll(list2)) : "The bindings to prioritize are not a subset of the original bindings";
        if (list.equals(list2)) {
            return false;
        }
        list.removeAll(list2);
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>(list);
        list.clear();
        list.addAll(list2);
        list.addAll(arrayList);
        this.fireChangeEvent();
        return true;
    }

    public void removeGlobalParentDuplicates() {
        Set<Map.Entry<ActionData, List<KeyStrokeList>>> set = this.fGlobalMap.entrySet();
        Iterator<Map.Entry<ActionData, List<KeyStrokeList>>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<ActionData, List<KeyStrokeList>> entry = iterator.next();
            if (!entry.getValue().equals(this.fParent.getActionGlobalKeyBindings(entry.getKey()))) continue;
            iterator.remove();
        }
    }

    public void addCustomKeyBinding(Context context, ActionDataID actionDataID, KeyStroke ... keyStrokeArray) {
        KeyStrokeList keyStrokeList = new KeyStrokeList(keyStrokeArray);
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.getContextInfo(context);
        ModifiableCustomActionInfo modifiableCustomActionInfo = map.get(actionDataID);
        if (modifiableCustomActionInfo == null) {
            LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>(this.fParent.getNonGlobalKeyBindings(context, actionDataID));
            if (!linkedList.contains(keyStrokeList)) {
                linkedList.add(keyStrokeList);
            }
            this.setCustomKeyBindings(context, actionDataID, this.getFollowsContext(context, actionDataID).equals(Context.GLOBAL), linkedList);
        } else {
            modifiableCustomActionInfo.addBindingAndEquivalentVariations(keyStrokeList);
            this.removeInfoIfNoCustom(map, modifiableCustomActionInfo, context, actionDataID);
        }
        this.fireChangeEvent();
    }

    public void removeCustomKeyBinding(KeyStrokeList keyStrokeList, Context context, ActionDataID actionDataID) {
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.getContextInfo(context);
        ModifiableCustomActionInfo modifiableCustomActionInfo = map.get(actionDataID);
        if (modifiableCustomActionInfo != null && modifiableCustomActionInfo.fLocalBindings.contains(keyStrokeList)) {
            KeyStrokeUtils.removeAllBindingVariations(keyStrokeList, modifiableCustomActionInfo.fLocalBindings);
            this.removeInfoIfNoCustom(map, modifiableCustomActionInfo, context, actionDataID);
        } else if (modifiableCustomActionInfo == null && this.fParent.getNonGlobalKeyBindings(context, actionDataID).contains(keyStrokeList)) {
            LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>(this.fParent.getNonGlobalKeyBindings(context, actionDataID));
            KeyStrokeUtils.removeAllBindingVariations(keyStrokeList, linkedList);
            this.setCustomKeyBindings(context, actionDataID, this.getFollowsContext(context, actionDataID).equals(Context.GLOBAL), linkedList);
        } else {
            throw new IllegalStateException("Incorrect binding asked to be removed.\nRequested action was " + actionDataID.getID() + ". " + "Requested context was " + context.getName() + ".\n" + "Requested binding to remove: " + KeyStrokeUtils.translateKeyStrokesToAscii(keyStrokeList));
        }
        this.fireChangeEvent();
    }

    private Map<ActionDataID, ModifiableCustomActionInfo> getContextInfo(ContextID contextID) {
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.fContextEntryMap.get(contextID);
        if (map == null) {
            map = new HashMap<ActionDataID, ModifiableCustomActionInfo>();
            this.fContextEntryMap.put(contextID, map);
        }
        return map;
    }

    public void setCustomKeyBindings(ContextID contextID, ActionDataID actionDataID, boolean bl, List<KeyStrokeList> list) {
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.getContextInfo(contextID);
        map.put(actionDataID, new ModifiableCustomActionInfo(bl, list));
    }

    public void changeFollowsGlobal(Context context, ActionDataID actionDataID, boolean bl) {
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.getContextInfo(context);
        ModifiableCustomActionInfo modifiableCustomActionInfo = map.get(actionDataID);
        if (modifiableCustomActionInfo == null && this.followsGlobalContext(context, actionDataID) != bl) {
            map.put(actionDataID, new ModifiableCustomActionInfo(bl, this.fParent.getNonGlobalKeyBindings(context, actionDataID)));
        } else if (modifiableCustomActionInfo != null) {
            modifiableCustomActionInfo.setFollowsGlobal(bl);
            this.removeInfoIfNoCustom(map, modifiableCustomActionInfo, context, actionDataID);
        }
        this.fireChangeEvent();
    }

    private void removeInfoIfNoCustom(Map<ActionDataID, ModifiableCustomActionInfo> map, ModifiableCustomActionInfo modifiableCustomActionInfo, Context context, ActionDataID actionDataID) {
        if (modifiableCustomActionInfo.hasNoCustomInfo(context, actionDataID, this.fParent)) {
            map.remove(actionDataID);
        }
    }

    @Override
    public List<KeyStrokeList> getActionGlobalKeyBindings(ActionData actionData) {
        List<KeyStrokeList> list = this.fGlobalMap.get(actionData);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return this.fParent.getActionGlobalKeyBindings(actionData);
    }

    @Override
    public List<KeyStrokeList> getGlobalKeyBindings(Context context, ActionData actionData) {
        ModifiableCustomActionInfo modifiableCustomActionInfo = this.getModifiableCustomActionInfo(context, actionData);
        if (modifiableCustomActionInfo != null) {
            return modifiableCustomActionInfo.fFollowsGlobal ? this.getActionGlobalKeyBindings(actionData) : Collections.unmodifiableList(Collections.emptyList());
        }
        LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
        ContextActionData contextActionData = context.getContextAction(actionData);
        Context context2 = contextActionData.getFollowsContext(this.fParent);
        if (context2 == Context.GLOBAL) {
            linkedList.addAll(this.getActionGlobalKeyBindings(actionData));
        } else if (contextActionData.getFollowsComponentContext(this.fParent)) {
            linkedList.addAll(this.getGlobalKeyBindings(context2, actionData));
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public List<KeyStrokeList> getNonGlobalKeyBindings(Context context, ActionDataID actionDataID) {
        ModifiableCustomActionInfo modifiableCustomActionInfo = this.getModifiableCustomActionInfo(context, actionDataID);
        if (modifiableCustomActionInfo != null) {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(modifiableCustomActionInfo.fLocalBindings);
            return Collections.unmodifiableList(linkedList);
        }
        ContextActionData contextActionData = context.getContextAction(actionDataID);
        Context context2 = contextActionData.getFollowsContext(this.fParent);
        if (contextActionData.getFollowsComponentContext(this.fParent)) {
            LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
            linkedList.addAll(this.getNonGlobalKeyBindings(context2, actionDataID));
            return Collections.unmodifiableList(linkedList);
        }
        return this.fParent.getNonGlobalKeyBindings(context, actionDataID);
    }

    private ModifiableCustomActionInfo getModifiableCustomActionInfo(Context context, ActionDataID actionDataID) {
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.fContextEntryMap.get(context);
        return map == null ? null : map.get(actionDataID);
    }

    @Override
    public boolean getFollowsComponentContext(Context context, ActionDataID actionDataID) {
        return this.getFollowsContext(context, actionDataID).supportsActions();
    }

    @Override
    public Context getFollowsContext(Context context, ActionDataID actionDataID) {
        ModifiableCustomActionInfo modifiableCustomActionInfo;
        Map<ActionDataID, ModifiableCustomActionInfo> map = this.fContextEntryMap.get(context);
        if (map != null && (modifiableCustomActionInfo = map.get(actionDataID)) != null) {
            return modifiableCustomActionInfo.fFollowsGlobal ? Context.GLOBAL : Context.NONE;
        }
        return this.fParent.getFollowsContext(context, actionDataID);
    }

    public boolean isInfoEqual(KeyBindingSet keyBindingSet) {
        if (!(keyBindingSet instanceof CustomKeyBindingSet)) {
            if (this.fParent.equals(keyBindingSet) && this.fGlobalMap.isEmpty()) {
                Collection<Map<ActionDataID, ModifiableCustomActionInfo>> collection = this.fContextEntryMap.values();
                for (Map<ActionDataID, ModifiableCustomActionInfo> map : collection) {
                    if (map.isEmpty()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        CustomKeyBindingSet customKeyBindingSet = (CustomKeyBindingSet)keyBindingSet;
        if (customKeyBindingSet.fParent.equals(this.fParent) && customKeyBindingSet.fGlobalMap.equals(this.fGlobalMap) && customKeyBindingSet.fContextEntryMap.keySet().equals(this.fContextEntryMap.keySet())) {
            for (ContextID contextID : this.fContextEntryMap.keySet()) {
                Map<ActionDataID, ModifiableCustomActionInfo> map = customKeyBindingSet.fContextEntryMap.get(contextID);
                Map<ActionDataID, ModifiableCustomActionInfo> map2 = this.fContextEntryMap.get(contextID);
                if (!map.keySet().equals(map2.keySet())) {
                    return false;
                }
                for (ActionDataID actionDataID : map2.keySet()) {
                    ModifiableCustomActionInfo modifiableCustomActionInfo = map.get(actionDataID);
                    ModifiableCustomActionInfo modifiableCustomActionInfo2 = map2.get(actionDataID);
                    if (modifiableCustomActionInfo.fFollowsGlobal == modifiableCustomActionInfo2.fFollowsGlobal && modifiableCustomActionInfo.fLocalBindings.equals(modifiableCustomActionInfo2.fLocalBindings)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public DefaultKeyBindingSet getParent() {
        return this.fParent;
    }

    Map<ActionData, List<KeyStrokeList>> getGlobalMap() {
        return Collections.unmodifiableMap(this.fGlobalMap);
    }

    Map<ContextID, Map<ActionDataID, CustomActionInfo>> getContextMap() {
        HashMap hashMap = new HashMap();
        for (ContextID contextID : this.fContextEntryMap.keySet()) {
            Map<ActionDataID, ModifiableCustomActionInfo> map = this.fContextEntryMap.get(contextID);
            HashMap<ActionDataID, ModifiableCustomActionInfo> hashMap2 = new HashMap<ActionDataID, ModifiableCustomActionInfo>();
            for (ActionDataID actionDataID : map.keySet()) {
                hashMap2.put(actionDataID, map.get(actionDataID).copy());
            }
            hashMap.put(contextID, hashMap2);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.add(new WeakReference<ChangeListener>(changeListener));
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Iterator<WeakReference<ChangeListener>> iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            ChangeListener changeListener2 = (ChangeListener)iterator.next().get();
            if (changeListener2 != null && changeListener2 != changeListener) continue;
            iterator.remove();
        }
    }

    private void fireChangeEvent() {
        if (!this.fEventFiringSuspended) {
            Iterator<WeakReference<ChangeListener>> iterator = this.fListeners.iterator();
            while (iterator.hasNext()) {
                ChangeListener changeListener = (ChangeListener)iterator.next().get();
                if (changeListener == null) {
                    iterator.remove();
                    continue;
                }
                changeListener.setChanged();
            }
        } else {
            this.fEventFiredWhileListenersSuspended = true;
        }
    }

    public void suspendEventFiring() {
        this.fEventFiringSuspended = true;
    }

    public void resumeEventFiring() {
        this.fEventFiringSuspended = false;
        if (this.fEventFiredWhileListenersSuspended) {
            this.fireChangeEvent();
            this.fEventFiredWhileListenersSuspended = false;
        }
    }

    public static interface ChangeListener {
        public void setChanged();
    }

    private static class ModifiableCustomActionInfo
    extends CustomActionInfo {
        private ModifiableCustomActionInfo(boolean bl, List<KeyStrokeList> list) {
            this.fFollowsGlobal = bl;
            if (list != null) {
                this.fLocalBindings = new LinkedList();
                for (KeyStrokeList keyStrokeList : list) {
                    this.addBindingAndEquivalentVariations(keyStrokeList);
                }
            }
        }

        private ModifiableCustomActionInfo copy() {
            return new ModifiableCustomActionInfo(this.isFollowingGlobal(), new LinkedList<KeyStrokeList>(this.fLocalBindings));
        }

        private void setFollowsGlobal(boolean bl) {
            this.fFollowsGlobal = bl;
        }

        private void addBindingAndEquivalentVariations(KeyStrokeList keyStrokeList) {
            KeyStrokeUtils.addAllBindingVariations(keyStrokeList, this.fLocalBindings);
        }
    }
}

