/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

public class MJTransferable
implements Transferable {
    protected Object fData = null;
    protected DataFlavor fDataFlavor = null;
    private static final Transferable[] EMPTY_TRANSFERABLE = new Transferable[0];

    public MJTransferable(Object object, DataFlavor dataFlavor) {
        this.fData = object;
        this.fDataFlavor = dataFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!dataFlavor.match(this.fDataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.fData;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.match(this.fDataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.fDataFlavor};
    }

    public static Transferable getCombinedTransferable(Transferable[] transferableArray) {
        return new CompoundTransferable(transferableArray);
    }

    private static class CompoundTransferable
    implements Transferable {
        private Transferable[] fTransferable = null;

        private CompoundTransferable(Transferable[] transferableArray) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            if (transferableArray != null) {
                for (int i = 0; i != transferableArray.length; ++i) {
                    if (transferableArray[i] == null) continue;
                    arrayList.add(transferableArray[i]);
                }
            }
            this.fTransferable = arrayList.toArray(EMPTY_TRANSFERABLE);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Object object = null;
            boolean bl = false;
            for (int i = this.fTransferable.length - 1; i >= 0; --i) {
                if (!this.fTransferable[i].isDataFlavorSupported(dataFlavor)) continue;
                object = this.fTransferable[i].getTransferData(dataFlavor);
                bl = true;
            }
            if (!bl) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return object;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = false;
            for (int i = 0; i < this.fTransferable.length; ++i) {
                bl |= this.fTransferable[i].isDataFlavorSupported(dataFlavor);
            }
            return bl;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            int n;
            DataFlavor[] dataFlavorArray;
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            for (int i = 0; i < this.fTransferable.length; ++i) {
                dataFlavorArray = this.fTransferable[i].getTransferDataFlavors();
                for (n = 0; n < dataFlavorArray.length; ++n) {
                    arrayList.add(dataFlavorArray[n]);
                }
            }
            Object[] objectArray = arrayList.toArray();
            dataFlavorArray = new DataFlavor[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                dataFlavorArray[n] = (DataFlavor)objectArray[n];
            }
            return dataFlavorArray;
        }
    }
}

