/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class MWMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private MouseListener fMouseListener;
    private MouseMotionListener fMouseMotionListener;
    private boolean fDragging = false;
    private boolean fDragAndDropEnabled = true;
    private MouseEvent fLastMousePressedEvent = null;
    protected static final int fMotionThreshold = MWMouseDragGestureRecognizer.getMotionThreshold();
    protected static final int BUTTON_MASK = 28;
    private boolean fDoubleClickInProgress = false;
    private boolean fTripleClickInProgress = false;
    private int fOriginalSelDot;
    private int fOriginalSelMark;
    private boolean fMousePressed = false;

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 5;
        }
    }

    public MWMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        super(dragSource, component, n, dragGestureListener);
        this.setForwardingListener(mouseListener, mouseMotionListener, component);
    }

    public void setForwardingListener(MouseListener mouseListener, MouseMotionListener mouseMotionListener, Component component) {
        this.fMouseListener = mouseListener;
        this.fMouseMotionListener = mouseMotionListener;
        component.removeMouseListener(mouseListener);
        component.removeMouseMotionListener(mouseMotionListener);
    }

    public void enableDragAndDrop(boolean bl) {
        this.fDragAndDropEnabled = bl;
    }

    public boolean isDragAndDropEnabled() {
        return this.fDragAndDropEnabled;
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        int n2 = n & 0x1C;
        if (!this.isDragAndDropEnabled()) {
            return 0;
        }
        if (!(n2 == 16 || n2 == 8 || n2 == 4 || PlatformInfo.isMacintosh() && n2 == 24)) {
            return 0;
        }
        if (this.isClickInSelection(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() != 3) {
            return MWMouseDragGestureRecognizer.convertModifiersToDropAction(n, this.getSourceActions());
        }
        return 0;
    }

    public static int convertModifiersToDropAction(int n, int n2) {
        int n3 = 0;
        switch (n & 3) {
            case 3: {
                n3 = 0x40000000;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            default: {
                if ((n2 & 2) != 0) {
                    n3 = 2;
                    break;
                }
                if ((n2 & 1) != 0) {
                    n3 = 1;
                    break;
                }
                if ((n2 & 0x40000000) == 0) break;
                n3 = 0x40000000;
            }
        }
        return n3 & n2;
    }

    public abstract boolean isClickInSelection(MouseEvent var1);

    public abstract boolean doSelectWordAction(MouseEvent var1);

    public abstract boolean doSelectLineAction(MouseEvent var1);

    public abstract int getOffsetFromEvent(MouseEvent var1);

    public abstract int getWordStart(Object var1, int var2);

    public abstract int getWordEnd(Object var1, int var2);

    public abstract int getLineStart(Object var1, int var2);

    public abstract int getLineEnd(Object var1, int var2);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.fMouseListener.mouseClicked(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fMousePressed = true;
        this.fDragging = false;
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.fLastMousePressedEvent = mouseEvent;
            this.appendEvent(mouseEvent);
        } else {
            this.fLastMousePressedEvent = null;
            this.fMouseListener.mousePressed(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    if (this.doSelectWordAction(mouseEvent)) {
                        this.fDoubleClickInProgress = true;
                        this.fOriginalSelDot = ((JTextComponent)mouseEvent.getSource()).getCaret().getDot();
                        this.fOriginalSelMark = ((JTextComponent)mouseEvent.getSource()).getCaret().getMark();
                    }
                } else if (mouseEvent.getClickCount() == 3 && this.doSelectLineAction(mouseEvent)) {
                    this.fTripleClickInProgress = true;
                    this.fOriginalSelDot = ((JTextComponent)mouseEvent.getSource()).getCaret().getDot();
                    this.fOriginalSelMark = ((JTextComponent)mouseEvent.getSource()).getCaret().getMark();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fMousePressed = false;
        this.fDoubleClickInProgress = false;
        this.fTripleClickInProgress = false;
        if (!this.events.isEmpty()) {
            Component component;
            this.events.clear();
            this.fDragging = false;
            if (this.isClickInSelection(mouseEvent) && (component = (Component)mouseEvent.getSource()) instanceof JTextComponent) {
                if (this.fLastMousePressedEvent != null) {
                    this.fMouseListener.mousePressed(this.fLastMousePressedEvent);
                    this.fLastMousePressedEvent = null;
                } else {
                    this.fMouseListener.mousePressed(mouseEvent);
                }
                this.fMouseListener.mouseReleased(mouseEvent);
            }
        } else {
            this.fMouseListener.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
        this.fMouseListener.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        int n;
        this.fMouseListener.mouseExited(mouseEvent);
        if (!this.events.isEmpty() && (n = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            this.fDragging = true;
            int n = this.mapDragOperationFromModifiers((MouseEvent)this.events.get(0));
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            if (n2 > fMotionThreshold || n3 > fMotionThreshold) {
                if (n != 0) {
                    this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
                }
            } else {
                this.appendEvent(mouseEvent);
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && (this.fDoubleClickInProgress || this.fTripleClickInProgress) && mouseEvent.getSource() instanceof JTextComponent) {
            int n = this.getOffsetFromEvent(mouseEvent);
            if (n < 0) {
                n = 0;
            }
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            int n4 = this.fDoubleClickInProgress ? this.getWordStart(mouseEvent.getSource(), n) : this.getLineStart(mouseEvent.getSource(), n);
            int n5 = this.fDoubleClickInProgress ? this.getWordEnd(mouseEvent.getSource(), n) : this.getLineEnd(mouseEvent.getSource(), n);
            int n6 = jTextComponent.getCaret().getMark();
            int n7 = jTextComponent.getCaret().getDot();
            if ((n = n <= n5 && n <= n6 ? n4 : n5) < this.fOriginalSelDot && n6 <= n7) {
                jTextComponent.getCaret().setDot(this.fOriginalSelDot);
            } else if (n > this.fOriginalSelMark && n7 <= n6) {
                jTextComponent.getCaret().setDot(this.fOriginalSelMark);
            }
            jTextComponent.getCaret().moveDot(n);
        } else if (!this.fDragging && this.fMousePressed) {
            this.fMouseMotionListener.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.fMouseMotionListener.mouseMoved(mouseEvent);
    }
}

