/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.dialog;

import com.mathworks.mwswing.MJFileChooser;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.NativeDialogLauncher;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class MJFolderChooser
implements NativeDialogLauncher {
    private final Component fComponent;
    private final EventListenerList fListeners;
    private File fDirectory;
    private String fSelectedFolder;
    private final String fTitle;
    private boolean fUseJava = false;
    private static final BrowseDialogDelegate DEFAULT_BROWSE_DIALOG_DELEGATE;
    private static BrowseDialogDelegate sBrowseDialogDelegate;

    public static synchronized void browseForFolder(Component component, String string, ActionListener actionListener) {
        MJFolderChooser.browseForFolder(component, string, actionListener, null);
    }

    public static synchronized void browseForFolder(Component component, String string, ActionListener actionListener, File file) {
        if (!PlatformInfo.isWindows()) {
            string = MJUtilities.intlString("dialog.MJFolderChooser.Title");
        }
        MJFolderChooser mJFolderChooser = new MJFolderChooser(component, string);
        mJFolderChooser.addActionListener(actionListener);
        mJFolderChooser.setInitialDirectory(file);
        mJFolderChooser.browse();
    }

    public MJFolderChooser(Component component, String string) {
        this.fComponent = component;
        this.fTitle = string;
        this.fListeners = new EventListenerList();
    }

    public void setUseJavaDialogs(boolean bl) {
        this.fUseJava = bl;
    }

    public void setInitialDirectory(File file) {
        this.fDirectory = file;
    }

    public File getInitialDirectory() {
        return this.fDirectory;
    }

    @Override
    public String getDialogTitle() {
        return this.fTitle;
    }

    private String getSelectedFolder() {
        return this.fSelectedFolder;
    }

    public void setSelectedFolder(String string) {
        this.fSelectedFolder = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.fListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fListeners.remove(ActionListener.class, actionListener);
    }

    @Override
    public void dialogClosed() {
        this.dialogClosed(this.getSelectedFolder());
    }

    private void dialogClosed(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        if (string != null) {
            this.fireActionPerformed(actionEvent);
        } else {
            this.fireDialogCancelled(actionEvent);
        }
    }

    private void fireActionPerformed(final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = MJFolderChooser.this.fListeners.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != ActionListener.class) continue;
                    ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
                }
            }
        });
    }

    public void addCancellationListener(CancellationListener cancellationListener) {
        this.fListeners.add(CancellationListener.class, cancellationListener);
    }

    public void removeCancellationListener(CancellationListener cancellationListener) {
        this.fListeners.remove(CancellationListener.class, cancellationListener);
    }

    private void fireDialogCancelled(final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = MJFolderChooser.this.fListeners.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != CancellationListener.class) continue;
                    ((CancellationListener)objectArray[i + 1]).dialogCancelled(actionEvent);
                }
            }
        });
    }

    public void browse() {
        MJFolderChooser.getBrowseDialogDelegate().browse(this);
    }

    public static void restoreBrowseDialogDelegate() {
        MJFolderChooser.setBrowseDialogDelegate(DEFAULT_BROWSE_DIALOG_DELEGATE);
    }

    public static boolean isDefaultBrowseDialogDelegateApplied() {
        return MJFolderChooser.getBrowseDialogDelegate() == DEFAULT_BROWSE_DIALOG_DELEGATE;
    }

    private static BrowseDialogDelegate getBrowseDialogDelegate() {
        return sBrowseDialogDelegate;
    }

    public static void setBrowseDialogDelegate(BrowseDialogDelegate browseDialogDelegate) {
        sBrowseDialogDelegate = browseDialogDelegate;
    }

    public void browseAsynchronously() {
        if (PlatformInfo.isUnix()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJFolderChooser.this.browse();
                }
            });
        } else {
            this.browse();
        }
    }

    private Runnable createNativeFolderBrowserRunnable() {
        return new NativeFolderBrowser();
    }

    private void javaFolderBrowse() {
        MJFileChooser mJFileChooser = new MJFileChooser(this.fDirectory != null ? this.fDirectory.getAbsolutePath() : FactoryUtils.getDirectorySeed());
        mJFileChooser.setDialogTitle(this.fTitle);
        mJFileChooser.setFileHidingEnabled(false);
        mJFileChooser.setFileSelectionMode(1);
        String string = null;
        if (!PlatformInfo.isMacintosh()) {
            mJFileChooser.setDialogType(2);
            string = MJUtilities.intlString("dialog.MJFolderChooser.OK");
        }
        if (mJFileChooser.showDialog(this.fComponent, string) == 0) {
            this.setSelectedFolder(mJFileChooser.getSelectedFile().getAbsolutePath());
        } else {
            this.setSelectedFolder(null);
        }
        this.dialogClosed();
    }

    static {
        sBrowseDialogDelegate = DEFAULT_BROWSE_DIALOG_DELEGATE = new BrowseDialogDelegateImpl();
    }

    private class NativeFolderBrowser
    implements Runnable {
        private NativeFolderBrowser() {
        }

        @Override
        public void run() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            MJFolderChooser.this.setSelectedFolder(NativeJava.nativeBrowseForFolder((Component)MJFolderChooser.this.fComponent, (String)MJFolderChooser.this.fTitle, (File)MJFolderChooser.this.fDirectory));
            MJFolderChooser.this.dialogClosed();
            if (component != null) {
                component.requestFocusInWindow();
            }
        }
    }

    private static class BrowseDialogDelegateImpl
    implements BrowseDialogDelegate {
        private BrowseDialogDelegateImpl() {
        }

        @Override
        public void browse(MJFolderChooser mJFolderChooser) {
            if ((PlatformInfo.isMacintosh() || PlatformInfo.isWindows()) & !mJFolderChooser.fUseJava) {
                new Thread(mJFolderChooser.createNativeFolderBrowserRunnable()).start();
            } else {
                mJFolderChooser.javaFolderBrowse();
            }
        }
    }

    public static interface BrowseDialogDelegate {
        public void browse(MJFolderChooser var1);
    }

    public static interface CancellationListener
    extends EventListener {
        public void dialogCancelled(ActionEvent var1);
    }
}

