/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.undo;

import com.mathworks.mwswing.api.DirtyStateChangeListener;
import com.mathworks.mwswing.api.ExtendedUndoManager;
import com.mathworks.mwswing.api.UndoListener;
import com.mathworks.mwswing.api.UndoabilityChangeListener;
import com.mathworks.mwswing.undo.BeforeModificationEdit;
import com.mathworks.mwswing.undo.CleanMarkerEdit;
import com.mathworks.mwswing.undo.UndoManagerListener;
import java.util.List;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MUndoManager
extends UndoManager
implements ExtendedUndoManager {
    private List<UndoabilityChangeListener> fUndoabilityChangeListeners = new Vector<UndoabilityChangeListener>();
    private List<DirtyStateChangeListener> fDirtyStateChangeListeners = new Vector<DirtyStateChangeListener>();
    private final List<UndoListener> fUndoListeners = new Vector<UndoListener>();
    private volatile boolean fIsClean = true;
    private boolean fCanUndo = false;
    private boolean fCanRedo = false;
    private UndoableEdit fCurrentSaveEdit = null;
    private UndoableEdit fCurrentBeforeModEdit = null;
    private boolean fDirtyFlag = false;

    public MUndoManager() {
        this.undoableEditHappened(new UndoableEditEvent(this, new CleanMarkerEdit(this)));
    }

    public void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.addUndoabilityChangeListener(undoManagerListener);
        this.addDirtyStateChangeListener(undoManagerListener);
    }

    public void removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.removeUndoabilityChangeListener(undoManagerListener);
        this.removeDirtyStateChangeListener(undoManagerListener);
    }

    @Override
    public void addUndoListener(UndoListener undoListener) {
        if (undoListener == null) {
            throw new IllegalArgumentException("UndoListener cannot be null.");
        }
        this.fUndoListeners.add(undoListener);
    }

    @Override
    public void removeUndoListener(UndoListener undoListener) {
        this.fUndoListeners.remove(undoListener);
    }

    @Override
    public void addUndoabilityChangeListener(UndoabilityChangeListener undoabilityChangeListener) {
        if (undoabilityChangeListener == null) {
            throw new IllegalArgumentException("UndoabilityChangeListener cannot be null.");
        }
        this.fUndoabilityChangeListeners.add(undoabilityChangeListener);
    }

    @Override
    public void removeUndoabilityChangeListener(UndoabilityChangeListener undoabilityChangeListener) {
        this.fUndoabilityChangeListeners.remove(undoabilityChangeListener);
    }

    @Override
    public void addDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        if (dirtyStateChangeListener == null) {
            throw new IllegalArgumentException("DirtyStateChangeListener cannot be null.");
        }
        this.fDirtyStateChangeListeners.add(dirtyStateChangeListener);
    }

    @Override
    public void removeDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        this.fDirtyStateChangeListeners.remove(dirtyStateChangeListener);
    }

    @Override
    public synchronized void setCleanMarker() {
        this.fDirtyFlag = false;
        CleanMarkerEdit cleanMarkerEdit = new CleanMarkerEdit(this);
        UndoableEdit undoableEdit = this.editToBeRedone();
        UndoableEdit undoableEdit2 = this.editToBeUndone();
        if (undoableEdit != null && (undoableEdit2 != null || this.edits.indexOf(undoableEdit) > 0 && this.edits.get(this.edits.indexOf(undoableEdit) - 1) instanceof CleanMarkerEdit)) {
            int n = this.edits.indexOf(undoableEdit);
            if (undoableEdit2 != null) {
                cleanMarkerEdit.replaceEdit(undoableEdit2);
                int n2 = this.edits.indexOf(undoableEdit2);
                this.edits.remove(n2);
                this.edits.insertElementAt(cleanMarkerEdit, n2);
            } else {
                this.edits.remove(n - 1);
                this.edits.insertElementAt(cleanMarkerEdit, n - 1);
            }
            this.edits.remove(n);
            this.edits.insertElementAt(new BeforeModificationEdit(this, undoableEdit), n);
        } else {
            this.undoableEditHappened(new UndoableEditEvent(this, cleanMarkerEdit));
        }
        this.cleanStatusChanged(true, cleanMarkerEdit);
        this.checkUndoRedoStatus();
    }

    @Override
    public synchronized void setDirtyMarker() {
        if (this.isClean()) {
            this.cleanStatusChanged(false, null);
        }
        this.fDirtyFlag = true;
    }

    public boolean isClean() {
        return this.fIsClean;
    }

    @Override
    public boolean isDirty() {
        return !this.fIsClean;
    }

    @Override
    public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        boolean bl = false;
        if (!(undoableEditEvent.getEdit() instanceof CleanMarkerEdit) && this.isClean()) {
            bl = true;
        }
        super.undoableEditHappened(undoableEditEvent);
        if (bl) {
            this.cleanStatusChanged(false, null);
        }
        this.checkUndoRedoStatus();
    }

    @Override
    public synchronized void undo() {
        super.undo();
        this.checkUndoRedoStatus();
        this.fireUndo();
    }

    @Override
    public synchronized void redo() {
        super.redo();
        this.checkUndoRedoStatus();
        this.fireRedo();
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, new CleanMarkerEdit(this));
        this.undoableEditHappened(undoableEditEvent);
        this.cleanStatusChanged(true, undoableEditEvent.getEdit());
        this.checkUndoRedoStatus();
    }

    void cleanStatusChanged(boolean bl, UndoableEdit undoableEdit) {
        if (!(this.fDirtyFlag || undoableEdit != null && undoableEdit != this.getCurrentSaveEdit() && undoableEdit != this.getCurrentBeforeModEdit())) {
            this.fIsClean = bl;
            this.fireCleanStateChanged(this.fIsClean);
        }
    }

    private void checkUndoRedoStatus() {
        if (this.fCanRedo != this.canRedo()) {
            this.fCanRedo = this.canRedo();
            this.fireRedoabilityChanged(this.fCanRedo);
        }
        if (this.fCanUndo != this.canUndo()) {
            this.fCanUndo = this.canUndo();
            this.fireUndoabilityChanged(this.fCanUndo);
        }
    }

    private void fireUndo() {
        Vector<UndoListener> vector = new Vector<UndoListener>(this.fUndoListeners);
        for (UndoListener undoListener : vector) {
            undoListener.undo();
        }
    }

    private void fireRedo() {
        Vector<UndoListener> vector = new Vector<UndoListener>(this.fUndoListeners);
        for (UndoListener undoListener : vector) {
            undoListener.redo();
        }
    }

    private void fireUndoabilityChanged(boolean bl) {
        Vector<UndoabilityChangeListener> vector = new Vector<UndoabilityChangeListener>(this.fUndoabilityChangeListeners);
        for (UndoabilityChangeListener undoabilityChangeListener : vector) {
            undoabilityChangeListener.undoabilityChanged(bl);
        }
    }

    private void fireRedoabilityChanged(boolean bl) {
        Vector<UndoabilityChangeListener> vector = new Vector<UndoabilityChangeListener>(this.fUndoabilityChangeListeners);
        for (UndoabilityChangeListener undoabilityChangeListener : vector) {
            undoabilityChangeListener.redoabilityChanged(bl);
        }
    }

    private void fireCleanStateChanged(boolean bl) {
        Vector<DirtyStateChangeListener> vector = new Vector<DirtyStateChangeListener>(this.fDirtyStateChangeListeners);
        for (DirtyStateChangeListener dirtyStateChangeListener : vector) {
            dirtyStateChangeListener.dirtyStateChanged(!bl);
        }
    }

    UndoableEdit getCurrentSaveEdit() {
        return this.fCurrentSaveEdit;
    }

    void setCurrentSaveEdit(UndoableEdit undoableEdit) {
        this.fCurrentSaveEdit = undoableEdit;
    }

    UndoableEdit getCurrentBeforeModEdit() {
        return this.fCurrentBeforeModEdit;
    }

    void setCurrentBeforeModEdit(UndoableEdit undoableEdit) {
        this.fCurrentBeforeModEdit = undoableEdit;
    }
}

