/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.io.DataInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PNGChunk {
    int length;
    int type;
    byte[] data;
    int crc;
    String typeString;
    protected static Log log = LogFactory.getLog(PNGChunk.class);

    public PNGChunk(int n, int n2, byte[] byArray, int n3) {
        this.length = n;
        this.type = n2;
        this.data = byArray;
        this.crc = n3;
        this.typeString = PNGChunk.typeIntToString(this.type);
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public int getInt1(int n) {
        return this.data[n] & 0xFF;
    }

    public int getInt2(int n) {
        return (this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF;
    }

    public int getInt4(int n) {
        return (this.data[n] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF;
    }

    public String getString4(int n) {
        return "" + (char)this.data[n] + (char)this.data[n + 1] + (char)this.data[n + 2] + (char)this.data[n + 3];
    }

    public boolean isType(String string) {
        return this.typeString.equals(string);
    }

    public static PNGChunk readChunk(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            int n3 = dataInputStream.readInt();
            return new PNGChunk(n, n2, byArray, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getChunkType(DataInputStream dataInputStream) {
        try {
            dataInputStream.mark(8);
            dataInputStream.readInt();
            int n = dataInputStream.readInt();
            dataInputStream.reset();
            return PNGChunk.typeIntToString(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String typeIntToString(int n) {
        String string = "";
        string = string + (char)(n >> 24);
        string = string + (char)(n >> 16 & 0xFF);
        string = string + (char)(n >> 8 & 0xFF);
        string = string + (char)(n & 0xFF);
        return string;
    }

    public static boolean skipChunk(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.skipBytes(n);
            int n4 = dataInputStream.readInt();
            if (n3 != n) {
                log.warn((Object)"Incorrect number of bytes skipped.");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage());
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChunkType {
        IHDR,
        PLTE,
        IDAT,
        IEND,
        bKGD,
        cHRM,
        gAMA,
        hIST,
        iCCP,
        iTXt,
        pHYs,
        sBIT,
        sPLT,
        sRGB,
        sTER,
        tEXt,
        tIME,
        tRNS,
        zTXt;

    }
}

