/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.cache.DefaultExpirationPolicy;
import org.apache.xmlgraphics.image.loader.cache.ExpirationPolicy;
import org.apache.xmlgraphics.image.loader.cache.ImageCacheListener;
import org.apache.xmlgraphics.image.loader.cache.ImageKey;
import org.apache.xmlgraphics.image.loader.cache.TimeStampProvider;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public class ImageCache {
    protected static Log log = LogFactory.getLog(ImageCache.class);
    private Map invalidURIs = Collections.synchronizedMap(new HashMap());
    private ExpirationPolicy invalidURIExpirationPolicy;
    private SoftMapCache imageInfos = new SoftMapCache(true);
    private SoftMapCache images = new SoftMapCache(true);
    private ImageCacheListener cacheListener;
    private TimeStampProvider timeStampProvider;
    private long lastHouseKeeping;
    private static final long ONE_HOUR = 3600000L;

    public ImageCache() {
        this(new TimeStampProvider(), new DefaultExpirationPolicy());
    }

    public ImageCache(TimeStampProvider timeStampProvider, ExpirationPolicy expirationPolicy) {
        this.timeStampProvider = timeStampProvider;
        this.invalidURIExpirationPolicy = expirationPolicy;
        this.lastHouseKeeping = this.timeStampProvider.getTimeStamp();
    }

    public void setCacheListener(ImageCacheListener imageCacheListener) {
        this.cacheListener = imageCacheListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo needImageInfo(String string, ImageSessionContext imageSessionContext, ImageManager imageManager) throws ImageException, IOException {
        String string2;
        if (this.isInvalidURI(string)) {
            throw new FileNotFoundException("Image not found: " + string);
        }
        String string3 = string2 = string.intern();
        synchronized (string3) {
            ImageInfo imageInfo = this.getImageInfo(string);
            if (imageInfo == null) {
                try {
                    Source source = imageSessionContext.needSource(string);
                    if (source == null) {
                        this.registerInvalidURI(string);
                        throw new FileNotFoundException("Image not found: " + string);
                    }
                    imageInfo = imageManager.preloadImage(string, source);
                    imageSessionContext.returnSource(string, source);
                }
                catch (IOException iOException) {
                    this.registerInvalidURI(string);
                    throw iOException;
                }
                catch (ImageException imageException) {
                    this.registerInvalidURI(string);
                    throw imageException;
                }
                this.putImageInfo(imageInfo);
            }
            return imageInfo;
        }
    }

    public boolean isInvalidURI(String string) {
        boolean bl = this.removeInvalidURIIfExpired(string);
        if (bl) {
            return false;
        }
        if (this.cacheListener != null) {
            this.cacheListener.invalidHit(string);
        }
        return true;
    }

    private boolean removeInvalidURIIfExpired(String string) {
        boolean bl;
        Long l = (Long)this.invalidURIs.get(string);
        boolean bl2 = bl = l == null || this.invalidURIExpirationPolicy.isExpired(this.timeStampProvider, l);
        if (bl) {
            this.invalidURIs.remove(string);
        }
        return bl;
    }

    protected ImageInfo getImageInfo(String string) {
        ImageInfo imageInfo = (ImageInfo)this.imageInfos.get(string);
        if (this.cacheListener != null) {
            if (imageInfo != null) {
                this.cacheListener.cacheHitImageInfo(string);
            } else if (!this.isInvalidURI(string)) {
                this.cacheListener.cacheMissImageInfo(string);
            }
        }
        return imageInfo;
    }

    protected void putImageInfo(ImageInfo imageInfo) {
        this.imageInfos.put(imageInfo.getOriginalURI(), imageInfo);
    }

    void registerInvalidURI(String string) {
        this.invalidURIs.put(string, new Long(this.timeStampProvider.getTimeStamp()));
        this.considerHouseKeeping();
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor imageFlavor) {
        return this.getImage(imageInfo.getOriginalURI(), imageFlavor);
    }

    public Image getImage(String string, ImageFlavor imageFlavor) {
        if (string == null || "".equals(string)) {
            return null;
        }
        ImageKey imageKey = new ImageKey(string, imageFlavor);
        Image image = (Image)this.images.get(imageKey);
        if (this.cacheListener != null) {
            if (image != null) {
                this.cacheListener.cacheHitImage(imageKey);
            } else {
                this.cacheListener.cacheMissImage(imageKey);
            }
        }
        return image;
    }

    public void putImage(Image image) {
        String string = image.getInfo().getOriginalURI();
        if (string == null || "".equals(string)) {
            return;
        }
        if (!image.isCacheable()) {
            throw new IllegalArgumentException("Image is not cacheable! (Flavor: " + image.getFlavor() + ")");
        }
        ImageKey imageKey = new ImageKey(string, image.getFlavor());
        this.images.put(imageKey, image);
    }

    public void clearCache() {
        this.invalidURIs.clear();
        this.imageInfos.clear();
        this.images.clear();
        this.doHouseKeeping();
    }

    private void considerHouseKeeping() {
        long l = this.timeStampProvider.getTimeStamp();
        if (this.lastHouseKeeping + 3600000L > l) {
            this.lastHouseKeeping = l;
            this.doHouseKeeping();
        }
    }

    public void doHouseKeeping() {
        this.imageInfos.doHouseKeeping();
        this.images.doHouseKeeping();
        this.doInvalidURIHouseKeeping();
    }

    private void doInvalidURIHouseKeeping() {
        HashSet hashSet = new HashSet(this.invalidURIs.keySet());
        for (String string : hashSet) {
            this.removeInvalidURIIfExpired(string);
        }
    }
}

