/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImage;
import org.apache.xmlgraphics.image.codec.util.ImageInputStreamSeekableStreamAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageLoaderInternalTIFF
extends AbstractImageLoader {
    protected static Log log = LogFactory.getLog(ImageLoaderInternalTIFF.class);

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        Source source = imageSessionContext.needSource(imageInfo.getOriginalURI());
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        ImageInputStreamSeekableStreamAdapter imageInputStreamSeekableStreamAdapter = new ImageInputStreamSeekableStreamAdapter(imageInputStream);
        try {
            TIFFImage tIFFImage = new TIFFImage(imageInputStreamSeekableStreamAdapter, null, 0);
            return new ImageRendered(imageInfo, tIFFImage, null);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException("Could not load image with internal TIFF codec", runtimeException);
        }
    }

    public int getUsagePenalty() {
        return 1000;
    }
}

