/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.util.Service;

public class ImageWriterRegistry {
    private static ImageWriterRegistry instance;
    private Map imageWriterMap = new HashMap();
    private Map preferredOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageWriterRegistry() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("default-preferred-order.properties");
        if (inputStream != null) {
            try {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not load default preferred order due to I/O error: " + iOException.getMessage());
            }
        }
        this.preferredOrder = properties;
        this.setup();
    }

    public ImageWriterRegistry(Properties properties) {
        this.preferredOrder = properties;
        this.setup();
    }

    public static ImageWriterRegistry getInstance() {
        if (instance == null) {
            instance = new ImageWriterRegistry();
        }
        return instance;
    }

    private void setup() {
        Iterator<Object> iterator = Service.providers(ImageWriter.class);
        while (iterator.hasNext()) {
            ImageWriter imageWriter = (ImageWriter)iterator.next();
            this.register(imageWriter);
        }
    }

    private int getPriority(ImageWriter imageWriter) {
        int n;
        String string = imageWriter.getClass().getName();
        Object v = this.preferredOrder.get(string);
        while (v == null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
            v = this.preferredOrder.get(string);
        }
        return v != null ? Integer.parseInt(v.toString()) : 0;
    }

    public void register(ImageWriter imageWriter, int n) {
        String string = imageWriter.getClass().getName();
        this.preferredOrder.put(string, String.valueOf(n));
        this.register(imageWriter);
    }

    public void register(ImageWriter imageWriter) {
        ArrayList arrayList = (ArrayList)this.imageWriterMap.get(imageWriter.getMIMEType());
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.imageWriterMap.put(imageWriter.getMIMEType(), arrayList);
        }
        int n = this.getPriority(imageWriter);
        ListIterator<ImageWriter> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ImageWriter imageWriter2 = (ImageWriter)listIterator.next();
            if (this.getPriority(imageWriter2) >= n) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(imageWriter);
    }

    public ImageWriter getWriterFor(String string) {
        List list = (List)this.imageWriterMap.get(string);
        if (list == null) {
            return null;
        }
        for (ImageWriter imageWriter : list) {
            if (!imageWriter.isFunctional()) continue;
            return imageWriter;
        }
        return null;
    }
}

