/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.imageio;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.imageio.ImageIOImageWriter;

public class ImageIOTIFFImageWriter
extends ImageIOImageWriter {
    private static final String SUN_TIFF_NATIVE_FORMAT = "com_sun_media_imageio_plugins_tiff_image_1.0";

    public ImageIOTIFFImageWriter() {
        super("image/tiff");
    }

    protected IIOMetadata updateMetadata(IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        IIOMetadata iIOMetadata2 = super.updateMetadata(iIOMetadata, imageWriterParams);
        if (imageWriterParams.getResolution() != null && SUN_TIFF_NATIVE_FORMAT.equals(iIOMetadata.getNativeMetadataFormatName())) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(SUN_TIFF_NATIVE_FORMAT);
            IIOMetadataNode iIOMetadataNode2 = ImageIOTIFFImageWriter.getChildNode(iIOMetadataNode, "TIFFIFD");
            if (iIOMetadataNode2 == null) {
                iIOMetadataNode2 = new IIOMetadataNode("TIFFIFD");
                iIOMetadataNode2.setAttribute("tagSets", "com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2.appendChild(this.createResolutionField(282, "XResolution", imageWriterParams));
            iIOMetadataNode2.appendChild(this.createResolutionField(283, "YResolution", imageWriterParams));
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("TIFFField");
            iIOMetadataNode3.setAttribute("number", Integer.toString(296));
            iIOMetadataNode3.setAttribute("name", "ResolutionUnit");
            IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("TIFFShorts");
            iIOMetadataNode3.appendChild(iIOMetadataNode4);
            IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("TIFFShort");
            iIOMetadataNode5.setAttribute("value", Integer.toString(3));
            iIOMetadataNode5.setAttribute("description", "Centimeter");
            iIOMetadataNode4.appendChild(iIOMetadataNode5);
            try {
                iIOMetadata.mergeTree(SUN_TIFF_NATIVE_FORMAT, iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage(), iIOInvalidTreeException);
            }
        }
        return iIOMetadata2;
    }

    private IIOMetadataNode createResolutionField(int n, String string, ImageWriterParams imageWriterParams) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("TIFFField");
        iIOMetadataNode.setAttribute("number", Integer.toString(n));
        iIOMetadataNode.setAttribute("name", string);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFFRationals");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("TIFFRational");
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        float f = 25.4f / imageWriterParams.getResolution().floatValue();
        int n2 = (int)((double)(100000.0f / f) + 0.5);
        int n3 = 10000;
        iIOMetadataNode3.setAttribute("value", n2 + "/" + n3);
        return iIOMetadataNode;
    }
}

