/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.ps;

import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class PSTilingPattern {
    public static final int PATTERN_TYPE_TILING = 1;
    public static final int PATTERN_TYPE_SHADING = 2;
    protected int patternType = 1;
    protected String patternName = null;
    protected List xUID = null;
    protected StringBuffer paintProc = null;
    protected Rectangle2D bBox = null;
    protected double xStep = 0.0;
    protected double yStep = 0.0;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected TexturePaint texture = null;

    public PSTilingPattern(String string, StringBuffer stringBuffer, Rectangle rectangle, double d, double d2, int n, int n2, List list) {
        this.patternName = string;
        this.paintProc = stringBuffer;
        this.setBoundingBox(rectangle);
        this.setXStep(d);
        this.setYStep(d2);
        this.setPaintType(n);
        this.setTilingType(n2);
        this.xUID = list;
    }

    public PSTilingPattern(String string, TexturePaint texturePaint, double d, double d2, int n, List list) {
        this(string, null, new Rectangle(), 1.0, 1.0, 1, n, list);
        this.texture = texturePaint;
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        this.bBox = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        this.xStep = d == 0.0 ? rectangle2D.getWidth() : d;
        this.yStep = d2 == 0.0 ? rectangle2D.getHeight() : d2;
    }

    public String getName() {
        return this.patternName;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter patternName must not be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Parameter patternName must not be empty");
        }
        if (string.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Pattern name must not contain any spaces");
        }
        this.patternName = string;
    }

    public Rectangle2D getBoundingBox() {
        return this.bBox;
    }

    public void setBoundingBox(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new NullPointerException("Parameter bBox must not be null");
        }
        this.bBox = rectangle2D;
    }

    public StringBuffer getPaintProc() {
        return this.paintProc;
    }

    public void setPaintProc(StringBuffer stringBuffer) {
        this.paintProc = stringBuffer;
    }

    public double getXStep() {
        return this.xStep;
    }

    public void setXStep(double d) {
        if (d == 0.0) {
            throw new IllegalArgumentException("Parameter xStep must not be 0");
        }
        this.xStep = d;
    }

    public double getYStep() {
        return this.yStep;
    }

    public void setYStep(double d) {
        if (d == 0.0) {
            throw new IllegalArgumentException("Parameter yStep must not be 0");
        }
        this.yStep = d;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public void setPaintType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Parameter paintType must not be " + n + " (only 1 or 2)");
        }
        this.paintType = n;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public void setTilingType(int n) {
        if (n > 3 || n < 1) {
            throw new IllegalArgumentException("Parameter tilingType must not be " + n + " (only 1, 2 or 3)");
        }
        this.tilingType = n;
    }

    public TexturePaint getTexturePaint() {
        return this.texture;
    }

    public void setTexturePaint(TexturePaint texturePaint) {
        this.texture = texturePaint;
    }

    public List getXUID() {
        return this.xUID;
    }

    public void setXUID(List list) {
        this.xUID = list;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<<\n");
        stringBuffer.append("/PatternType " + this.patternType + "\n");
        stringBuffer.append("/PaintType " + this.paintType + "\n");
        stringBuffer.append("/TilingType " + this.tilingType + "\n");
        stringBuffer.append("/XStep " + this.xStep + "\n");
        stringBuffer.append("/YStep " + this.yStep + "\n");
        stringBuffer.append("/BBox [" + this.bBox.getX() + " " + this.bBox.getY() + " " + this.bBox.getWidth() + " " + this.bBox.getHeight() + "]" + "\n");
        stringBuffer.append("/PaintProc\n{\n");
        if (this.paintProc == null || this.paintProc.indexOf("pop") != 0) {
            stringBuffer.append("pop\n");
        }
        if (this.texture != null) {
            int n = this.texture.getImage().getWidth();
            int n2 = this.texture.getImage().getHeight();
            Rectangle2D rectangle2D = this.texture.getAnchorRect();
            if (rectangle2D.getX() != 0.0 || rectangle2D.getY() != 0.0) {
                stringBuffer.append(rectangle2D.getX() + " " + rectangle2D.getY() + " translate\n");
            }
            double d = rectangle2D.getWidth() / (double)n;
            double d2 = rectangle2D.getHeight() / (double)n2;
            if (d != 1.0 || d2 != 1.0) {
                stringBuffer.append(d + " " + d2 + " scale\n");
            }
            stringBuffer.append(n + " " + n2 + " 8 " + "matrix\n");
            int[] nArray = new int[n * n2];
            stringBuffer.append("{<");
            this.texture.getImage().getRGB(0, 0, n, n2, nArray, 0, n);
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                StringBuffer stringBuffer2;
                if (i % n == 0 || n3 > 249) {
                    stringBuffer.append("\n");
                    n3 = 0;
                }
                if ((stringBuffer2 = new StringBuffer(Integer.toHexString(nArray[i] & 0xFFFFFF))).length() != 6) {
                    stringBuffer2.insert(0, "000000");
                    stringBuffer2 = new StringBuffer(stringBuffer2.substring(stringBuffer2.length() - 6));
                }
                stringBuffer.append(stringBuffer2);
                n3 += 6;
            }
            stringBuffer.append("\n>} false 3 colorimage");
        } else {
            stringBuffer.append(this.paintProc);
        }
        stringBuffer.append("\n} bind \n");
        stringBuffer.append(">>\n");
        stringBuffer.append("matrix\n");
        stringBuffer.append("makepattern\n");
        stringBuffer.append("/" + this.patternName + " exch def\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return 0 ^ this.patternType ^ (this.xUID != null ? this.xUID.hashCode() : 0) ^ (this.paintProc != null ? this.paintProc.hashCode() : 0) ^ (this.bBox != null ? this.bBox.hashCode() : 0) ^ new Double(this.xStep).hashCode() ^ new Double(this.yStep).hashCode() ^ this.paintType ^ this.tilingType ^ (this.texture != null ? this.texture.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PSTilingPattern)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        PSTilingPattern pSTilingPattern = (PSTilingPattern)object;
        if (this.patternType != pSTilingPattern.patternType) {
            return false;
        }
        TexturePaint texturePaint = pSTilingPattern.getTexturePaint();
        if (texturePaint == null && this.texture != null || texturePaint != null && this.texture == null) {
            return false;
        }
        if (texturePaint != null && this.texture != null) {
            int n = this.texture.getImage().getWidth();
            int n2 = this.texture.getImage().getHeight();
            int n3 = texturePaint.getImage().getWidth();
            int n4 = texturePaint.getImage().getHeight();
            if (n != n3) {
                return false;
            }
            if (n2 != n4) {
                return false;
            }
            int[] nArray = new int[n * n2];
            int[] nArray2 = new int[n3 * n4];
            this.texture.getImage().getRGB(0, 0, n, n2, nArray, 0, n);
            texturePaint.getImage().getRGB(0, 0, n3, n4, nArray2, 0, n3);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
        } else if (!this.paintProc.toString().equals(pSTilingPattern.getPaintProc().toString())) {
            return false;
        }
        if (this.xStep != pSTilingPattern.getXStep()) {
            return false;
        }
        if (this.yStep != pSTilingPattern.getYStep()) {
            return false;
        }
        if (this.paintType != pSTilingPattern.getPaintType()) {
            return false;
        }
        if (this.tilingType != pSTilingPattern.getTilingType()) {
            return false;
        }
        if (!this.bBox.equals(pSTilingPattern.getBoundingBox())) {
            return false;
        }
        return this.xUID == null || pSTilingPattern.getXUID() == null || this.xUID.equals(pSTilingPattern.getXUID());
    }
}

