/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

public final class DoubleFormatUtil {
    private static final long[] POWERS_OF_TEN_LONG;
    private static final double[] POWERS_OF_TEN_DOUBLE;

    private DoubleFormatUtil() {
    }

    public static void formatDouble(double d, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = n3 = Math.abs(d) >= 1.0 ? n : n2;
        if (DoubleFormatUtil.tooManyDigitsUsed(d, n3) || DoubleFormatUtil.tooCloseToRound(d, n3)) {
            DoubleFormatUtil.formatDoublePrecise(d, n, n2, stringBuffer);
        } else {
            DoubleFormatUtil.formatDoubleFast(d, n, n2, stringBuffer);
        }
    }

    public static void formatDoublePrecise(double d, int n, int n2, StringBuffer stringBuffer) {
        boolean bl;
        if (DoubleFormatUtil.isRoundedToZero(d, n, n2)) {
            stringBuffer.append('0');
            return;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            stringBuffer.append(Double.toString(d));
            return;
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
            stringBuffer.append('-');
        }
        int n3 = d >= 1.0 ? n : n2;
        String string = Double.toString(d);
        if (d >= 0.001 && d < 1.0E7) {
            int n4 = string.indexOf(46);
            String string2 = string.substring(n4 + 1);
            int n5 = string2.length();
            if (n3 >= n5) {
                if ("0".equals(string2)) {
                    stringBuffer.append(string.substring(0, n4));
                } else {
                    stringBuffer.append(string);
                    for (int i = stringBuffer.length() - 1; i >= 0 && stringBuffer.charAt(i) == '0'; --i) {
                        stringBuffer.setLength(i);
                    }
                }
                return;
            }
            if (n3 + 1 < n5) {
                n5 = n3 + 1;
                string2 = string2.substring(0, n5);
            }
            long l = Long.parseLong(string.substring(0, n4));
            long l2 = Long.parseLong(string2);
            DoubleFormatUtil.format(stringBuffer, n3, l, l2);
        } else {
            int n6 = string.indexOf(46);
            assert (n6 >= 0);
            int n7 = string.indexOf(69);
            assert (n7 >= 0);
            int n8 = Integer.parseInt(string.substring(n7 + 1));
            String string3 = string.substring(0, n6);
            String string4 = string.substring(n6 + 1, n7);
            int n9 = string4.length();
            if (n8 >= 0) {
                int n10 = n9 - n8;
                if (n10 <= 0) {
                    stringBuffer.append(string3);
                    stringBuffer.append(string4);
                    for (int i = -n10; i > 0; --i) {
                        stringBuffer.append('0');
                    }
                } else if (n10 <= n3) {
                    stringBuffer.append(string3);
                    stringBuffer.append(string4.substring(0, n8));
                    stringBuffer.append('.');
                    stringBuffer.append(string4.substring(n8));
                } else {
                    long l = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n8) + Long.parseLong(string4.substring(0, n8));
                    long l3 = Long.parseLong(string4.substring(n8, n8 + n3 + 1));
                    DoubleFormatUtil.format(stringBuffer, n3, l, l3);
                }
            } else {
                int n11 = n3 - (n8 = -n8) + 1;
                if (n11 < 0) {
                    stringBuffer.append('0');
                } else if (n11 == 0) {
                    long l = Long.parseLong(string3);
                    DoubleFormatUtil.format(stringBuffer, n3, 0L, l);
                } else if (n9 < n11) {
                    long l = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n9 + 1) + Long.parseLong(string4) * 10L;
                    DoubleFormatUtil.format(stringBuffer, n8 + n9, 0L, l);
                } else {
                    long l = Long.parseLong(string4.substring(0, n11));
                    long l4 = Long.parseLong(string3) * DoubleFormatUtil.tenPow(n11) + l;
                    DoubleFormatUtil.format(stringBuffer, n3, 0L, l4);
                }
            }
        }
    }

    private static boolean isRoundedToZero(double d, int n, int n2) {
        return d == 0.0 || Math.abs(d) < 4.999999999999999 / DoubleFormatUtil.tenPowDouble(Math.max(n, n2) + 1);
    }

    public static long tenPow(int n) {
        assert (n >= 0);
        return n < POWERS_OF_TEN_LONG.length ? POWERS_OF_TEN_LONG[n] : (long)Math.pow(10.0, n);
    }

    private static double tenPowDouble(int n) {
        assert (n >= 0);
        return n < POWERS_OF_TEN_DOUBLE.length ? POWERS_OF_TEN_DOUBLE[n] : Math.pow(10.0, n);
    }

    private static void format(StringBuffer stringBuffer, int n, long l, long l2) {
        if (l2 != 0L) {
            l2 += 5L;
            if ((double)(l2 /= 10L) >= DoubleFormatUtil.tenPowDouble(n)) {
                ++l;
                l2 -= DoubleFormatUtil.tenPow(n);
            }
            if (l2 != 0L) {
                while (l2 % 10L == 0L) {
                    l2 /= 10L;
                    --n;
                }
            }
        }
        stringBuffer.append(l);
        if (l2 != 0L) {
            stringBuffer.append('.');
            while (n > 0 && (n > 18 ? (double)l2 < DoubleFormatUtil.tenPowDouble(--n) : l2 < DoubleFormatUtil.tenPow(--n))) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l2);
        }
    }

    public static void formatDoubleFast(double d, int n, int n2, StringBuffer stringBuffer) {
        double d2;
        if (DoubleFormatUtil.isRoundedToZero(d, n, n2)) {
            stringBuffer.append('0');
            return;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            stringBuffer.append(Double.toString(d));
            return;
        }
        boolean bl = d >= 0.0;
        d = Math.abs(d);
        int n3 = d >= 1.0 ? n : n2;
        long l = (long)Math.floor(d);
        double d3 = (d - (double)l) * (d2 = DoubleFormatUtil.tenPowDouble(n3));
        long l2 = Math.round(d3);
        if ((double)l2 >= d2) {
            ++l;
            l2 = Math.round((double)l2 - d2);
        }
        if (l2 != 0L) {
            while (l2 % 10L == 0L) {
                l2 /= 10L;
                --n3;
            }
        }
        if (l != 0L || l2 != 0L) {
            if (!bl) {
                stringBuffer.append('-');
            }
            stringBuffer.append(l);
            if (l2 != 0L) {
                stringBuffer.append('.');
                while (n3 > 0 && (double)l2 < DoubleFormatUtil.tenPowDouble(--n3)) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(l2);
            }
        } else {
            stringBuffer.append('0');
        }
    }

    public static int getExponant(double d) {
        long l = Double.doubleToRawLongBits(d) & 0x7FF0000000000000L;
        return (int)((l >>= 52) - 1023L);
    }

    private static boolean tooManyDigitsUsed(double d, int n) {
        double d2 = Math.log10(d);
        return n >= 308 || d2 + (double)n >= 14.5;
    }

    private static boolean tooCloseToRound(double d, int n) {
        d = Math.abs(d);
        long l = (long)Math.floor(d);
        double d2 = (d - (double)l) * DoubleFormatUtil.tenPowDouble(n);
        double d3 = Math.log10(d);
        double d4 = d3 + (double)n >= 12.0 ? 0.1 : 0.001;
        double d5 = Math.abs(d2 - Math.floor(d2));
        double d6 = Math.abs(d2 - Math.floor(d2) - 0.5);
        return d5 <= d4 || d6 <= d4;
    }

    static {
        int n;
        POWERS_OF_TEN_LONG = new long[19];
        POWERS_OF_TEN_DOUBLE = new double[30];
        DoubleFormatUtil.POWERS_OF_TEN_LONG[0] = 1L;
        for (n = 1; n < POWERS_OF_TEN_LONG.length; ++n) {
            DoubleFormatUtil.POWERS_OF_TEN_LONG[n] = POWERS_OF_TEN_LONG[n - 1] * 10L;
        }
        for (n = 0; n < POWERS_OF_TEN_DOUBLE.length; ++n) {
            DoubleFormatUtil.POWERS_OF_TEN_DOUBLE[n] = Double.parseDouble("1e" + n);
        }
    }
}

